/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractFlowCommand;
import com.datical.liquibase.ext.command.FlowValidateCommandStep;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.flow.condition.FlowStringUtil;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.flow.provider.StageGlobalArgsValueProvider;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.FlowFileRoot;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFailedException;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcObject;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;
import org.apache.commons.text.WordUtils;

public class FlowCommandStep
extends AbstractFlowCommand {
    public static final String[] COMMAND_NAME = new String[]{"flow"};
    public static final CommandArgumentDefinition<String> FLOW_FILE;
    public static final CommandArgumentDefinition<String> FLOW_INTEGRATION;
    public static final CommandArgumentDefinition<Boolean> FLOW_FILE_STRICT_PARSING;
    public static final CommandArgumentDefinition<String> FLOW_SHELL_INTERPRETER;
    public static final CommandArgumentDefinition<Boolean> FLOW_SHELL_KEEP_TEMP_FILES;
    public static final CommandArgumentDefinition<FlowFile> FLOW_FILE_DTO;
    public static final String DEFAULT_FLOW_FILE_NAME = "liquibase.flowfile.yaml";
    public static final String BANNER = "******************************************************************************";
    public static final String STATUS_CODE = "statusCode";
    public static final String FAIL = "Fail";
    public static final String SUCCESS = "Success";
    private Boolean validated;
    private FlowFileLoad flowFileLoad;

    @Override
    public void validate(CommandScope commandScope) throws CommandValidationException {
        super.validate(commandScope);
        try {
            CommandScope validationScope = new CommandScope(FlowValidateCommandStep.COMMAND_NAME);
            for (Map.Entry validateArgument : validationScope.getCommand().getArguments().entrySet()) {
                ConfiguredValue configuredValue = commandScope.getConfiguredValue((CommandArgumentDefinition)validateArgument.getValue());
                if (configuredValue.wasDefaultValueUsed()) continue;
                validationScope.addArgumentValue((String)validateArgument.getKey(), configuredValue.getValue());
            }
            CommandResults results = validationScope.execute();
            this.validated = (Boolean)results.getResult("validated");
            this.flowFileLoad = (FlowFileLoad)results.getResult("flowFilePath");
        }
        catch (CommandExecutionException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error during validation", (Throwable)e);
            throw new CommandValidationException("Error during validation: " + e.getMessage());
        }
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        String startTimeString;
        LinkedHashMap<String, Stage> stages;
        CommandScope commandScope;
        FlowFile flowFile;
        block50: {
            if (this.validated == null || Boolean.FALSE.equals(this.validated)) {
                resultsBuilder.addResult(STATUS_CODE, (Object)0);
                return;
            }
            FlowFile flowFile2 = flowFile = this.flowFileLoad != null ? this.flowFileLoad.flowFile : null;
            if (flowFile == null) {
                resultsBuilder.addResult(STATUS_CODE, (Object)0);
                return;
            }
            commandScope = resultsBuilder.getCommandScope();
            stages = flowFile.getStages();
            startTimeString = Instant.ofEpochMilli(new Date().getTime()).toString();
            int maxExitCode = 0;
            CommandExecutionException commandExecutionException = null;
            String currentStageName = null;
            Map<String, Object> userMetadata = flowFile.getUserMetadata();
            if (!CollectionUtil.createIfNull(userMetadata).isEmpty()) {
                Scope.getCurrentScope().addMdcValue("userMetadata", userMetadata);
            }
            try {
                OutputStream outputStream;
                if (stages == null || stages.isEmpty()) {
                    Scope.getCurrentScope().getUI().sendMessage("No stages found.");
                } else {
                    FlowFileLoad parentFlowFileLoad = this.flowFileLoad;
                    for (Map.Entry<String, Stage> stageEntry : stages.entrySet()) {
                        currentStageName = stageEntry.getKey();
                        this.executeStage(stageEntry.getValue(), currentStageName, resultsBuilder, flowFile);
                    }
                    this.flowFileLoad = parentFlowFileLoad;
                }
                this.executeStage(flowFile.getEndStage(), "endStage", resultsBuilder, flowFile);
                for (Map.Entry entry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                    outputStream = (OutputStream)entry.getValue();
                    String filename = (String)entry.getKey();
                    try {
                        outputStream.close();
                    }
                    catch (Exception e) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file " + filename, (Throwable)e);
                    }
                }
                break block50;
                finally {
                    for (Map.Entry<String, OutputStream> entry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                        outputStream = entry.getValue();
                        String filename = entry.getKey();
                        try {
                            outputStream.close();
                        }
                        catch (Exception e) {
                            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file " + filename, (Throwable)e);
                        }
                    }
                    break block50;
                }
            }
            catch (CommandExecutionException e) {
                maxExitCode = this.findExitCode(e);
                commandExecutionException = e;
                this.showExceptionMessageOnConsole(commandExecutionException);
                this.handleCommandExecutionException(flowFile, commandScope, stages, startTimeString, currentStageName, false, e);
            }
            catch (CommandExecutionException cee) {
                int n = this.findExitCode(cee);
                if (n > maxExitCode || commandExecutionException == null) {
                    commandExecutionException = cee;
                } else {
                    this.showExceptionMessageOnConsole(cee);
                }
                this.handleCommandExecutionException(flowFile, commandScope, stages, startTimeString, currentStageName, true, commandExecutionException);
            }
            finally {
                try {
                    this.executeStage(flowFile.getEndStage(), "endStage", resultsBuilder, flowFile);
                }
                catch (CommandExecutionException cee) {
                    int n = this.findExitCode(cee);
                    if (n > maxExitCode || commandExecutionException == null) {
                        commandExecutionException = cee;
                    } else {
                        this.showExceptionMessageOnConsole(cee);
                    }
                    this.handleCommandExecutionException(flowFile, commandScope, stages, startTimeString, currentStageName, true, commandExecutionException);
                }
                finally {
                    for (Map.Entry<String, OutputStream> entry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                        OutputStream outputStream = entry.getValue();
                        String filename = entry.getKey();
                        try {
                            outputStream.close();
                        }
                        catch (Exception e) {
                            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file " + filename, (Throwable)e);
                        }
                    }
                }
            }
        }
        this.addFlowInfoToMdc(flowFile, commandScope, stages, startTimeString, null, null);
        resultsBuilder.addResult(STATUS_CODE, (Object)0);
    }

    private void showExceptionMessageOnConsole(CommandExecutionException cee) {
        String message = cee.getMessage();
        if (StringUtil.isNotEmpty((String)message)) {
            message = message.replaceAll("liquibase.exception.*: ", "");
            message = "ERROR: " + message;
            Scope.getCurrentScope().getUI().sendErrorMessage(message);
        }
    }

    private int findExitCode(CommandExecutionException cee) {
        Throwable e;
        for (e = cee; e != null && !(e instanceof CommandFailedException); e = (Exception)e.getCause()) {
        }
        if (e != null) {
            return ((CommandFailedException)e).getExitCode();
        }
        return 0;
    }

    private void handleCommandExecutionException(FlowFile flowFile, CommandScope commandScope, LinkedHashMap<String, Stage> stages, String startTimeString, String currentStageName, boolean replaceMessage, CommandExecutionException cee) throws CommandExecutionException, CommandFailedException {
        this.addFlowInfoToMdc(flowFile, commandScope, stages, startTimeString, currentStageName, cee.getMessage());
        Scope.getCurrentScope().getLog(FlowCommandStep.class).warning("Exception occurred", (Throwable)cee);
        CommandFailedException returnException = this.findCommandFailedException((Exception)((Object)cee));
        if (returnException != null) {
            String message = returnException.getMessage();
            if (replaceMessage) {
                message = message.replaceAll("(.*?) command", "Flow command");
                throw new CommandFailedException(returnException.getResults(), returnException.getExitCode().intValue(), message, true);
            }
            throw returnException;
        }
        throw cee;
    }

    private CommandFailedException findCommandFailedException(Exception e) {
        while (e != null && e.getCause() != null) {
            Throwable t = e.getCause();
            if (t instanceof CommandFailedException) {
                return (CommandFailedException)t;
            }
            e = (Exception)e.getCause();
        }
        return null;
    }

    private void addFlowInfoToMdc(FlowFile flowFile, CommandScope commandScope, LinkedHashMap<String, Stage> stages, String startTimeString, String currentStageName, String failureMessage) {
        if (stages == null || stages.isEmpty()) {
            return;
        }
        String stopTimeString = Instant.ofEpochMilli(new Date().getTime()).toString();
        Scope.getCurrentScope().getMdcManager().clear();
        String name = (String)commandScope.getConfiguredValue(FLOW_FILE).getValue();
        Stage endStage = flowFile.getEndStage();
        FlowFileRoot flowFileRoot = new FlowFileRoot(name, this.flowFileLoad, stages, endStage);
        try (MdcObject flowFileStartTime = Scope.getCurrentScope().addMdcValue("flowStart", startTimeString);
             MdcObject flowFileRootMdc = Scope.getCurrentScope().addMdcValue("flowFileRoot", (CustomMdcObject)flowFileRoot);
             MdcObject flowFileStopTime = Scope.getCurrentScope().addMdcValue("flowStop", stopTimeString);
             MdcObject flowFileOutcome = Scope.getCurrentScope().addMdcValue("flowFileOutcome", currentStageName != null ? FAIL : SUCCESS);
             MdcObject flowFileError = this.handleFlowFileError(currentStageName, failureMessage);){
            String flowMessage = "Flow command complete";
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(flowMessage);
        }
    }

    private MdcObject handleFlowFileError(String currentStageName, String failureMessage) {
        if (currentStageName == null) {
            return null;
        }
        Scope.getCurrentScope().addMdcValue("flowFileFailedStage", currentStageName);
        return Scope.getCurrentScope().addMdcValue("flowFileFailedMessage", failureMessage);
    }

    private void executeStage(Stage stage, String stageName, CommandResultsBuilder resultsBuilder, FlowFile flowFile) throws Exception {
        Scope.child(Collections.emptyMap(), () -> {
            if (stage == null) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Empty stage '" + stageName + "' found"));
                return;
            }
            Map<String, Object> userMetadata = stage.getCombinedUserMetadata(flowFile.getUserMetadata());
            if (!CollectionUtil.createIfNull(userMetadata).isEmpty()) {
                Scope.getCurrentScope().addMdcValue("userMetadata", userMetadata);
            }
            if (stage.getActions() == null || stage.getActions().isEmpty()) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("No actions found for Stage: " + stageName));
                return;
            }
            if (stage.getCondition() != null && !stage.getCondition().evaluate()) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Skipping stage: " + stageName + " because condition '" + stage.getCondition().getRawConditionText() + "' evaluated to false."));
                return;
            }
            LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
            StageGlobalArgsValueProvider flowValueProvider = new StageGlobalArgsValueProvider(stage.getGlobalArgs());
            try {
                liquibaseConfiguration.registerProvider((ConfigurationValueProvider)flowValueProvider);
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Executing Stage: " + stageName));
                for (Action action : stage.getActions()) {
                    this.runAction(resultsBuilder, action, stage, flowFile);
                }
            }
            finally {
                liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)flowValueProvider);
            }
        });
    }

    protected void runAction(CommandResultsBuilder resultsBuilder, Action action, Stage stage, FlowFile flowFile) throws CommandExecutionException {
        if (action.getCondition() != null && !action.getCondition().evaluate()) {
            String actionString = action.toString();
            String originalConditionText = action.getCondition().getOriginalConditionText().replace(FlowStringUtil.class.getSimpleName() + ".", "");
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Skipping action: " + actionString + " because condition '" + originalConditionText + "' evaluated to false."));
            return;
        }
        try {
            Scope.getCurrentScope().addMdcValue("liquibaseCommandName", "flow");
            CommandScope commandScope = resultsBuilder.getCommandScope();
            HashMap<String, Object> scopedValues = new HashMap<String, Object>();
            scopedValues.put(FLOW_SHELL_INTERPRETER.getName(), commandScope.getArgumentValue(FLOW_SHELL_INTERPRETER));
            Scope.child(scopedValues, () -> {
                Map<String, Object> userMetadata = action.getCombinedUserMetadata(flowFile.getUserMetadata(), stage.getUserMetadata());
                if (!CollectionUtil.createIfNull(userMetadata).isEmpty()) {
                    Scope.getCurrentScope().addMdcValue("userMetadata", userMetadata);
                }
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner(String.format("Executing %s", action)));
                action.execute(resultsBuilder);
                Scope.getCurrentScope().getUI().sendMessage("");
            });
        }
        catch (Exception e) {
            throw new CommandExecutionException((Throwable)e);
        }
    }

    private String createBanner(String message) {
        return String.format("%s%n* %n* %s%n* %n%s%n", BANNER, WordUtils.wrap((String)message, (int)(BANNER.length() - 2)), BANNER);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Run a series of commands contained in one or more stages, as configured in a liquibase flow-file."));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        FLOW_FILE = commandBuilder.argument("flowFile", String.class).defaultValue((Object)DEFAULT_FLOW_FILE_NAME).description("The path to the configuration yaml file which contains one or more 'stages' of commands to be executed in a liquibase flow operation. Defaults to yaml file named \"liquibase.flowfile.yaml\" in the current working directory.").build();
        FLOW_INTEGRATION = commandBuilder.argument("flowIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing flow").build();
        FLOW_FILE_STRICT_PARSING = commandBuilder.argument("flowFileStrictParsing", Boolean.class).defaultValue((Object)true).description("Parse flow-file YAML to allow only Liquibase flow-file specific properties, indentations, and structure.").build();
        FLOW_SHELL_INTERPRETER = commandBuilder.argument("flowShellInterpreter", String.class).description("The default interpreter used to execute shell commands. EXAMPLES: bash, sh, cmd.").build();
        FLOW_SHELL_KEEP_TEMP_FILES = commandBuilder.argument("flowShellKeepTempFiles", Boolean.class).defaultValue((Object)false).description("Do not delete temporary files created by the shell command execution").build();
        FLOW_FILE_DTO = commandBuilder.argument("flowFileDTO", FlowFile.class).description("An already loaded FlowFile object").hidden().build();
    }
}

