/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SinglePendingChangeSetFilter;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.UpdateSummaryEnum;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.StatusChangeLogIterator;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandScope;
import liquibase.command.core.AbstractUpdateCommandStep;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.database.Database;
import liquibase.exception.CommandValidationException;
import liquibase.exception.LiquibaseException;

public class UpdateOneChangeSetCommandStep
extends AbstractUpdateCommandStep
implements CleanUpCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"updateOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<Boolean> OVERRIDE_CHANGESET_IGNORE_FLAG_ARG;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private Boolean force;
    private static final ResourceBundle coreBundle;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Runs single changeset"));
    }

    public String getChangelogFileArg(CommandScope commandScope) {
        return (String)commandScope.getArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_FILE_ARG);
    }

    public String getContextsArg(CommandScope commandScope) {
        return (String)commandScope.getArgumentValue(DatabaseChangelogCommandStep.CONTEXTS_ARG);
    }

    public String getLabelFilterArg(CommandScope commandScope) {
        return (String)commandScope.getArgumentValue(DatabaseChangelogCommandStep.LABEL_FILTER_ARG);
    }

    public String[] getCommandName() {
        return COMMAND_NAME;
    }

    public UpdateSummaryEnum getShowSummary(CommandScope commandScope) {
        return UpdateSummaryEnum.OFF;
    }

    public ChangeLogIterator getStatusChangelogIterator(CommandScope commandScope, Database database, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) throws LiquibaseException {
        List<ChangeSetFilter> changeSetFilters = this.getChangeSetFilters(commandScope, contexts, labelExpression, databaseChangeLog);
        return new StatusChangeLogIterator(databaseChangeLog, changeSetFilters.toArray(new ChangeSetFilter[0]));
    }

    private List<ChangeSetFilter> getChangeSetFilters(CommandScope commandScope, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) throws LiquibaseException {
        SinglePendingChangeSetFilter updateChangeSetFilter = new SinglePendingChangeSetFilter(this.changeSetId, this.changeSetAuthor, this.changeSetPath, databaseChangeLog);
        ArrayList<ChangeSetFilter> changeSetFilters = new ArrayList<ChangeSetFilter>();
        changeSetFilters.add(updateChangeSetFilter);
        changeSetFilters.add((ChangeSetFilter)new ContextChangeSetFilter(contexts));
        changeSetFilters.add((ChangeSetFilter)new LabelChangeSetFilter(labelExpression));
        if (!((Boolean)commandScope.getArgumentValue(OVERRIDE_CHANGESET_IGNORE_FLAG_ARG)).booleanValue()) {
            changeSetFilters.add((ChangeSetFilter)new IgnoreChangeSetFilter());
        }
        return changeSetFilters;
    }

    public ChangeLogIterator getStandardChangelogIterator(CommandScope commandScope, Database database, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog) throws LiquibaseException {
        List<ChangeSetFilter> changeSetFilters = this.getChangeSetFilters(commandScope, contexts, labelExpression, databaseChangeLog);
        return new ChangeLogIterator(databaseChangeLog, changeSetFilters);
    }

    protected void preRun(CommandScope commandScope, ChangeLogIterator runChangeLogIterator, ChangeLogParameters changeLogParameters) throws LiquibaseException {
        Database database = (Database)commandScope.getDependency(Database.class);
        StatusVisitor statusVisitor = new StatusVisitor(database);
        runChangeLogIterator.run((ChangeSetVisitor)statusVisitor, new RuntimeEnvironment(database, changeLogParameters.getContexts(), changeLogParameters.getLabels()));
        List changeSetsToSkip = statusVisitor.getChangeSetsToSkip();
        for (ChangeSetStatus changeSetStatus : changeSetsToSkip) {
            ChangeSet changeSet = changeSetStatus.getChangeSet();
            boolean wasIgnored = changeSetStatus.getFilterResults().stream().anyMatch(csfr -> csfr.getFilter().isAssignableFrom(IgnoreChangeSetFilter.class));
            boolean wasMatchedToArgs = changeSetStatus.getFilterResults().stream().noneMatch(csfr -> csfr.getFilter().isAssignableFrom(SinglePendingChangeSetFilter.class));
            if (!wasIgnored || !wasMatchedToArgs) continue;
            Scope.getCurrentScope().getUI().sendMessage("INFO: The changeset (id: " + changeSet.getId() + ", author: " + changeSet.getAuthor() + ", filepath: " + changeSet.getFilePath() + " was skipped because the \"ignore=true\" attribute was set.");
        }
    }

    public void validate(CommandScope commandScope) throws CommandValidationException {
        this.checkArgs(commandScope, true);
    }

    protected void checkArgs(CommandScope commandScope, boolean shouldCheckForceParam) throws CommandValidationException {
        this.changeSetId = (String)commandScope.getArgumentValue(CHANGESET_ID_ARG);
        this.changeSetAuthor = (String)commandScope.getArgumentValue(CHANGESET_AUTHOR_ARG);
        this.changeSetPath = (String)commandScope.getArgumentValue(CHANGESET_PATH_ARG);
        this.force = (Boolean)commandScope.getArgumentValue(FORCE_ARG);
        Scope.getCurrentScope().addMdcValue("updateOneChangesetForce", String.valueOf(this.force));
        if (this.changeSetId == null || this.changeSetAuthor == null || this.changeSetPath == null) {
            throw new CommandValidationException(coreBundle.getString("id.author.path.required"));
        }
        if (shouldCheckForceParam && (this.force == null || !this.force.booleanValue())) {
            String messageString = "\nWARNING: Targeted update of this changeset may result in unexpected outcomes.  To review the update\nSQL before executing it, please run 'update-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new CommandValidationException(messageString);
        }
    }

    static {
        coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID_ARG = commandBuilder.argument("changesetId", String.class).description("Id of the changeset to execute").required().build();
        CHANGESET_AUTHOR_ARG = commandBuilder.argument("changesetAuthor", String.class).description("Author of the changeset to execute").required().build();
        CHANGESET_PATH_ARG = commandBuilder.argument("changesetPath", String.class).description("Path to the changeset to execute").required().build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)false).build();
        OVERRIDE_CHANGESET_IGNORE_FLAG_ARG = commandBuilder.argument("overrideChangesetIgnoreFlag", Boolean.class).description("If true, the ignore flag on the changeset will be ignored, and the changeset will be run regardless of the ignore flag.").defaultValue((Object)false).hidden().build();
    }
}

