/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.drift;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.reports.drift.ReportObject;
import com.datical.liquibase.ext.reports.drift.ReportObjectContainer;
import com.datical.liquibase.ext.reports.drift.TextDriftReport;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changeset.ChangeSetService;
import liquibase.changeset.ChangeSetServiceFactory;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorFactory;
import liquibase.exception.DatabaseException;
import liquibase.repackaged.com.github.difflib.DiffUtils;
import liquibase.repackaged.com.github.difflib.UnifiedDiffUtils;
import liquibase.repackaged.com.github.difflib.patch.Patch;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.SqlFormatter;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.core.formattedsql.FormattedSqlChangeLogSerializer;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.structure.core.View;
import liquibase.util.StringUtil;

public class UnifiedDiffUtil {
    public static String generateUnifiedSqlDiff(TextDriftReport textDriftReport) throws DatabaseException {
        List<ReportObjectContainer> missingValues = textDriftReport.getMissing();
        List<ReportObjectContainer> unexpectedValues = textDriftReport.getUnexpected();
        List<ReportObjectContainer> changedValues = textDriftReport.getChanged();
        DiffResult diffResult = textDriftReport.getDiffResult();
        DatabaseSnapshot targetSnapshot = diffResult.getComparisonSnapshot();
        DatabaseSnapshot referenceSnapshot = diffResult.getReferenceSnapshot();
        Map<ReportObject, String> targetCreateStatements = UnifiedDiffUtil.buildObjectSql(targetSnapshot);
        Map<ReportObject, String> referenceCreateStatements = UnifiedDiffUtil.buildObjectSql(referenceSnapshot);
        SqlDiff sqlDiff = new SqlDiff(targetCreateStatements, referenceCreateStatements);
        LinkedHashSet unified = new LinkedHashSet();
        missingValues.forEach(reportObjectContainer -> reportObjectContainer.getResults().forEach(reportObject -> {
            Optional<String> maybeDiff = UnifiedDiffUtil.generateUnifiedDiff(sqlDiff, reportObject);
            maybeDiff.ifPresent(unified::add);
        }));
        unexpectedValues.forEach(reportObjectContainer -> reportObjectContainer.getResults().forEach(reportObject -> {
            Optional<String> maybeDiff = UnifiedDiffUtil.generateUnifiedDiff(sqlDiff, reportObject);
            maybeDiff.ifPresent(unified::add);
        }));
        changedValues.forEach(reportObjectContainer -> reportObjectContainer.getResults().forEach(reportObject -> {
            String modifiedResult = reportObject.getObjectString();
            if (modifiedResult != null && modifiedResult.contains(":")) {
                modifiedResult = modifiedResult.split(":")[0];
            }
            ReportObject newResults = new ReportObject(reportObject.getType(), modifiedResult, reportObject.getDatabaseObject(), reportObject.getParentObjects());
            Optional<String> maybeDiff = UnifiedDiffUtil.generateUnifiedDiff(sqlDiff, newResults);
            maybeDiff.ifPresent(unified::add);
        }));
        return StringUtil.join(unified, (String)"\n");
    }

    private static Optional<String> generateUnifiedDiff(SqlDiff sqlDiff, ReportObject reportObject) {
        String targetCreate = sqlDiff.getTargetCreateStatements().getOrDefault(reportObject, "");
        String referenceCreate = sqlDiff.getReferenceCreateStatements().getOrDefault(reportObject, "");
        targetCreate = targetCreate.isEmpty() ? UnifiedDiffUtil.getParentSql(sqlDiff.getTargetCreateStatements(), reportObject).orElse("") : targetCreate;
        referenceCreate = referenceCreate.isEmpty() ? UnifiedDiffUtil.getParentSql(sqlDiff.getReferenceCreateStatements(), reportObject).orElse("") : referenceCreate;
        ReportObject namingReportObject = reportObject;
        if (!UnifiedDiffUtil.isBaseComparableObjectType(reportObject.getDatabaseObject()) && reportObject.getParentObjects() != null) {
            namingReportObject = UnifiedDiffUtil.buildReportObject(Arrays.stream(reportObject.getParentObjects()).findFirst().orElse(reportObject.getDatabaseObject()));
        }
        if (!targetCreate.isEmpty() || !referenceCreate.isEmpty()) {
            ArrayList<String> targetLines = !targetCreate.isEmpty() ? Arrays.asList(targetCreate.split("\n")) : new ArrayList();
            List<Object> referenceLines = !referenceCreate.isEmpty() ? Arrays.asList(referenceCreate.split("\n")) : new ArrayList();
            Patch<String> diff = DiffUtils.diff(targetLines, referenceLines);
            List<String> unifiedDiffLines = UnifiedDiffUtils.generateUnifiedDiff("target", String.format("source | %s: %s: %s", "Changes on", namingReportObject.getType(), namingReportObject.getObjectString()), targetLines, diff, 20);
            return Optional.of(StringUtil.join(unifiedDiffLines, (String)"\n"));
        }
        return Optional.empty();
    }

    private static Optional<String> getParentSql(Map<ReportObject, String> createStatements, ReportObject reportObject) {
        if (reportObject.getParentObjects() != null) {
            StringBuilder builder = new StringBuilder();
            for (DatabaseObject parentObject : reportObject.getParentObjects()) {
                ReportObject parentReportObject = UnifiedDiffUtil.buildReportObject(parentObject);
                String statement = createStatements.get(parentReportObject);
                if (statement == null) continue;
                builder.append(statement);
                builder.append("\n");
            }
            return Optional.of(builder.toString());
        }
        return Optional.empty();
    }

    private static ChangeSet buildChangeSets(DatabaseObject databaseObject, DatabaseChangeLog databaseChangeLog, DiffResult emptyDbDiffResults) {
        Change[] changes;
        ChangeSetService service = ChangeSetServiceFactory.getInstance().createChangeSetService();
        ChangeSet changeSet = service.createChangeSet("temp-id", "generated", false, false, String.format("out.%s.sql", emptyDbDiffResults.getReferenceSnapshot().getDatabase().getShortName()), null, null, databaseChangeLog);
        ChangeGeneratorFactory factory = ChangeGeneratorFactory.getInstance();
        DiffOutputControl diffOutputControl = new DiffOutputControl(false, true, true, null);
        HashMap<String, Boolean> scopeValues = new HashMap<String, Boolean>();
        scopeValues.put(LiquibaseProConfiguration.INLINE_SQL_KEY.getKey(), true);
        try {
            changes = (Change[])Scope.child(scopeValues, () -> factory.fixMissing(databaseObject, diffOutputControl, emptyDbDiffResults.getReferenceSnapshot().getDatabase(), emptyDbDiffResults.getComparisonSnapshot().getDatabase()));
        }
        catch (Exception exception) {
            changes = null;
        }
        if (changes != null) {
            for (Change change : changes) {
                changeSet.addChange(change);
            }
        }
        return changeSet;
    }

    private static DiffResult getDiffResultsAgainstEmptyDb(DatabaseSnapshot databaseSnapshot) throws DatabaseException {
        CompareControl.SchemaComparison[] schemaComparisons = new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(new CatalogAndSchema(null, null), new CatalogAndSchema(null, null))};
        if (databaseSnapshot.getSchemaComparisons() != null && databaseSnapshot.getSchemaComparisons().length > 0) {
            schemaComparisons = databaseSnapshot.getSchemaComparisons();
        }
        return DiffGeneratorFactory.getInstance().compare(databaseSnapshot, null, new CompareControl(schemaComparisons, databaseSnapshot.getSnapshotControl().getTypesToInclude()));
    }

    private static Map<ReportObject, String> buildObjectSql(DatabaseSnapshot databaseSnapshot) throws DatabaseException {
        DiffResult diffResult = UnifiedDiffUtil.getDiffResultsAgainstEmptyDb(databaseSnapshot);
        HashMap<ReportObject, String> sqlMap = new HashMap<ReportObject, String>();
        FormattedSqlChangeLogSerializer serializer = new FormattedSqlChangeLogSerializer();
        for (DatabaseObject databaseObject : diffResult.getMissingObjects()) {
            boolean notBaseComparableObject;
            boolean bl = notBaseComparableObject = !UnifiedDiffUtil.isBaseComparableObjectType(databaseObject);
            if (databaseObject.getContainingObjects() != null && notBaseComparableObject) {
                for (DatabaseObject parentObject : databaseObject.getContainingObjects()) {
                    if (UnifiedDiffUtil.isObjectTypeGeneratedWithTable(parentObject)) continue;
                    String sql = parentObject instanceof Table ? UnifiedDiffUtil.getTableSql((Table)parentObject, diffResult, serializer) : UnifiedDiffUtil.buildFormattedSql(parentObject, diffResult, serializer);
                    sqlMap.put(UnifiedDiffUtil.isBaseComparableObjectType(parentObject) ? UnifiedDiffUtil.buildReportObject(parentObject) : UnifiedDiffUtil.buildReportObject(databaseObject), sql);
                }
                continue;
            }
            if (databaseObject instanceof Table) {
                sqlMap.put(UnifiedDiffUtil.buildReportObject(databaseObject), UnifiedDiffUtil.getTableSql((Table)databaseObject, diffResult, serializer));
                continue;
            }
            String sql = UnifiedDiffUtil.buildFormattedSql(databaseObject, diffResult, serializer);
            sqlMap.put(UnifiedDiffUtil.buildReportObject(databaseObject), sql);
        }
        return sqlMap;
    }

    private static boolean isBaseComparableObjectType(DatabaseObject databaseObject) {
        return databaseObject instanceof Table || databaseObject instanceof View || databaseObject instanceof Function || databaseObject instanceof StoredProcedure || databaseObject instanceof Trigger || databaseObject instanceof DatabasePackage || databaseObject instanceof DatabasePackageBody || databaseObject instanceof Synonym;
    }

    private static boolean isObjectTypeGeneratedWithTable(DatabaseObject databaseObject) {
        return databaseObject instanceof Column || databaseObject instanceof Index || databaseObject instanceof UniqueConstraint || databaseObject instanceof ForeignKeyConstraint || databaseObject instanceof ForeignKey;
    }

    private static String getTableSql(Table table, DiffResult diffResult, FormattedSqlChangeLogSerializer serializer) {
        String tableSql = UnifiedDiffUtil.buildFormattedSql((DatabaseObject)table, diffResult, serializer);
        String primaryKeyName = table.getPrimaryKey() != null ? table.getPrimaryKey().getName() : "";
        ArrayList<String> tableAttributesSqlList = new ArrayList<String>();
        for (Index index : table.getIndexes()) {
            if (primaryKeyName.equals(index.getName())) continue;
            tableAttributesSqlList.add(UnifiedDiffUtil.buildFormattedSql((DatabaseObject)index, diffResult, serializer));
        }
        for (ForeignKey foreignKey : table.getOutgoingForeignKeys()) {
            tableAttributesSqlList.add(UnifiedDiffUtil.buildFormattedSql((DatabaseObject)foreignKey, diffResult, serializer));
        }
        if (!table.getUniqueConstraints().isEmpty()) {
            String warningComment = "\n--WARNING: Unique constraints may conflict with unique indexes. Please examine the sql before execution.";
            tableAttributesSqlList.add(warningComment);
            for (UniqueConstraint uniqueConstraint : table.getUniqueConstraints()) {
                tableAttributesSqlList.add(UnifiedDiffUtil.buildFormattedSql((DatabaseObject)uniqueConstraint, diffResult, serializer));
            }
        }
        return String.format("%s\n%s", tableSql, StringUtil.join(tableAttributesSqlList, (String)"\n"));
    }

    private static ReportObject buildReportObject(DatabaseObject databaseObject) {
        return new ReportObject(databaseObject.getObjectTypeName(), databaseObject.toString(), databaseObject, databaseObject.getContainingObjects());
    }

    private static String buildFormattedSql(DatabaseObject databaseObject, DiffResult diffResult, FormattedSqlChangeLogSerializer serializer) {
        String sql = serializer.serialize((LiquibaseSerializable)UnifiedDiffUtil.buildChangeSets(databaseObject, new DatabaseChangeLog(), diffResult), true);
        sql = sql.replace("-- changeset generated:temp-id\n", "");
        return SqlFormatter.format(sql);
    }

    public static class SqlDiff {
        private Map<ReportObject, String> targetCreateStatements;
        private Map<ReportObject, String> referenceCreateStatements;

        public Map<ReportObject, String> getTargetCreateStatements() {
            return this.targetCreateStatements;
        }

        public Map<ReportObject, String> getReferenceCreateStatements() {
            return this.referenceCreateStatements;
        }

        public SqlDiff(Map<ReportObject, String> targetCreateStatements, Map<ReportObject, String> referenceCreateStatements) {
            this.targetCreateStatements = targetCreateStatements;
            this.referenceCreateStatements = referenceCreateStatements;
        }
    }
}

