/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint;

import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DropCheckConstraintChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class UnexpectedCheckConstraintChangeGenerator
extends LicenseCheckingChangeGenerator
implements UnexpectedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (CheckConstraint.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Table.class};
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        CheckConstraint constraint = (CheckConstraint)unexpectedObject;
        if (constraint.getTable() == null) {
            return null;
        }
        DropCheckConstraintChange change = new DropCheckConstraintChange();
        change.setTableName(constraint.getTable().getName());
        if (control.getIncludeCatalog()) {
            change.setCatalogName(constraint.getTable().getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSchemaName(constraint.getTable().getSchema().getName());
        }
        change.setConstraintName(constraint.getName());
        return new Change[]{change};
    }
}

