/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.DropPackageBodyStatement;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class DropPackageBodyGenerator
extends AbstractSqlGenerator<DropPackageBodyStatement> {
    public boolean supports(DropPackageBodyStatement dropPackageBodyStatement, Database database) {
        return database instanceof DB2Database || database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase;
    }

    public ValidationErrors validate(DropPackageBodyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("packageBodyName", (Object)statement.getPackageBodyName());
        return validationErrors;
    }

    public Sql[] generateSql(DropPackageBodyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new Sql[]{new UnparsedSql("DROP PACKAGE BODY " + database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getPackageBodyName(), DatabasePackageBody.class), new DatabaseObject[]{((DatabasePackageBody)new DatabasePackageBody().setName(statement.getPackageBodyName())).setSchema(new Schema(statement.getCatalogName(), statement.getSchemaName()))})};
    }
}

