/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;

public class MissingTriggerChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Trigger.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        Trigger trigger = (Trigger)databaseObject;
        CreateTriggerChange createTriggerChange = new CreateTriggerChange();
        createTriggerChange.setTriggerBody(trigger.getBody());
        createTriggerChange.setTriggerName(trigger.getName());
        if (database2 instanceof MSSQLDatabase && ((Trigger)databaseObject).getCatalog() != null) {
            createTriggerChange.setScope("CATALOG");
        }
        createTriggerChange.setTableName(trigger.getTableName());
        createTriggerChange.setDisabled(trigger.isDisabled());
        if (diffOutputControl.getIncludeCatalog()) {
            if (((Trigger)databaseObject).getCatalog() == null) {
                createTriggerChange.setCatalogName(databaseObject.getSchema().getCatalogName());
            } else {
                createTriggerChange.setCatalogName(((Trigger)databaseObject).getCatalog().getName());
            }
        }
        if (diffOutputControl.getIncludeSchema() && databaseObject.getSchema() != null) {
            createTriggerChange.setSchemaName(trigger.getSchema().getName());
        }
        if (database instanceof MSSQLDatabase && !createTriggerChange.getTriggerBody().toUpperCase().contains("AS EXTERNAL NAME")) {
            createTriggerChange.setReplaceIfExists(true);
        }
        return MissingTriggerChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{createTriggerChange});
    }
}

