/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.util.Date;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseManagementContext;
import net.java.truelicense.core.LicenseSubjectProvider;
import net.java.truelicense.core.LicenseValidation;
import net.java.truelicense.core.LicenseValidationException;
import net.java.truelicense.core.Messages;
import net.java.truelicense.core.util.Clock;
import net.java.truelicense.core.util.ContextProvider;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Immutable
final class BasicLicenseValidation
implements ContextProvider<LicenseManagementContext>,
Clock,
LicenseSubjectProvider,
LicenseValidation {
    private final LicenseManagementContext context;
    static final /* synthetic */ boolean $assertionsDisabled;

    BasicLicenseValidation(LicenseManagementContext licenseManagementContext) {
        if (!$assertionsDisabled && null == licenseManagementContext) {
            throw new AssertionError();
        }
        this.context = licenseManagementContext;
    }

    @Override
    public LicenseManagementContext context() {
        return this.context;
    }

    @Override
    public String subject() {
        return this.context().subject();
    }

    @Override
    public Date now() {
        return this.context().now();
    }

    @Override
    public void validate(License license) throws LicenseValidationException {
        if (0 >= license.getConsumerAmount()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.CONSUMER_AMOUNT_IS_NOT_POSITIVE(), license.getConsumerAmount()));
        }
        if (null == license.getConsumerType()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.CONSUMER_TYPE_IS_NULL(), new Object[0]));
        }
        if (null == license.getHolder()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.HOLDER_IS_NULL(), new Object[0]));
        }
        if (null == license.getIssued()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.ISSUED_IS_NULL(), new Object[0]));
        }
        if (null == license.getIssuer()) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.ISSUER_IS_NULL(), new Object[0]));
        }
        Date date = this.now();
        Date date2 = license.getNotAfter();
        if (null != date2 && date.after(date2)) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.LICENSE_HAS_EXPIRED(), date2));
        }
        Date date3 = license.getNotBefore();
        if (null != date3 && date.before(date3)) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.LICENSE_IS_NOT_YET_VALID(), date3));
        }
        if (!this.subject().equals(license.getSubject())) {
            throw new LicenseValidationException(Messages.message(BasicLicenseValidation.INVALID_SUBJECT(), license.getSubject(), this.subject()));
        }
    }

    static {
        BasicLicenseValidation.$assertionsDisabled = !BasicLicenseValidation.class.desiredAssertionStatus();
    }

    static final /* synthetic */ String INVALID_SUBJECT() {
        return new ObfuscatedString(new long[]{-5663582374319369367L, -7359928959411128367L, -7259900755881028022L}).toString();
    }

    static final /* synthetic */ String HOLDER_IS_NULL() {
        return new ObfuscatedString(new long[]{2542685051868238933L, -7832935182623153890L, -8016219030261047798L}).toString();
    }

    static final /* synthetic */ String ISSUER_IS_NULL() {
        return new ObfuscatedString(new long[]{-8538895773923879620L, 6038995120407680095L, -9093477861322569489L}).toString();
    }

    static final /* synthetic */ String ISSUED_IS_NULL() {
        return new ObfuscatedString(new long[]{-3400707290542808344L, -5946109518987312349L, -1689330656077806439L}).toString();
    }

    static final /* synthetic */ String LICENSE_IS_NOT_YET_VALID() {
        return new ObfuscatedString(new long[]{-2758547496357148595L, -4216256987702908812L, -4166606905393021172L, -260104314069323756L}).toString();
    }

    static final /* synthetic */ String LICENSE_HAS_EXPIRED() {
        return new ObfuscatedString(new long[]{-315187171325932895L, -6210251103246537147L, 1133472457130373635L, -4055870359305800046L}).toString();
    }

    static final /* synthetic */ String CONSUMER_TYPE_IS_NULL() {
        return new ObfuscatedString(new long[]{-8714856121641459312L, -2252529577715328436L, 2619607972356909008L, 9111388904303313065L}).toString();
    }

    static final /* synthetic */ String CONSUMER_AMOUNT_IS_NOT_POSITIVE() {
        return new ObfuscatedString(new long[]{-6159419851566758814L, -4966813685268966536L, -5907996552059389152L, -987073839113740051L, -4271268726300390675L}).toString();
    }
}

