/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.TrailingComma;
import org.openrewrite.groovy.marker.AsStyleTypeCast;
import org.openrewrite.groovy.marker.Elvis;
import org.openrewrite.groovy.marker.EmptyArgumentListPrecedesArgument;
import org.openrewrite.groovy.marker.ImplicitDot;
import org.openrewrite.groovy.marker.ImplicitReturn;
import org.openrewrite.groovy.marker.InStyleForEachLoop;
import org.openrewrite.groovy.marker.LambdaStyle;
import org.openrewrite.groovy.marker.MultiVariable;
import org.openrewrite.groovy.marker.NullSafe;
import org.openrewrite.groovy.marker.OmitParentheses;
import org.openrewrite.groovy.marker.RedundantDef;
import org.openrewrite.groovy.marker.Semicolon;
import org.openrewrite.groovy.marker.StarDot;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.groovy.tree.GContainer;
import org.openrewrite.groovy.tree.GRightPadded;
import org.openrewrite.groovy.tree.GSpace;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.marker.CompactConstructor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class GroovyPrinter<P>
extends GroovyVisitor<PrintOutputCapture<P>> {
    private final GroovyJavaPrinter delegate = new GroovyJavaPrinter();
    private static final UnaryOperator<String> JAVA_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof G)) {
            return this.delegate.visit(tree, p);
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J visitCompilationUnit(G.CompilationUnit cu, PrintOutputCapture<P> p) {
        if (cu.getShebang() != null) {
            p.append(cu.getShebang());
        }
        this.beforeSyntax((G)cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        JRightPadded<J.Package> pkg = cu.getPadding().getPackageDeclaration();
        if (pkg != null) {
            this.visit((Tree)pkg.getElement(), p);
            this.visitSpace(pkg.getAfter(), Space.Location.PACKAGE_SUFFIX, p);
        }
        for (JRightPadded<Statement> statement : cu.getPadding().getStatements()) {
            this.visitRightPadded(statement, GRightPadded.Location.TOP_LEVEL_STATEMENT_SUFFIX, p);
        }
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        this.afterSyntax(cu, p);
        return cu;
    }

    @Override
    public J visitGString(G.GString gString, PrintOutputCapture<P> p) {
        this.beforeSyntax((G)gString, GSpace.Location.GSTRING, p);
        String delimiter = gString.getDelimiter();
        if (delimiter == null) {
            delimiter = "\"";
        }
        p.append(delimiter);
        this.visit(gString.getStrings(), p);
        if ("$/".equals(delimiter)) {
            p.append("/$");
        } else {
            p.append(delimiter);
        }
        this.afterSyntax(gString, p);
        return gString;
    }

    @Override
    public J visitGStringValue(G.GString.Value value, PrintOutputCapture<P> p) {
        this.beforeSyntax((G)value, GSpace.Location.GSTRING, p);
        if (value.isEnclosedInBraces()) {
            p.append("${");
        } else {
            p.append("$");
        }
        this.visit((Tree)value.getTree(), p);
        this.visitSpace(value.getAfter(), GSpace.Location.GSTRING, p);
        if (value.isEnclosedInBraces()) {
            p.append('}');
        }
        this.afterSyntax(value, p);
        return value;
    }

    @Override
    public J visitListLiteral(G.ListLiteral listLiteral, PrintOutputCapture<P> p) {
        this.beforeSyntax((G)listLiteral, GSpace.Location.LIST_LITERAL, p);
        this.visitContainer("[", listLiteral.getPadding().getElements(), GContainer.Location.LIST_LITERAL_ELEMENTS, ",", "]", p);
        this.afterSyntax(listLiteral, p);
        return listLiteral;
    }

    @Override
    public J visitMapEntry(G.MapEntry mapEntry, PrintOutputCapture<P> p) {
        this.beforeSyntax((G)mapEntry, GSpace.Location.MAP_ENTRY, p);
        this.visitRightPadded(mapEntry.getPadding().getKey(), GRightPadded.Location.MAP_ENTRY_KEY, p);
        p.append(':');
        this.visit((Tree)mapEntry.getValue(), p);
        this.afterSyntax(mapEntry, p);
        return mapEntry;
    }

    @Override
    public J visitMapLiteral(G.MapLiteral mapLiteral, PrintOutputCapture<P> p) {
        this.beforeSyntax((G)mapLiteral, GSpace.Location.MAP_LITERAL, p);
        this.visitContainer("[", mapLiteral.getPadding().getElements(), GContainer.Location.MAP_LITERAL_ELEMENTS, ",", "]", p);
        this.afterSyntax(mapLiteral, p);
        return mapLiteral;
    }

    @Override
    public J visitBinary(G.Binary binary, PrintOutputCapture<P> p) {
        String keyword = "";
        switch (binary.getOperator()) {
            case Find: {
                keyword = "=~";
                break;
            }
            case Match: {
                keyword = "==~";
                break;
            }
            case Access: {
                keyword = "[";
                break;
            }
            case In: {
                keyword = "in";
            }
        }
        this.beforeSyntax((G)binary, GSpace.Location.BINARY_PREFIX, p);
        this.visit((Tree)binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), GSpace.Location.BINARY_OPERATOR, p);
        p.append(keyword);
        this.visit((Tree)binary.getRight(), p);
        if (binary.getOperator() == G.Binary.Type.Access) {
            this.visitSpace(binary.getAfter(), GSpace.Location.BINARY_SUFFIX, p);
            p.append("]");
        }
        this.afterSyntax(binary, p);
        return binary;
    }

    @Override
    public J visitRange(G.Range range, PrintOutputCapture<P> p) {
        this.beforeSyntax((G)range, GSpace.Location.RANGE_PREFIX, p);
        this.visit((Tree)range.getFrom(), p);
        this.visitSpace(range.getPadding().getInclusive().getBefore(), GSpace.Location.RANGE_INCLUSION, p);
        p.append(range.getInclusive() ? ".." : "..>");
        this.visit((Tree)range.getTo(), p);
        this.afterSyntax(range, p);
        return range;
    }

    @Override
    public Space visitSpace(Space space, GSpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, loc, p);
    }

    protected void visitContainer(String before, @Nullable JContainer<? extends J> container, GContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.append(after == null ? "" : after);
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, GRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        block0: for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            if (i < nodes.size() - 1) {
                p.append(suffixBetween);
                continue;
            }
            for (Marker m : node.getMarkers().getMarkers()) {
                if (m instanceof TrailingComma) {
                    p.append(suffixBetween);
                    this.visitSpace(((TrailingComma)m).getSuffix(), Space.Location.LANGUAGE_EXTENSION, p);
                    continue block0;
                }
                if (!(m instanceof org.openrewrite.java.marker.TrailingComma)) continue;
                p.append(suffixBetween);
                this.visitSpace(((org.openrewrite.java.marker.TrailingComma)m).getSuffix(), Space.Location.LANGUAGE_EXTENSION, p);
                continue block0;
            }
        }
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        return this.delegate.visitMarker(marker, p);
    }

    private void beforeSyntax(G g, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(g.getPrefix(), g.getMarkers(), loc, p);
    }

    private void beforeSyntax(G g, GSpace.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(g.getPrefix(), g.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers,  @Nullable GSpace.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void beforeSyntax(Space prefix, Markers markers, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(G g, PrintOutputCapture<P> p) {
        this.afterSyntax(g.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private class GroovyJavaPrinter
    extends JavaPrinter<P> {
        private GroovyJavaPrinter() {
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof G) {
                return GroovyPrinter.this.visit(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public J visitImport(J.Import import_, PrintOutputCapture<P> p) {
            J.Import i = (J.Import)super.visitImport(import_, p);
            JLeftPadded alias = i.getPadding().getAlias();
            if (alias == null) {
                return i;
            }
            this.visitSpace(alias.getBefore(), Space.Location.IMPORT_ALIAS_PREFIX, p);
            p.append("as");
            this.visitIdentifier((J.Identifier)alias.getElement(), p);
            return i;
        }

        public J visitTypeCast(J.TypeCast t, PrintOutputCapture<P> p) {
            if (!t.getMarkers().findFirst(AsStyleTypeCast.class).isPresent()) {
                return super.visitTypeCast(t, p);
            }
            this.beforeSyntax((J)t, Space.Location.TYPE_CAST_PREFIX, p);
            this.visit((Tree)t.getExpression(), p);
            this.visitSpace(t.getClazz().getPadding().getTree().getAfter(), Space.Location.CONTROL_PARENTHESES_PREFIX, p);
            p.append("as");
            this.visit((Tree)t.getClazz().getTree(), p);
            this.afterSyntax((J)t, p);
            return t;
        }

        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(multiVariable.getLeadingAnnotations(), p);
            multiVariable.getMarkers().findFirst(RedundantDef.class).ifPresent(def -> {
                this.visitSpace(def.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                p.append("def");
            });
            for (J.Modifier m : multiVariable.getModifiers()) {
                this.visitModifier(m, p);
            }
            multiVariable.getMarkers().findFirst(MultiVariable.class).ifPresent(multiVar -> {
                this.visitSpace(multiVar.getPrefix(), Space.Location.NAMED_VARIABLE_SUFFIX, p);
                p.append(",");
            });
            this.visit((Tree)multiVariable.getTypeExpression(), p);
            for (JLeftPadded dim : multiVariable.getDimensionsBeforeName()) {
                this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, p);
                p.append('[');
                this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p);
                p.append(']');
            }
            if (multiVariable.getVarargs() != null) {
                this.visitSpace(multiVariable.getVarargs(), Space.Location.VARARGS, p);
                p.append("...");
            }
            this.visitRightPadded(multiVariable.getPadding().getVariables(), JRightPadded.Location.NAMED_VARIABLE, ",", p);
            this.afterSyntax((J)multiVariable, p);
            return multiVariable;
        }

        public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)lambda, Space.Location.LAMBDA_PREFIX, p);
            LambdaStyle ls = lambda.getMarkers().findFirst(LambdaStyle.class).orElse(new LambdaStyle(null, false, !lambda.getParameters().getParameters().isEmpty()));
            boolean parenthesized = lambda.getParameters().isParenthesized();
            if (!ls.isJavaStyle()) {
                p.append('{');
            }
            this.visitMarkers(lambda.getParameters().getMarkers(), p);
            this.visitSpace(lambda.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
            if (parenthesized) {
                p.append('(');
            }
            this.visitRightPadded(lambda.getParameters().getPadding().getParameters(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
            if (parenthesized) {
                p.append(')');
            }
            if (ls.isArrow()) {
                this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
                p.append("->");
            }
            if (lambda.getBody() instanceof J.Block) {
                J.Block block = (J.Block)lambda.getBody();
                this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
                this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
            } else {
                this.visit((Tree)lambda.getBody(), p);
            }
            if (!ls.isJavaStyle()) {
                p.append('}');
            }
            this.afterSyntax((J)lambda, p);
            return lambda;
        }

        public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)fieldAccess, Space.Location.FIELD_ACCESS_PREFIX, p);
            this.visit((Tree)fieldAccess.getTarget(), p);
            Markers nameMarkers = fieldAccess.getName().getMarkers();
            String prefix = ".";
            if (nameMarkers.findFirst(NullSafe.class).isPresent()) {
                prefix = "?.";
            } else if (nameMarkers.findFirst(StarDot.class).isPresent()) {
                prefix = "*.";
            }
            this.visitLeftPadded(prefix, fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
            this.afterSyntax((J)fieldAccess, p);
            return fieldAccess;
        }

        public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
            p.append("for");
            J.ForEachLoop.Control ctrl = forEachLoop.getControl();
            this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
            p.append('(');
            String suffix = forEachLoop.getMarkers().findFirst(InStyleForEachLoop.class).isPresent() ? "in" : ":";
            this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, suffix, p);
            this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
            p.append(')');
            this.visitStatement(forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
            this.afterSyntax((J)forEachLoop, p);
            return forEachLoop;
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(method.getLeadingAnnotations(), p);
            for (J.Modifier m : method.getModifiers()) {
                this.visitModifier(m, p);
            }
            J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
            if (typeParameters != null) {
                this.visit(typeParameters.getAnnotations(), p);
                this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
                this.visitMarkers(typeParameters.getMarkers(), p);
                p.append('<');
                this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
                p.append('>');
            }
            method.getMarkers().findFirst(RedundantDef.class).ifPresent(def -> {
                this.visitSpace(def.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                p.append("def");
            });
            this.visit((Tree)method.getReturnTypeExpression(), p);
            this.visit(method.getAnnotations().getName().getAnnotations(), p);
            this.visit((Tree)method.getName(), p);
            if (!method.getMarkers().findFirst(CompactConstructor.class).isPresent()) {
                this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
            }
            this.visitContainer("throws", method.getPadding().getThrows(), JContainer.Location.THROWS, ",", null, p);
            this.visit((Tree)method.getBody(), p);
            this.visitLeftPadded("default", method.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            Markers nameMarkers = method.getName().getMarkers();
            this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, nameMarkers.findFirst(NullSafe.class).isPresent() ? "?." : (nameMarkers.findFirst(StarDot.class).isPresent() ? "*." : (nameMarkers.findFirst(ImplicitDot.class).isPresent() ? "" : ".")), p);
            this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visit((Tree)method.getName(), p);
            Optional maybeEal = method.getMarkers().findFirst(EmptyArgumentListPrecedesArgument.class);
            if (maybeEal.isPresent() && method.getArguments().size() == 1 && method.getArguments().get(0) instanceof J.Lambda) {
                EmptyArgumentListPrecedesArgument eal = (EmptyArgumentListPrecedesArgument)maybeEal.get();
                this.visitSpace(eal.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                p.append("(");
                this.visitSpace(eal.getInfix(), Space.Location.LANGUAGE_EXTENSION, p);
                p.append(")");
            }
            JContainer argContainer = method.getPadding().getArguments();
            this.visitSpace(argContainer.getBefore(), Space.Location.METHOD_INVOCATION_ARGUMENTS, p);
            List args = argContainer.getPadding().getElements();
            boolean argsAreAllClosures = args.stream().allMatch(it -> it.getElement() instanceof J.Lambda);
            boolean hasParentheses = true;
            boolean applyTrailingLambdaParenthese = true;
            for (int i = 0; i < args.size(); ++i) {
                boolean omitParensCurrElem;
                JRightPadded arg = (JRightPadded)args.get(i);
                boolean bl = omitParensCurrElem = ((Expression)arg.getElement()).getMarkers().findFirst(OmitParentheses.class).isPresent() || ((Expression)arg.getElement()).getMarkers().findFirst(org.openrewrite.java.marker.OmitParentheses.class).isPresent();
                if (i == 0) {
                    if (omitParensCurrElem) {
                        hasParentheses = false;
                    } else {
                        p.append('(');
                    }
                } else if (hasParentheses && omitParensCurrElem) {
                    if (applyTrailingLambdaParenthese) {
                        p.append(')');
                        applyTrailingLambdaParenthese = false;
                    }
                } else if (hasParentheses || !argsAreAllClosures) {
                    p.append(',');
                }
                this.visitRightPadded(arg, JRightPadded.Location.METHOD_INVOCATION_ARGUMENT, p);
                if (i != args.size() - 1 || omitParensCurrElem) continue;
                p.append(')');
            }
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitReturn(J.Return return_, PrintOutputCapture<P> p) {
            if (return_.getMarkers().findFirst(ImplicitReturn.class).isPresent() || return_.getMarkers().findFirst(org.openrewrite.java.marker.ImplicitReturn.class).isPresent()) {
                this.visitSpace(return_.getPrefix(), Space.Location.RETURN_PREFIX, p);
                this.visitMarkers(return_.getMarkers(), p);
                this.visit((Tree)return_.getExpression(), p);
                this.afterSyntax((J)return_, p);
                return return_;
            }
            return super.visitReturn(return_, p);
        }

        protected void printStatementTerminator(Statement s, PrintOutputCapture<P> p) {
        }

        public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)ternary, Space.Location.TERNARY_PREFIX, p);
            this.visit((Tree)ternary.getCondition(), p);
            if (ternary.getMarkers().findFirst(Elvis.class).isPresent()) {
                this.visitSpace(ternary.getPadding().getTruePart().getBefore(), Space.Location.TERNARY_TRUE, p);
                p.append("?:");
                this.visit((Tree)ternary.getFalsePart(), p);
            } else {
                this.visitLeftPadded("?", ternary.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, p);
                this.visitLeftPadded(":", ternary.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p);
            }
            this.afterSyntax((J)ternary, p);
            return ternary;
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof Semicolon || marker instanceof org.openrewrite.java.marker.Semicolon) {
                p.append(';');
            }
            return (M)super.visitMarker(marker, p);
        }
    }
}

