/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.Space;

public class RemoveTrailingWhitespaceVisitor<P>
extends HclIsoVisitor<P> {
    @Override
    public Hcl.ConfigFile visitConfigFile(Hcl.ConfigFile cf, P p) {
        String eof = cf.getEof().getWhitespace();
        eof = eof.chars().filter(c -> c == 10 || c == 13).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        Hcl c2 = super.visitConfigFile(cf, (Object)p);
        return ((Hcl.ConfigFile)c2).withEof(((Hcl.ConfigFile)c2).getEof().withWhitespace(eof));
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        Space s = space;
        int lastNewline = s.getWhitespace().lastIndexOf(10);
        if (lastNewline > 0) {
            StringBuilder ws = new StringBuilder();
            char[] charArray = s.getWhitespace().toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (i >= lastNewline) {
                    ws.append(c);
                    continue;
                }
                if (c != '\r' && c != '\n') continue;
                ws.append(c);
            }
            s = s.withWhitespace(ws.toString());
        }
        return s;
    }
}

