/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;

public class CompositeMavenPomCache
implements MavenPomCache {
    private final MavenPomCache l1;
    private final MavenPomCache l2;

    @Override
    public @Nullable ResolvedPom getResolvedDependencyPom(ResolvedGroupArtifactVersion dependency) {
        ResolvedPom l1r = this.l1.getResolvedDependencyPom(dependency);
        if (l1r != null) {
            return l1r;
        }
        ResolvedPom l2r = this.l2.getResolvedDependencyPom(dependency);
        if (l2r != null) {
            this.l1.putResolvedDependencyPom(dependency, l2r);
        }
        return l2r;
    }

    @Override
    public void putResolvedDependencyPom(ResolvedGroupArtifactVersion dependency, ResolvedPom resolved) {
        this.l1.putResolvedDependencyPom(dependency, resolved);
        this.l2.putResolvedDependencyPom(dependency, resolved);
    }

    @Override
    public @Nullable Optional<MavenMetadata> getMavenMetadata(URI repo, GroupArtifactVersion gav) {
        Optional<MavenMetadata> l1m = this.l1.getMavenMetadata(repo, gav);
        if (l1m != null) {
            return l1m;
        }
        Optional<MavenMetadata> l2m = this.l2.getMavenMetadata(repo, gav);
        if (l2m != null && l2m.isPresent()) {
            this.l1.putMavenMetadata(repo, gav, l2m.get());
        }
        return l2m;
    }

    @Override
    public void putMavenMetadata(URI repo, GroupArtifactVersion gav, MavenMetadata metadata) {
        this.l1.putMavenMetadata(repo, gav, metadata);
        this.l2.putMavenMetadata(repo, gav, metadata);
    }

    @Override
    public @Nullable Optional<Pom> getPom(ResolvedGroupArtifactVersion gav) throws MavenDownloadingException {
        Optional<Pom> l1p = this.l1.getPom(gav);
        if (l1p != null) {
            return l1p;
        }
        Optional<Pom> l2p = this.l2.getPom(gav);
        if (l2p != null && l2p.isPresent()) {
            this.l1.putPom(gav, l2p.get());
        }
        return l2p;
    }

    @Override
    public void putPom(ResolvedGroupArtifactVersion gav, Pom pom) {
        this.l1.putPom(gav, pom);
        this.l2.putPom(gav, pom);
    }

    @Override
    public @Nullable Optional<MavenRepository> getNormalizedRepository(MavenRepository repository) {
        Optional<MavenRepository> l1r = this.l1.getNormalizedRepository(repository);
        if (l1r != null) {
            return l1r;
        }
        Optional<MavenRepository> l2r = this.l2.getNormalizedRepository(repository);
        if (l2r != null && l2r.isPresent()) {
            this.l1.putNormalizedRepository(repository, l2r.get());
        }
        return l2r;
    }

    @Override
    public void putNormalizedRepository(MavenRepository repository, MavenRepository normalized) {
        this.l1.putNormalizedRepository(repository, normalized);
        this.l2.putNormalizedRepository(repository, normalized);
    }

    @Generated
    public CompositeMavenPomCache(MavenPomCache l1, MavenPomCache l2) {
        this.l1 = l1;
        this.l2 = l2;
    }
}

