/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.crm.modules.notifygru.web.rs;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.paris.lutece.plugins.crm.business.demand.Demand;
import fr.paris.lutece.plugins.crm.business.demand.DemandStatusCRM;
import fr.paris.lutece.plugins.crm.business.demand.DemandTypeHome;
import fr.paris.lutece.plugins.crm.business.user.CRMUser;
import fr.paris.lutece.plugins.crm.service.CRMService;
import fr.paris.lutece.plugins.crm.service.demand.DemandService;
import fr.paris.lutece.plugins.crm.service.demand.DemandStatusCRMService;
import fr.paris.lutece.plugins.crm.service.user.CRMUserService;
import fr.paris.lutece.plugins.grubusiness.business.notification.Notification;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.portal.service.util.AppLogService;
import fr.paris.lutece.util.json.AbstractJsonResponse;
import fr.paris.lutece.util.json.ErrorJsonResponse;
import fr.paris.lutece.util.json.JsonUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Path(value="/rest/api/v{version}/crmnotifygru")
public class CrmNotifyGruRestService {
    private final Logger _logger = Logger.getLogger((String)"lutece.rest");
    private final String CHARECTER_REGEXP_FILTER = "[^\\p{L}\\p{M}\\p{N}\\p{P}\\p{Z}\\p{Cf}\\p{Cs}\\p{Sm}\\p{Sc}\\s]";

    @PUT
    @Path(value="/notification")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response notifications(@PathParam(value="version") Integer nVersion, String strJson, @Context HttpServletRequest request) {
        if (nVersion == 1) {
            return this.storeNotificationV1(strJson, I18nService.getDefaultLocale());
        }
        this._logger.error((Object)"Version not found");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)JsonUtil.buildJsonResponse((AbstractJsonResponse)new ErrorJsonResponse(Response.Status.NOT_FOUND.name(), "Version not found"))).build();
    }

    private Response storeNotificationV1(String strJson, Locale locale) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Notification gruNotification = (Notification)mapper.readValue(strJson, Notification.class);
            AppLogService.debug((Object)("crm-notifygru / notification - Received strJson : " + strJson));
            return this.store(gruNotification, locale);
        }
        catch (JsonParseException ex) {
            return this.error((Object)((Object)ex) + " :" + ex.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, ex);
        }
        catch (JsonMappingException ex) {
            return this.error((Object)((Object)ex) + " :" + ex.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, ex);
        }
        catch (IOException ex) {
            return this.error(ex + " :" + ex.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, ex);
        }
        catch (NullPointerException ex) {
            return this.error(ex + " :" + ex.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, ex);
        }
    }

    private Response store(Notification gruNotification, Locale locale) {
        if (gruNotification.getDemand() == null || gruNotification.getDemand().getCustomer() == null || StringUtils.isBlank((CharSequence)gruNotification.getDemand().getCustomer().getConnectionId())) {
            return this.error("User connection id is mandatory", Response.Status.PRECONDITION_FAILED, null);
        }
        if (StringUtils.isBlank((CharSequence)gruNotification.getDemand().getId()) || StringUtils.isBlank((CharSequence)gruNotification.getDemand().getTypeId())) {
            return this.error("Demand Id and Demand type Id are mandatory", Response.Status.PRECONDITION_FAILED, null);
        }
        Demand crmDemand = this.getCrmDemand(gruNotification);
        Demand storedDemand = DemandService.getService().findByRemoteKey(crmDemand.getRemoteId(), crmDemand.getIdDemandType());
        int demandId = -1;
        if (storedDemand != null) {
            demandId = storedDemand.getIdDemand();
            CRMUser storedUser = CRMUserService.getService().findByUserGuid(gruNotification.getDemand().getCustomer().getConnectionId());
            if (storedUser != null && storedUser.getIdCRMUser() != storedDemand.getIdCRMUser()) {
                return this.error("The user ID doesn't correspond to the user Id of the original Demand", Response.Status.PRECONDITION_FAILED, null);
            }
            storedDemand.setDateModification(crmDemand.getDateModification());
            if (storedDemand.getIdStatusCRM() != crmDemand.getIdStatusCRM() && crmDemand.getIdStatusCRM() >= 0) {
                storedDemand.setIdStatusCRM(crmDemand.getIdStatusCRM());
            }
            if (crmDemand.getStatusText() != null && !crmDemand.getStatusText().equals(storedDemand.getStatusText())) {
                storedDemand.setStatusText(crmDemand.getStatusText());
            }
            if (StringUtils.isBlank((CharSequence)storedDemand.getStatusText())) {
                DemandStatusCRM statusCRM = DemandStatusCRMService.getService().getStatusCRM(crmDemand.getIdStatusCRM(), locale);
                storedDemand.setStatusText(statusCRM.getLabel());
            }
            DemandService.getService().update(storedDemand);
        } else {
            DemandStatusCRM statusCRM;
            int nUserId;
            CRMUser storedUser = CRMUserService.getService().findByUserGuid(gruNotification.getDemand().getCustomer().getConnectionId());
            if (storedUser != null) {
                nUserId = storedUser.getIdCRMUser();
            } else {
                CRMUser crmUser = new CRMUser();
                crmUser.setUserGuid(gruNotification.getDemand().getCustomer().getConnectionId());
                crmUser.setMustBeUpdated(true);
                nUserId = CRMUserService.getService().create(crmUser);
            }
            crmDemand.setIdCRMUser(nUserId);
            if (crmDemand.getIdStatusCRM() >= 0 && (statusCRM = DemandStatusCRMService.getService().getStatusCRM(crmDemand.getIdStatusCRM(), locale)) != null) {
                crmDemand.setStatusText(statusCRM.getLabel());
            }
            demandId = DemandService.getService().create(crmDemand);
        }
        fr.paris.lutece.plugins.crm.business.notification.Notification crmNotification = this.getCrmNotification(gruNotification);
        CRMService.getService().notify(demandId, crmNotification.getObject(), crmNotification.getMessage(), crmNotification.getSender());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)"{ \"acknowledge\" : { \"status\": \"received\" } }").build();
    }

    private Demand getCrmDemand(Notification gruNotification) {
        Demand crmDemand = new Demand();
        if (gruNotification.getDemand() != null) {
            crmDemand.setRemoteId(gruNotification.getDemand().getId());
            crmDemand.setIdStatusCRM(gruNotification.getDemand().getStatusId());
            crmDemand.setDateModification(new Timestamp(gruNotification.getDate()));
            crmDemand.setData("");
            if (StringUtils.isNumeric((CharSequence)gruNotification.getDemand().getTypeId())) {
                crmDemand.setIdDemandType(Integer.parseInt(gruNotification.getDemand().getTypeId()));
            }
            if (gruNotification.getMyDashboardNotification().getStatusText() != null) {
                crmDemand.setStatusText(gruNotification.getMyDashboardNotification().getStatusText());
            }
            if (gruNotification.getMyDashboardNotification().getStatusId() >= 0) {
                crmDemand.setIdStatusCRM(gruNotification.getMyDashboardNotification().getStatusId());
            }
        }
        return crmDemand;
    }

    private fr.paris.lutece.plugins.crm.business.notification.Notification getCrmNotification(Notification gruNotification) {
        fr.paris.lutece.plugins.crm.business.notification.Notification crmNotification = new fr.paris.lutece.plugins.crm.business.notification.Notification();
        if (gruNotification.getMyDashboardNotification() != null) {
            crmNotification.setMessage(gruNotification.getMyDashboardNotification().getMessage().replaceAll("[^\\p{L}\\p{M}\\p{N}\\p{P}\\p{Z}\\p{Cf}\\p{Cs}\\p{Sm}\\p{Sc}\\s]", ""));
            crmNotification.setSender(gruNotification.getMyDashboardNotification().getSenderName());
            crmNotification.setObject(gruNotification.getMyDashboardNotification().getSubject().replaceAll("[^\\p{L}\\p{M}\\p{N}\\p{P}\\p{Z}\\p{Cf}\\p{Cs}\\p{Sm}\\p{Sc}\\s]", ""));
        }
        return crmNotification;
    }

    private Response error(String strMessage, Response.Status status, Throwable ex) {
        if (ex != null) {
            AppLogService.error((Object)strMessage, (Throwable)ex);
        } else {
            AppLogService.error((Object)strMessage);
        }
        String strError = "{ \"status\": \"Error : " + strMessage + "\" }";
        return Response.status((Response.Status)status).entity((Object)strError).build();
    }

    @GET
    @Path(value="/demandType")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getDemandTypes() {
        List listDemandTypes = DemandTypeHome.findAll();
        try {
            ObjectMapper mapper = new ObjectMapper();
            String strResult = mapper.writeValueAsString((Object)listDemandTypes);
            return Response.ok((Object)strResult).build();
        }
        catch (JsonProcessingException e) {
            return Response.serverError().build();
        }
    }
}

