/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.document.modules.calendar.business;

import fr.paris.lutece.plugins.document.modules.calendar.business.CalendarAttribute;
import fr.paris.lutece.plugins.document.modules.calendar.business.ICalendarAttributeDAO;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.util.sql.DAOUtil;
import java.util.ArrayList;
import java.util.List;

public class CalendarAttributeDAO
implements ICalendarAttributeDAO {
    private static final String SQL_QUERY_SELECT = "SELECT id_calendar_attr, calendar_attr_label, calendar_attr_bookmark, calendar_attr_type FROM documenttocalendar_calendar_attr WHERE id_calendar_attr=?";
    private static final String SQL_QUERY_FIND_BY_CALENDAR_ATTR_TYPE = "SELECT id_calendar_attr, calendar_attr_label, calendar_attr_bookmark, calendar_attr_type FROM documenttocalendar_calendar_attr WHERE calendar_attr_type=?";

    @Override
    public CalendarAttribute findByKey(int idKey, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT, plugin);
        daoUtil.setInt(1, idKey);
        daoUtil.executeQuery();
        CalendarAttribute calendarAttribute = null;
        if (daoUtil.next()) {
            calendarAttribute = new CalendarAttribute();
            calendarAttribute.setId(daoUtil.getInt(1));
            calendarAttribute.setCalendarAttributeLabel(daoUtil.getString(2));
            calendarAttribute.setCalendarAttributeBookMark(daoUtil.getString(3));
            calendarAttribute.setCalendarAttributeType(daoUtil.getString(4));
        }
        daoUtil.free();
        return calendarAttribute;
    }

    @Override
    public List<CalendarAttribute> findByType(String strCalendarType, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_FIND_BY_CALENDAR_ATTR_TYPE, plugin);
        daoUtil.setString(1, strCalendarType);
        daoUtil.executeQuery();
        CalendarAttribute calendarAttribute = null;
        ArrayList<CalendarAttribute> listcalendarAttribute = new ArrayList<CalendarAttribute>();
        while (daoUtil.next()) {
            calendarAttribute = new CalendarAttribute();
            calendarAttribute.setId(daoUtil.getInt(1));
            calendarAttribute.setCalendarAttributeLabel(daoUtil.getString(2));
            calendarAttribute.setCalendarAttributeBookMark(daoUtil.getString(3));
            calendarAttribute.setCalendarAttributeType(daoUtil.getString(4));
            listcalendarAttribute.add(calendarAttribute);
        }
        daoUtil.free();
        return listcalendarAttribute;
    }
}

