/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.document.modules.calendar.business;

import fr.paris.lutece.plugins.document.modules.calendar.business.IMappingAttributeDAO;
import fr.paris.lutece.plugins.document.modules.calendar.business.MappingAttribute;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.util.sql.DAOUtil;
import java.util.ArrayList;
import java.util.List;

public class MappingAttributeDAO
implements IMappingAttributeDAO {
    private static final String SQL_QUERY_NEW_PK = " SELECT max( id_mapping_attr ) FROM documenttocalendar_mapping_attr ";
    private static final String SQL_QUERY_INSERT = "INSERT INTO documenttocalendar_mapping_attr (id_mapping_attr,code_document_type, id_document_attr,id_calendar_attr, document_features )VALUES(?,?,?,?,?)";
    private static final String SQL_QUERY_DELETE = "DELETE FROM documenttocalendar_mapping_attr WHERE code_document_type = ? ";
    private static final String SQL_QUERY_UPDATE = "UPDATE documenttocalendar_mapping_attr SET id_mapping_attr=?, code_document_type= ? ,id_document_attr=?,id_calendar_attr=?, document_features=? WHERE id_mapping_attr=?";
    private static final String SQL_QUERY_SELECT = "SELECT id_mapping_attr,code_document_type,id_document_attr,id_calendar_attr,document_features FROM documenttocalendar_mapping_attr WHERE id_mapping_attr=?";
    private static final String SQL_QUERY_SELECT_ALL_BY_DOCUMENT_TYPE = "SELECT id_mapping_attr,code_document_type,id_document_attr,id_calendar_attr,document_features FROM documenttocalendar_mapping_attr WHERE code_document_type=?";

    private int newPrimaryKey() {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_NEW_PK);
        daoUtil.executeQuery();
        if (!daoUtil.next()) {
            boolean bl = true;
        }
        int nKey = daoUtil.getInt(1) + 1;
        daoUtil.free();
        return nKey;
    }

    @Override
    public void store(MappingAttribute mappingAttribute, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_UPDATE, plugin);
        daoUtil.setInt(1, mappingAttribute.getId());
        daoUtil.setString(2, mappingAttribute.getCodeDocumentType());
        daoUtil.setInt(3, mappingAttribute.getIdDocumentAttribute());
        daoUtil.setInt(4, mappingAttribute.getIdCalendarAttribute());
        daoUtil.setString(5, mappingAttribute.getDocumentFeature());
        daoUtil.setInt(6, mappingAttribute.getId());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public void delete(String strCodeDocumentType, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_DELETE, plugin);
        daoUtil.setString(1, strCodeDocumentType);
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public void insert(MappingAttribute mappingAttribute, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_INSERT, plugin);
        mappingAttribute.setId(this.newPrimaryKey());
        daoUtil.setInt(1, mappingAttribute.getId());
        daoUtil.setString(2, mappingAttribute.getCodeDocumentType());
        daoUtil.setInt(3, mappingAttribute.getIdDocumentAttribute());
        daoUtil.setInt(4, mappingAttribute.getIdCalendarAttribute());
        daoUtil.setString(5, mappingAttribute.getDocumentFeature());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public MappingAttribute load(Integer idKey, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT, plugin);
        daoUtil.setInt(1, idKey.intValue());
        daoUtil.executeQuery();
        MappingAttribute mappingAttribute = null;
        if (daoUtil.next()) {
            mappingAttribute = new MappingAttribute();
            mappingAttribute.setId(daoUtil.getInt(1));
            mappingAttribute.setCodeDocumentType(daoUtil.getString(2));
            mappingAttribute.setIdDocumentAttribute(daoUtil.getInt(3));
            mappingAttribute.setIdCalendarAttribute(daoUtil.getInt(4));
            mappingAttribute.setDocumentFeature(daoUtil.getString(5));
        }
        daoUtil.free();
        return mappingAttribute;
    }

    @Override
    public List<MappingAttribute> selectDocumentMappingAttributeList(String strCodeDocumentType, Plugin plugin) {
        ArrayList<MappingAttribute> mappingAttributeList = new ArrayList<MappingAttribute>();
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT_ALL_BY_DOCUMENT_TYPE, plugin);
        daoUtil.setString(1, strCodeDocumentType);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            MappingAttribute mappingAttribute = new MappingAttribute();
            mappingAttribute.setId(daoUtil.getInt(1));
            mappingAttribute.setCodeDocumentType(daoUtil.getString(2));
            mappingAttribute.setIdDocumentAttribute(daoUtil.getInt(3));
            mappingAttribute.setIdCalendarAttribute(daoUtil.getInt(4));
            mappingAttribute.setDocumentFeature(daoUtil.getString(5));
            mappingAttributeList.add(mappingAttribute);
        }
        daoUtil.free();
        return mappingAttributeList;
    }
}

