/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.document.modules.calendar.business;

import fr.paris.lutece.plugins.document.modules.calendar.business.IMappingDAO;
import fr.paris.lutece.plugins.document.modules.calendar.business.Mapping;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.util.sql.DAOUtil;
import java.util.ArrayList;
import java.util.List;

public class MappingDAO
implements IMappingDAO {
    private static final String SQL_QUERY_SELECT = "SELECT code_document_type, description FROM documenttocalendar_mapping ORDER BY code_document_type";
    private static final String SQL_QUERY_DELETE = "DELETE FROM documenttocalendar_mapping WHERE code_document_type = ? ";
    private static final String SQL_QUERY_FIND_BY_CODE_DOCUMENT_TYPE = "SELECT code_document_type, description FROM documenttocalendar_mapping WHERE code_document_type=?";
    private static final String SQL_QUERY_UPDATE = "UPDATE documenttocalendar_mapping SET code_document_type=?,description=? WHERE code_document_type=?";
    private static final String SQL_QUERY_INSERT = "INSERT INTO documenttocalendar_mapping (code_document_type,description )VALUES(?,?)";

    @Override
    public List<Mapping> select(Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT, plugin);
        daoUtil.executeQuery();
        Mapping mapping = null;
        ArrayList<Mapping> listMapping = new ArrayList<Mapping>();
        while (daoUtil.next()) {
            mapping = new Mapping();
            mapping.setCodeDocumentType(daoUtil.getString(1));
            mapping.setDescription(daoUtil.getString(2));
            listMapping.add(mapping);
        }
        daoUtil.free();
        return listMapping;
    }

    @Override
    public void delete(String strCodeDocumentType, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_DELETE, plugin);
        daoUtil.setString(1, strCodeDocumentType);
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public Mapping load(String strCodeDocumentType, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_FIND_BY_CODE_DOCUMENT_TYPE, plugin);
        daoUtil.setString(1, strCodeDocumentType);
        daoUtil.executeQuery();
        Mapping mapping = null;
        if (daoUtil.next()) {
            mapping = new Mapping();
            mapping.setCodeDocumentType(daoUtil.getString(1));
            mapping.setDescription(daoUtil.getString(2));
        }
        daoUtil.free();
        return mapping;
    }

    @Override
    public void store(Mapping mapping, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_UPDATE, plugin);
        daoUtil.setString(1, mapping.getCodeDocumentType());
        daoUtil.setString(2, mapping.getDescription());
        daoUtil.setString(3, mapping.getCodeDocumentType());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public void insert(Mapping mapping, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_INSERT, plugin);
        daoUtil.setString(1, mapping.getCodeDocumentType());
        daoUtil.setString(2, mapping.getDescription());
        daoUtil.executeUpdate();
        daoUtil.free();
    }
}

