/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.document.modules.calendar.service;

import fr.paris.lutece.plugins.document.business.DocumentType;
import fr.paris.lutece.plugins.document.business.DocumentTypeHome;
import fr.paris.lutece.plugins.document.business.attributes.DocumentAttribute;
import fr.paris.lutece.plugins.document.business.attributes.DocumentAttributeHome;
import fr.paris.lutece.plugins.document.modules.calendar.business.CalendarAttribute;
import fr.paris.lutece.plugins.document.modules.calendar.business.CalendarAttributeHome;
import fr.paris.lutece.plugins.document.modules.calendar.business.Mapping;
import fr.paris.lutece.plugins.document.modules.calendar.business.MappingAttribute;
import fr.paris.lutece.plugins.document.modules.calendar.business.MappingAttributeHome;
import fr.paris.lutece.plugins.document.modules.calendar.business.MappingHome;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.portal.service.plugin.PluginService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class MappingService {
    private static final String PARAMETER_TYPE_FILE = "file";
    private static final String PARAMETER_TYPE_DATE = "date";
    private static final String PARAMETER_TYPE_URL = "url";
    private static final String PARAMETER_TYPE_NUMERICTEXT = "numerictext";
    private static final String PARAMETER_TYPE_TEXT = "text";
    private static final String PARAMETER_TYPE_INTERNALLINK = "internallink";
    private static final String PARAMETER_TYPE_IMAGE = "image";
    private static final String PLUGIN_NAME = "documenttocalendar";

    private MappingService() {
    }

    public static List<Mapping> getCodeDocumentTypeWithoutMapping() {
        Plugin plugin = PluginService.getPlugin((String)PLUGIN_NAME);
        List<Mapping> mappingList = MappingHome.getList(plugin);
        Collection documentTypeList = DocumentTypeHome.findAll();
        ArrayList<Mapping> documentTypeWithoutMappingList = new ArrayList<Mapping>();
        for (DocumentType documentType : documentTypeList) {
            boolean bisMappingWithoutDescription = true;
            for (Mapping mapping : mappingList) {
                if (!mapping.getCodeDocumentType().equals(documentType.getCode())) continue;
                bisMappingWithoutDescription = false;
                break;
            }
            if (!bisMappingWithoutDescription) continue;
            Mapping mappingWithoutDescription = new Mapping();
            mappingWithoutDescription.setCodeDocumentType(documentType.getCode());
            mappingWithoutDescription.setDocumentTypeName(DocumentTypeHome.findByPrimaryKey((String)documentType.getCode()).getName());
            documentTypeWithoutMappingList.add(mappingWithoutDescription);
        }
        return documentTypeWithoutMappingList;
    }

    public static List<DocumentAttribute> getDocumentAttributesByCodeDocument(String strCodeDocumentType) {
        DocumentType documentType = new DocumentType();
        documentType.setCode(strCodeDocumentType);
        DocumentAttributeHome.setDocumentTypeAttributes((DocumentType)documentType);
        return documentType.getAttributes();
    }

    public static List<MappingAttribute> getDocumentMappingAttributeList(String strCodeDocumentType) {
        Plugin plugin = PluginService.getPlugin((String)PLUGIN_NAME);
        List<MappingAttribute> mappingAttributeList = MappingAttributeHome.findDocumentMappingAttributeList(strCodeDocumentType, plugin);
        for (MappingAttribute mappingAttribute : mappingAttributeList) {
            MappingService.getAttributeDescription(mappingAttribute);
        }
        return mappingAttributeList;
    }

    public static MappingAttribute getMappingAttribute(int nIdMappingAttribute) {
        Plugin plugin = PluginService.getPlugin((String)PLUGIN_NAME);
        MappingAttribute mappingAttribute = MappingAttributeHome.findByPrimaryKey(nIdMappingAttribute, plugin);
        MappingService.getAttributeDescription(mappingAttribute);
        return mappingAttribute;
    }

    public static void getAttributeDescription(MappingAttribute mappingAttribute) {
        Plugin plugin = PluginService.getPlugin((String)PLUGIN_NAME);
        if (mappingAttribute.getIdCalendarAttribute() != -1) {
            CalendarAttribute calendarAttribute = CalendarAttributeHome.findByKey(mappingAttribute.getIdCalendarAttribute(), plugin);
            mappingAttribute.setCalendarAttributeDescription(calendarAttribute.getCalendarAttributeLabel());
        }
        if (mappingAttribute.getIdDocumentAttribute() != -1) {
            DocumentAttribute documentAttribute = DocumentAttributeHome.findByPrimaryKey((int)mappingAttribute.getIdDocumentAttribute());
            mappingAttribute.setDocumentAttributeDescription(documentAttribute.getDescription());
        }
    }

    public static List<CalendarAttribute> getCalendarAttributeListByIdMappingAttribute(int nIdMappingAttribute) {
        Plugin plugin = PluginService.getPlugin((String)PLUGIN_NAME);
        MappingAttribute mappingAttribute = MappingAttributeHome.findByPrimaryKey(nIdMappingAttribute, plugin);
        List<Object> calendarAttributeList = new ArrayList();
        if (mappingAttribute.getIdDocumentAttribute() != -1) {
            DocumentAttribute documentAttribute = DocumentAttributeHome.findByPrimaryKey((int)mappingAttribute.getIdDocumentAttribute());
            if (documentAttribute.getCodeAttributeType().equals(PARAMETER_TYPE_URL) || documentAttribute.getCodeAttributeType().equals(PARAMETER_TYPE_TEXT) || documentAttribute.getCodeAttributeType().equals(PARAMETER_TYPE_NUMERICTEXT) || documentAttribute.getCodeAttributeType().equals(PARAMETER_TYPE_INTERNALLINK)) {
                calendarAttributeList = CalendarAttributeHome.findByType(PARAMETER_TYPE_TEXT, plugin);
            } else if (documentAttribute.getCodeAttributeType().equals(PARAMETER_TYPE_DATE)) {
                calendarAttributeList = CalendarAttributeHome.findByType(PARAMETER_TYPE_DATE, plugin);
            } else if (documentAttribute.getCodeAttributeType().equals(PARAMETER_TYPE_IMAGE) || documentAttribute.getCodeAttributeType().equals(PARAMETER_TYPE_FILE)) {
                calendarAttributeList = CalendarAttributeHome.findByType(PARAMETER_TYPE_FILE, plugin);
            } else if (documentAttribute.getCodeAttributeType().equals(PARAMETER_TYPE_NUMERICTEXT)) {
                calendarAttributeList = CalendarAttributeHome.findByType(PARAMETER_TYPE_NUMERICTEXT, plugin);
            }
        } else {
            calendarAttributeList = CalendarAttributeHome.findByType(PARAMETER_TYPE_TEXT, plugin);
        }
        List<MappingAttribute> mappingAttributeList = MappingService.getDocumentMappingAttributeList(mappingAttribute.getCodeDocumentType());
        block0: for (MappingAttribute mappingAttributeMapped : mappingAttributeList) {
            if (mappingAttributeMapped.getId() == nIdMappingAttribute || mappingAttributeMapped.getIdCalendarAttribute() == -1) continue;
            for (CalendarAttribute calendarAttribute : calendarAttributeList) {
                if (calendarAttribute.getId() != mappingAttributeMapped.getIdCalendarAttribute()) continue;
                calendarAttributeList.remove(calendarAttribute);
                continue block0;
            }
        }
        return calendarAttributeList;
    }
}

