/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.document.modules.calendar.web;

import fr.paris.lutece.plugins.calendar.business.CalendarHome;
import fr.paris.lutece.plugins.calendar.business.category.CategoryHome;
import fr.paris.lutece.plugins.calendar.service.AgendaResource;
import fr.paris.lutece.plugins.document.business.Document;
import fr.paris.lutece.plugins.document.business.DocumentHome;
import fr.paris.lutece.plugins.document.business.attributes.DocumentAttribute;
import fr.paris.lutece.plugins.document.business.attributes.DocumentAttributeHome;
import fr.paris.lutece.plugins.document.modules.calendar.business.CalendarAttribute;
import fr.paris.lutece.plugins.document.modules.calendar.business.CalendarAttributeHome;
import fr.paris.lutece.plugins.document.modules.calendar.business.Mapping;
import fr.paris.lutece.plugins.document.modules.calendar.business.MappingAttribute;
import fr.paris.lutece.plugins.document.modules.calendar.business.MappingAttributeHome;
import fr.paris.lutece.plugins.document.modules.calendar.business.MappingHome;
import fr.paris.lutece.plugins.document.modules.calendar.service.MappingService;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.portal.service.message.AdminMessageService;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.portal.service.plugin.PluginService;
import fr.paris.lutece.portal.service.template.AppTemplateService;
import fr.paris.lutece.portal.service.util.AppPathService;
import fr.paris.lutece.portal.service.util.AppPropertiesService;
import fr.paris.lutece.portal.web.admin.PluginAdminPageJspBean;
import fr.paris.lutece.portal.web.upload.MultipartHttpServletRequest;
import fr.paris.lutece.util.ReferenceList;
import fr.paris.lutece.util.html.HtmlTemplate;
import fr.paris.lutece.util.url.UrlItem;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;

public class DocumentToCalendarJspBean
extends PluginAdminPageJspBean {
    public static final String RIGHT_MANAGE_DOCUMENTTOCALENDAR = "DOCUMENTTOCALENDAR_MANAGEMENT";
    private static final String TEMPLATE_MANAGE_DOCUMENTTOCALENDAR = "/admin/plugins/document/modules/calendar/manage_documenttocalendar.html";
    private static final String TEMPLATE_MODIFY_MAPPING = "/admin/plugins/document/modules/calendar/modify_mapping.html";
    private static final String TEMPLATE_CREATE_MAPPING = "/admin/plugins/document/modules/calendar/create_mapping.html";
    private static final String TEMPLATE_MODIFY_ATTRIBUTE_MAPPING = "/admin/plugins/document/modules/calendar/modify_mapping_attribute.html";
    private static final String TEMPLATE_SELECT_CALENDAR = "/admin/plugins/document/modules/calendar/select_calendar.html";
    private static final String TEMPLATE_CREATE_EVENT = "admin/plugins/document/modules/calendar/create_event.html";
    private static final String MARK_MAPPING_ATTR = "mapping_attribute";
    private static final String MARK_CALENDAR_ATTR_LIST = "calendar_attribute_list";
    private static final String MARK_CALENDAR_LIST = "calendar_list";
    private static final String MARK_MAPPING = "mapping";
    private static final String MARK_MAPPING_ATTR_LIST = "mapping_attribute_list";
    private static final String MARK_CODE_DOCUMENT_TYPE_LIST = "code_document_type_list";
    private static final String MARK_ID_DOCUMENT = "id_document";
    private static final String MARK_ID_CALENDAR = "calendar_id";
    private static final String MARK_INTERVAL_LIST = "interval_list";
    private static final String MARK_INTERVAL_TIME_SPAN = "time_span";
    private static final String MARK_NUMBER_DAYS = "number_days";
    private static final String MARK_TOP_EVENT_LIST = "top_event_list";
    private static final String MARK_TOP_EVENT_DEFAULT = "top_event_default";
    private static final String MARK_EMAIL_NOTIFY = "notify";
    private static final String MARK_INSERT_SERVICE_PAGE = "insert_service_page";
    private static final String MARK_INSERT_SERVICE_LINK_PAGE = "insert_service_link_page";
    private static final String MARK_WEBAPP_URL = "webapp_url";
    private static final String MARK_CALENDAR_ID = "calendar_id";
    private static final String MARK_LOCALE = "locale";
    private static final String MARK_CATEGORY_LIST = "category_list";
    private static final String MARK_CATEGORY_DEFAULT_LIST = "category_default_list";
    private static final String PARAMETER_DOCUMENT_FEATURE_TITLE = "document.create_document.labelDocumentTitle";
    private static final String PARAMETER_DOCUMENT_FEATURE_SUMARY = "document.create_document.labelDocumentSummary";
    private static final String PARAMETER_MAPPING_CODE_DOCUMENT_TYPE = "mapping_code_document_type";
    private static final String PARAMETER_MAPPING_LIST = "mapping_list";
    private static final String PARAMETER_CANCEL = "cancel";
    private static final String PARAMETER_MAPPING_DESCRIPTION = "mapping_description";
    private static final String PARAMETER_ID_MAPPING_ATTR = "mapping_attribute_id";
    private static final String PARAMETER_ID_CALENDAR_ATTR = "calendar_attr_id";
    private static final String PARAMETER_ID_DOCUMENT = "id_document";
    private static final String PARAMETER_ID_CALENDAR = "calendar_id";
    private static final String PARAMETER_EVENT_IMAGE = "event_image";
    private static final String PARAMETER_TYPE_TEXT = "text";
    private static final String PARAMETER_TYPE_NUMERICTEXT = "numerictext";
    private static final String PARAMETER_TYPE_FILE = "file";
    private static final String PARAMETER_TYPE_DATE = "date";
    private static final String JSP_URL_REMOVE_MAPPING = "jsp/admin/plugins/document/modules/calendar/DoRemoveMapping.jsp";
    private static final String JSP_URL_MANAGE_MAPPING = "jsp/admin/plugins/document/modules/calendar/ManageDocumentToCalendar.jsp";
    private static final String JSP_URL_MODIFY_MAPPING = "jsp/admin/plugins/document/modules/calendar/ModifyMapping.jsp";
    private static final String JSP_URL_CREATE_EVENT = "jsp/admin/plugins/document/modules/calendar/CreateEvent.jsp";
    private static final String JSP_GET_INSERT_SERVICE = "jsp/admin/plugins/calendar/GetInsertService.jsp";
    private static final String JSP_GET_INSERT_LINK_SERVICE = "jsp/admin/plugins/calendar/GetInsertLinkService.jsp";
    private static final String JSP_GET_DOCUMENT_FILE = "jsp/admin/plugins/document/modules/calendar/GetFile.jsp";
    private static final String MESSAGE_MAPPING_ERROR = "module.document.calendar.message.mappingError";
    private static final String MESSAGE_CONFIRM_REMOVE_MAPPING = "module.document.calendar.message.confirmRemoveMapping";
    private static final String MESSAGE_MAPPING_DESCRIPTION_ERROR = "module.document.calendar.message.mappingDescriptionError";
    private static final String MESSAGE_MAPPING_CODE_DOCUMENT_ERROR = "module.document.calendar.message.mappingCodeDocumentError";
    private static final String MESSAGE_MAPPING_ATTRIBUT_ERROR = "module.document.calendar.message.mappingAttributeError";
    private static final String MESSAGE_MAPPING_CALENDAR_ERROR = "module.document.calendar.message.mappingCalendarError";
    private static final String MESSAGE_DOCUMENT_ERROR = "module.document.calendar.message.documentError";
    private static final String MESSAGE_CALENDAR_ERROR = "module.document.calendar.message.calendarError";
    private static final String PROPERTY_MANAGE_MAPPING_TITLE = "module.document.calendar.manageMapping.title";
    private static final String PROPERTY_MODIFY_MAPPING_TITLE = "module.document.calendar.modifyMapping.title";
    private static final String PROPERTY_CREATE_MAPPING_TITLE = "module.document.calendar.createMapping.title";
    private static final String PROPERTY_MODIFY_MAPPING_ATTRIBUTE_TITLE = "module.document.calendar.modifyMappingAtribute.title";
    private static final String PROPERTY_SELECT_CALENDAR_TITLE = "module.document.calendar.selectCalendar.title";
    private static final String PROPERTY_CREATE_EVENT_TITLE = "module.document.calendar.createEvent.title";
    private static final String PROPERTY_TOP_EVENT_DEFAULT = "calendar.topevent.default";
    private static final String PROPERTY_EMAIL_NOTIFY = "calendar.email.notify";
    private static final String PROPERTY_TIME_INTERVAL_LIST = "calendar.interval.time";
    private static final String PROPERTY_TOP_EVENT_LIST = "calendar.topevent.values";

    public String getManageDocumentToCalendar(HttpServletRequest request) {
        Plugin plugin = this.getPlugin();
        this.setPageTitleProperty(PROPERTY_MANAGE_MAPPING_TITLE);
        HashMap<String, List<Mapping>> model = new HashMap<String, List<Mapping>>();
        List<Mapping> listMapping = MappingHome.getList(plugin);
        model.put(PARAMETER_MAPPING_LIST, listMapping);
        HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_MANAGE_DOCUMENTTOCALENDAR, (Locale)this.getLocale(), model);
        return this.getAdminPage(templateList.getHtml());
    }

    public String getConfirmRemoveMapping(HttpServletRequest request) {
        String strCodeDocumentType = request.getParameter(PARAMETER_MAPPING_CODE_DOCUMENT_TYPE);
        UrlItem url = new UrlItem(JSP_URL_REMOVE_MAPPING);
        url.addParameter(PARAMETER_MAPPING_CODE_DOCUMENT_TYPE, strCodeDocumentType);
        return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_CONFIRM_REMOVE_MAPPING, (String)url.getUrl(), (int)4);
    }

    public String doRemoveMapping(HttpServletRequest request) {
        String strCodeDocumentType = request.getParameter(PARAMETER_MAPPING_CODE_DOCUMENT_TYPE);
        Plugin plugin = this.getPlugin();
        if (strCodeDocumentType == null) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_MAPPING_ERROR, (int)2);
        }
        MappingHome.remove(strCodeDocumentType, plugin);
        MappingAttributeHome.remove(strCodeDocumentType, plugin);
        return AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_URL_MANAGE_MAPPING;
    }

    public String getCreateMapping(HttpServletRequest request) {
        List<Mapping> documentTypeWithoutMappingList = MappingService.getCodeDocumentTypeWithoutMapping();
        HashMap<String, List<Mapping>> model = new HashMap<String, List<Mapping>>();
        model.put(MARK_CODE_DOCUMENT_TYPE_LIST, documentTypeWithoutMappingList);
        this.setPageTitleProperty(PROPERTY_CREATE_MAPPING_TITLE);
        HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_CREATE_MAPPING, (Locale)this.getLocale(), model);
        return this.getAdminPage(templateList.getHtml());
    }

    public String doCreateMapping(HttpServletRequest request) {
        if (request.getParameter(PARAMETER_CANCEL) == null) {
            String strCodeDocumentType = request.getParameter(PARAMETER_MAPPING_CODE_DOCUMENT_TYPE);
            String strMappingDescription = request.getParameter(PARAMETER_MAPPING_DESCRIPTION);
            if (strMappingDescription == null || strMappingDescription.equals("")) {
                return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_MAPPING_DESCRIPTION_ERROR, (int)5);
            }
            if (strCodeDocumentType == null) {
                return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_MAPPING_CODE_DOCUMENT_ERROR, (int)5);
            }
            Plugin plugin = this.getPlugin();
            Mapping mapping = new Mapping();
            mapping.setCodeDocumentType(strCodeDocumentType);
            mapping.setDescription(strMappingDescription);
            MappingHome.create(mapping, plugin);
            List<DocumentAttribute> documentAttributeList = MappingService.getDocumentAttributesByCodeDocument(strCodeDocumentType);
            for (DocumentAttribute documentAttribute : documentAttributeList) {
                if (!documentAttribute.isRequired()) continue;
                MappingAttribute mappingAttribute = new MappingAttribute();
                mappingAttribute.setCodeDocumentType(strCodeDocumentType);
                mappingAttribute.setIdDocumentAttribute(documentAttribute.getId());
                mappingAttribute.setIdCalendarAttribute(-1);
                mappingAttribute.setDocumentFeature("");
                MappingAttributeHome.create(mappingAttribute, plugin);
            }
            MappingAttribute mappingAttribute = new MappingAttribute();
            mappingAttribute.setCodeDocumentType(strCodeDocumentType);
            mappingAttribute.setIdDocumentAttribute(-1);
            mappingAttribute.setIdCalendarAttribute(-1);
            mappingAttribute.setDocumentFeature(PARAMETER_DOCUMENT_FEATURE_TITLE);
            MappingAttributeHome.create(mappingAttribute, plugin);
            mappingAttribute = new MappingAttribute();
            mappingAttribute.setCodeDocumentType(strCodeDocumentType);
            mappingAttribute.setIdDocumentAttribute(-1);
            mappingAttribute.setIdCalendarAttribute(-1);
            mappingAttribute.setDocumentFeature(PARAMETER_DOCUMENT_FEATURE_SUMARY);
            MappingAttributeHome.create(mappingAttribute, plugin);
            return AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_URL_MODIFY_MAPPING + "?" + PARAMETER_MAPPING_CODE_DOCUMENT_TYPE + "=" + strCodeDocumentType;
        }
        return AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_URL_MANAGE_MAPPING;
    }

    public String getModifyMapping(HttpServletRequest request) {
        String strCodeDocumentType = request.getParameter(PARAMETER_MAPPING_CODE_DOCUMENT_TYPE);
        Plugin plugin = this.getPlugin();
        HashMap<String, Object> model = new HashMap<String, Object>();
        Mapping mapping = MappingHome.findByCodeDocumentType(strCodeDocumentType, plugin);
        List<MappingAttribute> mappingAttributeList = MappingService.getDocumentMappingAttributeList(strCodeDocumentType);
        model.put(MARK_MAPPING, mapping);
        model.put(MARK_MAPPING_ATTR_LIST, mappingAttributeList);
        this.setPageTitleProperty(PROPERTY_MODIFY_MAPPING_TITLE);
        HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_MODIFY_MAPPING, (Locale)this.getLocale(), model);
        return this.getAdminPage(templateList.getHtml());
    }

    public String doModifyMapping(HttpServletRequest request) {
        if (request.getParameter(PARAMETER_CANCEL) == null) {
            String strCodeDocumentType = request.getParameter(PARAMETER_MAPPING_CODE_DOCUMENT_TYPE);
            String strMappingDescription = request.getParameter(PARAMETER_MAPPING_DESCRIPTION);
            if (strMappingDescription == null || strMappingDescription.equals("")) {
                return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_MAPPING_DESCRIPTION_ERROR, (int)5);
            }
            Plugin plugin = this.getPlugin();
            Mapping mapping = MappingHome.findByCodeDocumentType(strCodeDocumentType, plugin);
            mapping.setDescription(strMappingDescription);
            MappingHome.update(mapping, plugin);
        }
        return AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_URL_MANAGE_MAPPING;
    }

    public String getModifyMappingAttribute(HttpServletRequest request) {
        String strIdMappingAttribute = request.getParameter(PARAMETER_ID_MAPPING_ATTR);
        Plugin plugin = this.getPlugin();
        MappingAttribute mappingAttribute = MappingService.getMappingAttribute(Integer.parseInt(strIdMappingAttribute));
        Mapping mapping = MappingHome.findByCodeDocumentType(mappingAttribute.getCodeDocumentType(), plugin);
        HashMap<String, Object> model = new HashMap<String, Object>();
        List<CalendarAttribute> calendarAttributeList = MappingService.getCalendarAttributeListByIdMappingAttribute(Integer.parseInt(strIdMappingAttribute));
        model.put(MARK_MAPPING, mapping);
        model.put(MARK_MAPPING_ATTR, mappingAttribute);
        model.put(MARK_CALENDAR_ATTR_LIST, calendarAttributeList);
        this.setPageTitleProperty(PROPERTY_MODIFY_MAPPING_ATTRIBUTE_TITLE);
        HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_MODIFY_ATTRIBUTE_MAPPING, (Locale)this.getLocale(), model);
        return this.getAdminPage(templateList.getHtml());
    }

    public String doModifyMappingAttribute(HttpServletRequest request) {
        String strIdMappingAttribute = request.getParameter(PARAMETER_ID_MAPPING_ATTR);
        Plugin plugin = this.getPlugin();
        if (strIdMappingAttribute == null || strIdMappingAttribute.equals("")) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_MAPPING_ATTRIBUT_ERROR, (int)2);
        }
        MappingAttribute mappingAttribute = MappingAttributeHome.findByPrimaryKey(Integer.parseInt(strIdMappingAttribute), plugin);
        if (mappingAttribute == null) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_MAPPING_ERROR, (int)2);
        }
        if (request.getParameter(PARAMETER_CANCEL) == null) {
            String strIdCalendarAttribute = request.getParameter(PARAMETER_ID_CALENDAR_ATTR);
            if (strIdCalendarAttribute == null || strIdCalendarAttribute.equals("")) {
                return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_MAPPING_CALENDAR_ERROR, (int)2);
            }
            mappingAttribute.setIdCalendarAttribute(Integer.parseInt(strIdCalendarAttribute));
            MappingAttributeHome.update(mappingAttribute, plugin);
        }
        UrlItem url = new UrlItem(AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_URL_MODIFY_MAPPING);
        url.addParameter(PARAMETER_MAPPING_CODE_DOCUMENT_TYPE, mappingAttribute.getCodeDocumentType());
        return url.getUrl();
    }

    public String getSelectCalendar(HttpServletRequest request) {
        String strIdDocument = request.getParameter("id_document");
        Plugin calendarPlugin = PluginService.getPlugin((String)"calendar");
        List calendarList = CalendarHome.findAgendaResourcesList((Plugin)calendarPlugin);
        if (calendarList.size() > 1) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put(MARK_CALENDAR_LIST, calendarList);
            model.put("id_document", strIdDocument);
            this.setPageTitleProperty(PROPERTY_SELECT_CALENDAR_TITLE);
            HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_SELECT_CALENDAR, (Locale)this.getLocale(), model);
            return this.getAdminPage(templateList.getHtml());
        }
        return this.getCreateEvent(request);
    }

    public String doSelectCalendar(HttpServletRequest request) {
        String strIdCalendar = request.getParameter("calendar_id");
        String strIdDocument = request.getParameter("id_document");
        Plugin calendarPlugin = PluginService.getPlugin((String)"calendar");
        if (strIdDocument == null || strIdDocument.equals("")) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_DOCUMENT_ERROR, (int)2);
        }
        if (strIdCalendar == null) {
            List calendarList = CalendarHome.findAgendaResourcesList((Plugin)calendarPlugin);
            if (calendarList.size() == 1) {
                strIdCalendar = ((AgendaResource)calendarList.get(0)).getId();
            } else {
                return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_CALENDAR_ERROR, (int)2);
            }
        }
        if (strIdCalendar.equals("")) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_CALENDAR_ERROR, (int)2);
        }
        AgendaResource calendar = CalendarHome.findAgendaResource((int)Integer.parseInt(strIdCalendar), (Plugin)calendarPlugin);
        if (calendar == null) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_CALENDAR_ERROR, (int)2);
        }
        UrlItem url = new UrlItem(AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_URL_CREATE_EVENT);
        url.addParameter("id_document", strIdDocument);
        url.addParameter("calendar_id", strIdCalendar);
        return url.getUrl();
    }

    public String getCreateEvent(HttpServletRequest request) {
        Plugin calendarPlugin;
        String strIdDocument = request.getParameter("id_document");
        String strIdCalendar = request.getParameter("calendar_id");
        if (strIdCalendar == null) {
            calendarPlugin = PluginService.getPlugin((String)"calendar");
            List calendarList = CalendarHome.findAgendaResourcesList((Plugin)calendarPlugin);
            strIdCalendar = ((AgendaResource)calendarList.get(0)).getId().toString();
        }
        calendarPlugin = PluginService.getPlugin((String)"calendar");
        Plugin plugin = this.getPlugin();
        int nDays = 1;
        Collection categoryList = CategoryHome.findAll((Plugin)calendarPlugin);
        HashMap<String, Object> model = new HashMap<String, Object>();
        String strBooleanTimeSpan = "TRUE";
        model.put(MARK_INTERVAL_TIME_SPAN, strBooleanTimeSpan);
        model.put("calendar_id", Integer.parseInt(strIdCalendar));
        model.put(MARK_LOCALE, this.getLocale().getLanguage());
        model.put(MARK_INTERVAL_LIST, this.getIntervalList(request));
        model.put(MARK_NUMBER_DAYS, nDays);
        model.put(MARK_INTERVAL_LIST, this.getIntervalList(request));
        model.put(MARK_TOP_EVENT_LIST, this.getTopEventList());
        model.put(MARK_EMAIL_NOTIFY, AppPropertiesService.getProperty((String)PROPERTY_EMAIL_NOTIFY));
        model.put(MARK_TOP_EVENT_DEFAULT, AppPropertiesService.getProperty((String)PROPERTY_TOP_EVENT_DEFAULT));
        model.put(MARK_INSERT_SERVICE_PAGE, JSP_GET_INSERT_SERVICE);
        model.put(MARK_INSERT_SERVICE_LINK_PAGE, JSP_GET_INSERT_LINK_SERVICE);
        model.put(MARK_WEBAPP_URL, AppPathService.getBaseUrl((HttpServletRequest)request));
        model.put(MARK_CATEGORY_LIST, new HashMap());
        model.put(MARK_CATEGORY_DEFAULT_LIST, categoryList);
        model.put("id_document", Integer.parseInt(strIdDocument));
        Document document = DocumentHome.findByPrimaryKey((int)Integer.parseInt(strIdDocument));
        List<MappingAttribute> mappingAttributeList = MappingService.getDocumentMappingAttributeList(document.getCodeDocumentType());
        for (MappingAttribute mappingAttribute : mappingAttributeList) {
            if (mappingAttribute.getIdCalendarAttribute() == -1) continue;
            CalendarAttribute calendarAttribute = CalendarAttributeHome.findByKey(mappingAttribute.getIdCalendarAttribute(), plugin);
            DocumentAttribute documentAttribute = DocumentAttributeHome.findByPrimaryKey((int)mappingAttribute.getIdDocumentAttribute());
            if (mappingAttribute.getIdDocumentAttribute() != -1) {
                if (calendarAttribute.getCalendarAttributeType().equals(PARAMETER_TYPE_TEXT) || calendarAttribute.getCalendarAttributeType().equals(PARAMETER_TYPE_NUMERICTEXT) || calendarAttribute.getCalendarAttributeType().equals(PARAMETER_TYPE_DATE)) {
                    model.put(calendarAttribute.getCalendarAttributeBookMark(), document.getAttribute(documentAttribute.getCode()).getTextValue());
                }
                if (!calendarAttribute.getCalendarAttributeType().equals(PARAMETER_TYPE_FILE)) continue;
                UrlItem url = new UrlItem(AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_GET_DOCUMENT_FILE);
                url.addParameter("id_document", strIdDocument);
                model.put(calendarAttribute.getCalendarAttributeBookMark(), url.getUrl());
                continue;
            }
            if (mappingAttribute.getDocumentFeature().equals(PARAMETER_DOCUMENT_FEATURE_TITLE)) {
                model.put(calendarAttribute.getCalendarAttributeBookMark(), document.getTitle());
            }
            if (!mappingAttribute.getDocumentFeature().equals(PARAMETER_DOCUMENT_FEATURE_SUMARY)) continue;
            model.put(calendarAttribute.getCalendarAttributeBookMark(), document.getSummary());
        }
        this.setPageTitleProperty(PROPERTY_CREATE_EVENT_TITLE);
        HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_CREATE_EVENT, (Locale)this.getLocale(), model);
        return this.getAdminPage(templateList.getHtml());
    }

    public void doManageCreateEvent(HttpServletRequest request) {
        MultipartHttpServletRequest mRequest;
        FileItem item;
        String strIdDocument = request.getParameter("id_document");
        if (strIdDocument != null && !strIdDocument.equals("") && (item = (mRequest = (MultipartHttpServletRequest)request).getFile(PARAMETER_EVENT_IMAGE)).getSize() < 1L) {
            Document document = DocumentHome.findByPrimaryKey((int)Integer.parseInt(strIdDocument));
            DocumentAttribute documentAttribute = document.getAttribute(PARAMETER_TYPE_FILE);
            byte[] fileContent = documentAttribute.getBinaryValue();
            String strMimeType = documentAttribute.getValueContentType();
            HttpSession session = request.getSession(true);
            session.setAttribute("lutece_document_calendar_content_file", (Object)fileContent);
            session.setAttribute("lutece_document_calendar_mime_type_file", (Object)strMimeType);
        }
    }

    public ReferenceList getIntervalList(HttpServletRequest request) {
        StringTokenizer st = new StringTokenizer(AppPropertiesService.getProperty((String)PROPERTY_TIME_INTERVAL_LIST), ",");
        ReferenceList timeIntervalList = new ReferenceList();
        while (st.hasMoreElements()) {
            String strIntervalName = st.nextToken().trim();
            String strDescription = I18nService.getLocalizedString((String)("calendar.interval.periodicity." + strIntervalName + ".description"), (Locale)this.getLocale());
            int nDays = AppPropertiesService.getPropertyInt((String)("calendar.interval." + strIntervalName + ".value"), (int)7);
            timeIntervalList.addItem(nDays, strDescription);
        }
        return timeIntervalList;
    }

    private ReferenceList getTopEventList() {
        ReferenceList list = new ReferenceList();
        StringTokenizer st = new StringTokenizer(I18nService.getLocalizedString((String)PROPERTY_TOP_EVENT_LIST, (Locale)this.getLocale()), ",");
        int i = 0;
        while (st.hasMoreElements()) {
            list.addItem(i++, st.nextToken().trim());
        }
        return list;
    }

    public void getFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String strIdDocument = request.getParameter("id_document");
        if (strIdDocument != null && !strIdDocument.equals("")) {
            Document document = DocumentHome.findByPrimaryKey((int)Integer.parseInt(strIdDocument));
            DocumentAttribute documentAttribute = document.getAttribute(PARAMETER_TYPE_FILE);
            byte[] fileContent = documentAttribute.getBinaryValue();
            String strMimeType = documentAttribute.getValueContentType();
            String strname = documentAttribute.getTextValue();
            response.setHeader("Content-Disposition", "attachment;filename=\"" + strname + "\"");
            response.setContentType(strMimeType);
            response.setHeader("Cache-Control", "must-revalidate");
            response.getOutputStream().write(fileContent);
        }
    }
}

