/*
 * Copyright (c) 2002-2014, Mairie de Paris
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice
 *     and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright notice
 *     and the following disclaimer in the documentation and/or other materials
 *     provided with the distribution.
 *
 *  3. Neither the name of 'Mairie de Paris' nor 'Lutece' nor the names of its
 *     contributors may be used to endorse or promote products derived from
 *     this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * License 1.0
 */
package fr.paris.lutece.plugins.document.modules.calendar.business;


/**
 *
 * class mapping
 *
 */
public class Mapping
{
    private String _strCodeDocumentType;
    private String _strDescription;
    private String _strDocumentTypeName;

    /**
     * set the Code of the document type of the mapping
     * @param strCodeDocumentType the code of the document type
     */
    public void setCodeDocumentType( String strCodeDocumentType )
    {
        _strCodeDocumentType = strCodeDocumentType;
    }

    /**
    *
    * @return the Code of the document type
    */
    public String getCodeDocumentType(  )
    {
        return _strCodeDocumentType;
    }

    /**
     * set the description of the mapping
     * @param strDescription the description of the mapping
     */
    public void setDescription( String strDescription )
    {
        _strDescription = strDescription;
    }

    /**
    *
    * @return the description of the mapping
    */
    public String getDescription(  )
    {
        return _strDescription;
    }

    /**
     * set the name of the document type
     * @param strDocumentTypeName the name of the document type
     */
    public void setDocumentTypeName( String strDocumentTypeName )
    {
        _strDocumentTypeName = strDocumentTypeName;
    }

    /**
    *
    * @return the name of the document type
    */
    public String getDocumentTypeName(  )
    {
        return _strDocumentTypeName;
    }
}
