/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.jpa.modules.hibernate.service;

import fr.paris.lutece.plugins.jpa.modules.hibernate.service.HibernateStatistics;
import fr.paris.lutece.portal.service.jpa.EntityManagerService;
import fr.paris.lutece.portal.service.util.AppPropertiesService;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.persistence.EntityManagerFactory;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.jmx.StatisticsService;
import org.hibernate.stat.Statistics;

public class HibernateMonitorService {
    private static final Logger logger = Logger.getLogger((String)"lutece.jpa");
    private EntityManagerService _service;
    private boolean _bJMXEnabled;
    private boolean _bStatisticsEnabled;

    public List<HibernateStatistics> computeStatistics() {
        ArrayList<HibernateStatistics> listStats = new ArrayList<HibernateStatistics>();
        for (Map.Entry entry : this._service.getEntityManagerFactories().entrySet()) {
            Statistics stats = this.getEntityManagerFactoryImpl((EntityManagerFactory)entry.getValue()).getSessionFactory().getStatistics();
            HibernateStatistics hibernateStatistics = new HibernateStatistics();
            hibernateStatistics.setPoolName((String)entry.getKey());
            hibernateStatistics.setStats(stats);
            listStats.add(hibernateStatistics);
        }
        return listStats;
    }

    public void setJMXEnabled(boolean bJMXEnabled) {
        this._bJMXEnabled = bJMXEnabled;
    }

    public boolean isJMXEnabled() {
        return this._bJMXEnabled;
    }

    public void setStatisticsEnabled(boolean bStatisticsEnabled) {
        this._bStatisticsEnabled = bStatisticsEnabled;
    }

    public boolean isStatisticsEnabled() {
        return this._bStatisticsEnabled;
    }

    public void setEntityManagerService(EntityManagerService service) {
        this._service = service;
    }

    public EntityManagerService getEntityManagerService() {
        return this._service;
    }

    public void init() {
        if (this.isStatisticsEnabled()) {
            if (this._service.getEntityManagerFactories() != null) {
                this.doEnableStatistics();
            } else {
                logger.error((Object)"EntityManagerService is not started yet, can't enable hibernate statistics. Manual activation needed.");
                this.setStatisticsEnabled(false);
            }
        }
        if (this.isJMXEnabled()) {
            if (this._service.getEntityManagerFactories() != null) {
                this.setJMXEnabled(this.registerMBeans(this._service.getEntityManagerFactories()));
                this.setStatisticsEnabled(true);
            } else {
                logger.error((Object)"EntityManagerService is not started yet, can't start hibernate JMX beans. Manual activation needed.");
                this.setJMXEnabled(false);
            }
        }
    }

    public boolean doActivateJMXBeans() {
        if (this._service.getEntityManagerFactories() != null) {
            this.setJMXEnabled(this.registerMBeans(this._service.getEntityManagerFactories()));
        }
        return this.isJMXEnabled();
    }

    public void doClearStatistics(String strPoolName) {
        EntityManagerFactory emf = this._service.getEntityManagerFactory(strPoolName);
        if (emf != null) {
            HibernateEntityManagerFactory emfImpl = this.getEntityManagerFactoryImpl(emf);
            emfImpl.getSessionFactory().getStatistics().clear();
        }
    }

    public void doEnableStatistics() {
        this.setHibernateStatisticsEnabled(true);
    }

    public void doDisableStatistics() {
        this.setHibernateStatisticsEnabled(false);
    }

    private void setHibernateStatisticsEnabled(boolean bEnabled) {
        for (EntityManagerFactory emf : this._service.getEntityManagerFactories().values()) {
            HibernateEntityManagerFactory emfImpl = this.getEntityManagerFactoryImpl(emf);
            emfImpl.getSessionFactory().getStatistics().setStatisticsEnabled(bEnabled);
            if (bEnabled) continue;
            emfImpl.getSessionFactory().getStatistics().clear();
        }
        this.setStatisticsEnabled(bEnabled);
    }

    private HibernateEntityManagerFactory getEntityManagerFactoryImpl(EntityManagerFactory emf) {
        return (HibernateEntityManagerFactory)emf;
    }

    private boolean registerMBeans(Map<String, EntityManagerFactory> mapFactories) {
        logger.debug((Object)"Initializing JMX for hibernate");
        for (Map.Entry<String, EntityManagerFactory> entry : mapFactories.entrySet()) {
            logger.debug((Object)("Registering JMX for hibernate pool : " + entry.getKey()));
            HibernateEntityManagerFactory emf = this.getEntityManagerFactoryImpl(entry.getValue());
            if (this.registerMBean(emf.getSessionFactory(), entry.getKey())) continue;
            return false;
        }
        return true;
    }

    private boolean registerMBean(SessionFactory sessionFactory, String strPoolName) {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        StatisticsService mBean = new StatisticsService();
        mBean.setStatisticsEnabled(true);
        mBean.setSessionFactory(sessionFactory);
        try {
            ObjectName name = new ObjectName("Hibernate:type=statistics-" + strPoolName + ",application=" + AppPropertiesService.getProperty((String)"lutece.name"));
            mbeanServer.registerMBean(mBean, name);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getName() {
        return "HibernateMonitor";
    }
}

