/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.jpa.modules.hibernate.web;

import fr.paris.lutece.plugins.jpa.modules.hibernate.service.HibernateMonitorService;
import fr.paris.lutece.plugins.jpa.modules.hibernate.service.HibernateStatistics;
import fr.paris.lutece.portal.service.spring.SpringContextService;
import fr.paris.lutece.portal.service.template.AppTemplateService;
import fr.paris.lutece.portal.service.util.AppLogService;
import fr.paris.lutece.portal.service.util.AppPathService;
import fr.paris.lutece.portal.web.admin.PluginAdminPageJspBean;
import fr.paris.lutece.util.html.HtmlTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class HibernateMonitorJspBean
extends PluginAdminPageJspBean {
    public static final String RIGHT_MONITOR_HIBERNATE = "HIBERNATE_MONITOR";
    private static final String PARAMETER_POOL_NAME = "pool_name";
    private static final String MARK_LIST_STATS = "list_stats";
    private static final String MARK_JMX_STATE = "jmx_state";
    private static final String MARK_STATS_STATE = "stats_state";
    private static final String TEMPLATE_HIBERNATE_MONITOR = "admin/plugins/jpa/modules/hibernate/monitor_hibernate.html";
    private static final String JSP_HIBERNATE_MONITOR = "jsp/admin/plugins/jpa/modules/hibernate/Monitor.jsp";

    private HibernateMonitorService getHibernateMonitorService() {
        return (HibernateMonitorService)SpringContextService.getBean((String)"jpa-hibernate.monitorService");
    }

    public String getHibernateMonitor(HttpServletRequest request) {
        HibernateMonitorService monitorService = this.getHibernateMonitorService();
        HashMap<String, Object> model = new HashMap<String, Object>();
        List<HibernateStatistics> listStats = monitorService.computeStatistics();
        model.put(MARK_LIST_STATS, listStats);
        model.put(MARK_JMX_STATE, monitorService.isJMXEnabled());
        model.put(MARK_STATS_STATE, monitorService.isStatisticsEnabled());
        HtmlTemplate template = AppTemplateService.getTemplate((String)TEMPLATE_HIBERNATE_MONITOR, (Locale)this.getUser().getLocale(), model);
        return this.getAdminPage(template.getHtml());
    }

    public String doActivateJMX(HttpServletRequest request) {
        HibernateMonitorService monitorService = this.getHibernateMonitorService();
        if (!monitorService.doActivateJMXBeans()) {
            AppLogService.error((Object)"Failed to activate hibernate JMX beans");
        }
        return AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_HIBERNATE_MONITOR;
    }

    public String doClearStatistics(HttpServletRequest request) {
        String strPoolName = request.getParameter(PARAMETER_POOL_NAME);
        if (StringUtils.isNotBlank((String)strPoolName)) {
            HibernateMonitorService monitorService = this.getHibernateMonitorService();
            monitorService.doClearStatistics(strPoolName);
        }
        return AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_HIBERNATE_MONITOR;
    }

    public String doEnableStatistics(HttpServletRequest request) {
        this.getHibernateMonitorService().doEnableStatistics();
        return AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_HIBERNATE_MONITOR;
    }

    public String doDisableStatistics(HttpServletRequest request) {
        this.getHibernateMonitorService().doDisableStatistics();
        return AppPathService.getBaseUrl((HttpServletRequest)request) + JSP_HIBERNATE_MONITOR;
    }
}

