/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.childpages.business.portlet;

import fr.paris.lutece.plugins.childpages.business.portlet.ChildPagesPortlet;
import fr.paris.lutece.plugins.childpages.business.portlet.IChildPagesPortletDAO;
import fr.paris.lutece.portal.business.portlet.Portlet;
import fr.paris.lutece.util.ReferenceList;
import fr.paris.lutece.util.sql.DAOUtil;

public final class ChildPagesPortletDAO
implements IChildPagesPortletDAO {
    private static final String SQL_QUERY_INSERT = "INSERT INTO childpages_portlet ( id_portlet, id_child_page ) VALUES ( ?,? )";
    private static final String SQL_QUERY_DELETE = "DELETE FROM childpages_portlet WHERE id_portlet = ?";
    private static final String SQL_QUERY_SELECT = "SELECT id_portlet, id_child_page FROM childpages_portlet WHERE id_portlet = ?";
    private static final String SQL_QUERY_UPDATE = "UPDATE childpages_portlet SET id_child_page = ? WHERE id_portlet = ?";
    private static final String SQL_QUERY_SELECT_CHILDPAGE_LIST = "SELECT id_page, name FROM core_page WHERE id_page = ?";
    private static final String SQL_QUERY_SELECT_PAGE_LIST = "SELECT id_page, name FROM core_page";

    public void insert(Portlet portlet) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_INSERT);
        ChildPagesPortlet p = (ChildPagesPortlet)portlet;
        daoUtil.setInt(1, p.getId());
        daoUtil.setInt(2, p.getParentPageId());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    public void delete(int nPortletId) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_DELETE);
        daoUtil.setInt(1, nPortletId);
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    public Portlet load(int nPortletId) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT);
        daoUtil.setInt(1, nPortletId);
        daoUtil.executeQuery();
        ChildPagesPortlet portlet = new ChildPagesPortlet();
        if (daoUtil.next()) {
            portlet.setId(daoUtil.getInt(1));
            portlet.setParentPageId(daoUtil.getInt(2));
        }
        daoUtil.free();
        return portlet;
    }

    public void store(Portlet portlet) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_UPDATE);
        ChildPagesPortlet p = (ChildPagesPortlet)portlet;
        daoUtil.setInt(1, p.getParentPageId());
        daoUtil.setInt(2, p.getId());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    public ReferenceList selectChildPagesList(int nPageId) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT_CHILDPAGE_LIST);
        daoUtil.setInt(1, nPageId);
        daoUtil.executeQuery();
        ReferenceList list = new ReferenceList();
        while (daoUtil.next()) {
            list.addItem(daoUtil.getInt(1), daoUtil.getString(2));
        }
        daoUtil.free();
        return list;
    }

    public ReferenceList selectPagesList() {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT_PAGE_LIST);
        daoUtil.executeQuery();
        ReferenceList list = new ReferenceList();
        while (daoUtil.next()) {
            list.addItem(daoUtil.getInt(1), daoUtil.getString(2));
        }
        daoUtil.free();
        return list;
    }
}

