/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.paybox;

import fr.paris.lutece.plugins.paybox.item.PayboxUrlItem;
import fr.paris.lutece.plugins.paybox.util.PayboxUserProperties;
import fr.paris.lutece.portal.service.util.AppLogService;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.util.io.pem.PemReader;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public final class PayboxUtil {
    private static final String CHARSET = "utf-8";
    private static final String ENCRYPTION_ALGORITHM = "RSA";
    private static final String HASH_ENCRYPTION_ALGORITHM = "SHA1withRSA";
    private static final String HASH_METHOD = "Sha512";
    private static final String HMAC_METHOD = "HmacSHA512";

    private PayboxUtil() {
    }

    private static String addKeyValueElement(boolean urlencode, Map.Entry<String, String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(set.getKey());
        stringBuilder.append('=');
        if (urlencode) {
            try {
                stringBuilder.append(URLEncoder.encode(set.getValue(), CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                AppLogService.error((Object)e);
            }
        } else {
            stringBuilder.append(set.getValue());
        }
        return stringBuilder.toString();
    }

    public static String buildPayboxUrl(Long amountInCents, String orderReference, String email) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("PBX_SITE", PayboxUserProperties.SITE);
        params.put("PBX_RANG", PayboxUserProperties.RANG);
        params.put("PBX_IDENTIFIANT", PayboxUserProperties.IDENTIFIANT);
        params.put("PBX_PAYBOX", PayboxUserProperties.PAYBOX);
        params.put("PBX_BACKUP1", PayboxUserProperties.BACKUP1);
        params.put("PBX_BACKUP2", PayboxUserProperties.BACKUP2);
        params.put("PBX_TOTAL", String.valueOf(amountInCents));
        params.put("PBX_DEVISE", PayboxUserProperties.DEVISE);
        params.put("PBX_CMD", orderReference);
        params.put("PBX_PORTEUR", email);
        params.put("PBX_RETOUR", PayboxUserProperties.RETOUR);
        params.put("PBX_EFFECTUE", PayboxUserProperties.EFFECTUE);
        params.put("PBX_REFUSE", PayboxUserProperties.REFUSE);
        params.put("PBX_ANNULE", PayboxUserProperties.ANNULE);
        params.put("PBX_REPONDRE_A", PayboxUserProperties.REPONDRA);
        return PayboxUtil.buildPayboxUrl(PayboxUserProperties.URL, params);
    }

    public static String buildPayboxUrl(PayboxUrlItem payboxUrlItem) {
        return PayboxUtil.buildPayboxUrl(payboxUrlItem.getAmountInCents(), payboxUrlItem.getOrderReference(), payboxUrlItem.getEmail());
    }

    public static String buildPayboxUrl(String url, LinkedHashMap<String, String> params) {
        params.remove("PBX_TIME");
        params.remove("PBX_HASH");
        params.remove("PBX_HMAC");
        params.put("PBX_TIME", ISODateTimeFormat.dateHourMinuteSecond().print((ReadableInstant)new DateTime()));
        params.put("PBX_HASH", HASH_METHOD);
        params.put("PBX_HMAC", PayboxUtil.generateHMAC(PayboxUtil.join(params, false)));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(url);
        stringBuilder.append('?');
        stringBuilder.append(PayboxUtil.join(params, true));
        return stringBuilder.toString();
    }

    public static boolean checkSignature(String queryString) {
        String[] params = queryString.split("&");
        Object[] paramsMinusOne = new String[params.length - 1];
        for (int i = 0; i < params.length - 1; ++i) {
            paramsMinusOne[i] = params[i];
        }
        String payboxParams = StringUtils.join((Object[])paramsMinusOne, (String)"&");
        String sign = params[params.length - 1].split("=")[1];
        return PayboxUtil.checkSignature(payboxParams, sign, PayboxUserProperties.PUBLIC_KEY_PATH);
    }

    public static boolean checkSignature(String message, String sign, String keyPath) {
        boolean ret;
        try {
            ret = PayboxUtil.verify(message, sign, PayboxUtil.getKey(keyPath));
        }
        catch (FileNotFoundException e) {
            ret = false;
            AppLogService.error((Object)e);
        }
        catch (IOException e) {
            ret = false;
            AppLogService.error((Object)e);
        }
        catch (NoSuchAlgorithmException e) {
            ret = false;
            AppLogService.error((Object)e);
        }
        catch (InvalidKeySpecException e) {
            ret = false;
            AppLogService.error((Object)e);
        }
        catch (InvalidKeyException e) {
            ret = false;
            AppLogService.error((Object)e);
        }
        catch (SignatureException e) {
            ret = false;
            AppLogService.error((Object)e);
        }
        return ret;
    }

    private static String generateHMAC(String payboxParameters) {
        String result;
        try {
            byte[] bytesKey = DatatypeConverter.parseHexBinary((String)PayboxUserProperties.KEY);
            SecretKeySpec secretKey = new SecretKeySpec(bytesKey, HMAC_METHOD);
            Mac mac = Mac.getInstance(HMAC_METHOD);
            mac.init(secretKey);
            byte[] macData = mac.doFinal(payboxParameters.getBytes(CHARSET));
            byte[] hex = new Hex().encode(macData);
            result = new String(hex, CHARSET);
        }
        catch (NoSuchAlgorithmException e) {
            result = "";
            AppLogService.error((Object)e);
        }
        catch (InvalidKeyException e) {
            result = "";
            AppLogService.error((Object)e);
        }
        catch (UnsupportedEncodingException e) {
            result = "";
            AppLogService.error((Object)e);
        }
        return result.toUpperCase();
    }

    private static PublicKey getKey(String keyPath) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ENCRYPTION_ALGORITHM);
        PemReader reader = new PemReader((Reader)new FileReader(keyPath));
        byte[] pubKey = reader.readPemObject().getContent();
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(pubKey);
        PublicKey generatePublic = keyFactory.generatePublic(publicKeySpec);
        reader.close();
        return generatePublic;
    }

    private static String join(LinkedHashMap<String, String> params, boolean urlencode) {
        Object[] elems = new String[params.size()];
        int index = 0;
        for (Map.Entry<String, String> set : params.entrySet()) {
            elems[index++] = PayboxUtil.addKeyValueElement(urlencode, set);
        }
        return StringUtils.join((Object[])elems, (char)'&');
    }

    private static boolean verify(String message, String sign, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        Signature sig = Signature.getInstance(HASH_ENCRYPTION_ALGORITHM);
        sig.initVerify(publicKey);
        sig.update(message.getBytes(CHARSET));
        Base64 b64 = new Base64();
        byte[] bytes = b64.decode(URLDecoder.decode(sign, CHARSET).getBytes(CHARSET));
        return sig.verify(bytes);
    }
}

