/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.paybox.dao.impl;

import fr.paris.lutece.plugins.paybox.dao.PayboxLogDAO;
import fr.paris.lutece.plugins.paybox.dao.entity.PayboxLogEntity;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.util.sql.DAOUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PayboxLogDAOImpl
implements PayboxLogDAO {
    private static final String SQL_QUERY_DELETE = "DELETE FROM paybox_log WHERE order_reference = ?";
    private static final String SQL_QUERY_INSERT = "INSERT INTO paybox_log(id, date, order_reference) VALUES (?, ?, ?)";
    private static final String SQL_QUERY_NEWPK = "SELECT max( id ) FROM paybox_log;";
    private static final String SQL_QUERY_SELECTALL = "SELECT id, date, order_reference FROM paybox_log ORDER BY order_reference DESC";

    @Override
    public void addLog(PayboxLogEntity payboxLogEntity, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_INSERT, plugin);
        Long id = this.newPrimaryKey(plugin);
        payboxLogEntity.setId(id);
        payboxLogEntity.setDate(new Date());
        daoUtil.setLong(1, payboxLogEntity.getId().longValue());
        daoUtil.setTimestamp(2, new Timestamp(payboxLogEntity.getDate().getTime()));
        daoUtil.setString(3, payboxLogEntity.getOrderReference());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public List<PayboxLogEntity> getAll(Plugin plugin) {
        ArrayList<PayboxLogEntity> ret = new ArrayList<PayboxLogEntity>();
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECTALL, plugin);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            PayboxLogEntity payboxLogEntity = new PayboxLogEntity();
            payboxLogEntity.setId(daoUtil.getLong(1));
            payboxLogEntity.setDate(new Date(daoUtil.getTimestamp(2).getTime()));
            payboxLogEntity.setOrderReference(daoUtil.getString(3));
            ret.add(payboxLogEntity);
        }
        daoUtil.free();
        return ret;
    }

    private Long newPrimaryKey(Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_NEWPK, plugin);
        daoUtil.executeQuery();
        if (!daoUtil.next()) {
            Long l = 1L;
        }
        Long nKey = daoUtil.getLong(1) + 1L;
        daoUtil.free();
        return nKey;
    }

    @Override
    public void removeLog(String orderReference, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_DELETE, plugin);
        daoUtil.setString(1, orderReference);
        daoUtil.executeUpdate();
        daoUtil.free();
    }
}

