/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.paybox.web;

import fr.paris.lutece.plugins.paybox.PayboxUtil;
import fr.paris.lutece.plugins.paybox.item.PayboxUrlItem;
import fr.paris.lutece.plugins.paybox.service.PayboxLogService;
import fr.paris.lutece.plugins.paybox.service.PayboxService;
import fr.paris.lutece.portal.service.plugin.PluginService;
import fr.paris.lutece.portal.service.spring.SpringContextService;
import fr.paris.lutece.portal.service.util.AppLogService;
import fr.paris.lutece.portal.web.system.PluginJspBean;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PayboxJspBean
extends PluginJspBean {
    private final PayboxLogService _payboxLogService = (PayboxLogService)SpringContextService.getBean((String)"paybox.payboxLogService");

    public void getPayboxAccess(HttpServletRequest request, HttpServletResponse response) {
        List listPayboxServices = SpringContextService.getBeansOfType(PayboxService.class);
        if (listPayboxServices == null || listPayboxServices.isEmpty()) {
            AppLogService.error((Object)"No PayboxService bean defined. Please check your Spring configuration.");
        } else if (listPayboxServices.size() > 1) {
            AppLogService.error((Object)"Multiple PayboxService beans defined. Please check your Spring configuration.");
        } else {
            PayboxService payboxService = (PayboxService)listPayboxServices.get(0);
            AppLogService.debug((Object)("Using " + payboxService.getClass() + " as PayboxService"));
            try {
                PayboxUrlItem payboxUrlItem = payboxService.handlePayboxAccess(request, response);
                if (payboxUrlItem != null) {
                    this._payboxLogService.addLog(payboxUrlItem.getOrderReference(), PluginService.getPlugin((String)"paybox"));
                    response.sendRedirect(PayboxUtil.buildPayboxUrl(payboxUrlItem));
                } else {
                    response.sendRedirect(request.getHeader("Referer"));
                }
            }
            catch (Exception e) {
                AppLogService.error((Object)e);
            }
        }
    }
}

