/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.paybox.web;

import fr.paris.lutece.plugins.paybox.PayboxUtil;
import fr.paris.lutece.plugins.paybox.service.PayboxLogService;
import fr.paris.lutece.plugins.paybox.service.PayboxService;
import fr.paris.lutece.portal.service.plugin.PluginService;
import fr.paris.lutece.portal.service.spring.SpringContextService;
import fr.paris.lutece.portal.service.util.AppLogService;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PayboxServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final PayboxLogService _payboxLogService = (PayboxLogService)SpringContextService.getBean((String)"paybox.payboxLogService");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (PayboxUtil.checkSignature(request.getQueryString())) {
            this._payboxLogService.removeLog(request.getParameter("reference"), PluginService.getPlugin((String)"paybox"));
            String error = request.getParameter("error");
            if (error.equals("00000")) {
                this.delagate(request, response);
            } else {
                AppLogService.info((Object)("Transaction termin\u00e9e avec code d'erreur : " + error));
            }
        } else {
            AppLogService.error((Object)"Probl\u00e8me de v\u00e9rification de la signature.");
        }
        response.setStatus(200);
    }

    private void delagate(HttpServletRequest request, HttpServletResponse response) {
        List listPayboxServices = SpringContextService.getBeansOfType(PayboxService.class);
        if (listPayboxServices == null || listPayboxServices.isEmpty()) {
            AppLogService.error((Object)"No PayboxService bean defined. Please check your Spring configuration.");
        } else if (listPayboxServices.size() > 1) {
            AppLogService.error((Object)"Multiple PayboxService beans defined. Please check your Spring configuration.");
        } else {
            PayboxService payboxService = (PayboxService)listPayboxServices.get(0);
            AppLogService.debug((Object)("Using " + payboxService.getClass() + " as PayboxService"));
            try {
                payboxService.handlePayboxReturn(request, response);
            }
            catch (Exception e) {
                AppLogService.error((Object)e);
            }
        }
    }
}

