/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.business;

import fr.paris.lutece.plugins.seo.business.FriendlyUrl;
import fr.paris.lutece.plugins.seo.business.IFriendlyUrlDAO;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.util.sql.DAOUtil;
import java.util.ArrayList;
import java.util.List;

public final class FriendlyUrlDAO
implements IFriendlyUrlDAO {
    private static final String SQL_QUERY_NEW_PK = "SELECT max( id_url ) FROM seo_friendly_url";
    private static final String SQL_QUERY_SELECT = "SELECT id_url, friendly_url, technical_url, date_creation, date_modification, is_canonical, is_sitemap, sitemap_lastmod, sitemap_changefreq, sitemap_priority FROM seo_friendly_url WHERE id_url = ?";
    private static final String SQL_QUERY_INSERT_PREFIX = "INSERT INTO seo_friendly_url ( id_url, friendly_url, technical_url, date_creation, date_modification, is_canonical, is_sitemap, sitemap_lastmod, sitemap_changefreq, sitemap_priority ) VALUES ( ?, ?, ?, ";
    private static final String SQL_QUERY_INSERT_SUFFIX = " ?, ?, ?, ?, ? ) ";
    private static final String SQL_QUERY_DELETE = "DELETE FROM seo_friendly_url WHERE id_url = ? ";
    private static final String SQL_QUERY_UPDATE_PREFIX = "UPDATE seo_friendly_url SET id_url = ?, friendly_url = ?, technical_url = ?,";
    private static final String SQL_QUERY_UPDATE_DATE_CREATION_FRAGMENT = " date_creation = ";
    private static final String SQL_QUERY_UPDATE_DATE_MODIFICATION_FRAGMENT = " date_modification = ";
    private static final String SQL_QUERY_UPDATE_SUFFIX = "is_canonical = ?, is_sitemap = ?, sitemap_lastmod = ? , sitemap_changefreq = ? , sitemap_priority = ? WHERE id_url = ?";
    private static final String SQL_QUERY_SELECTALL = "SELECT id_url, friendly_url, technical_url, date_creation, date_modification, is_canonical, is_sitemap, sitemap_lastmod, sitemap_changefreq, sitemap_priority  FROM seo_friendly_url";

    public int newPrimaryKey(Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_NEW_PK, plugin);
        daoUtil.executeQuery();
        if (!daoUtil.next()) {
            boolean bl = true;
        }
        int nKey = daoUtil.getInt(1) + 1;
        daoUtil.free();
        return nKey;
    }

    @Override
    public void insert(FriendlyUrl friendlyUrl, Plugin plugin) {
        StringBuilder query = new StringBuilder(SQL_QUERY_INSERT_PREFIX);
        if (friendlyUrl.getDateCreation() != null) {
            query.append("?, ");
        } else {
            query.append("DEFAULT, ");
        }
        if (friendlyUrl.getDateModification() != null) {
            query.append("?, ");
        } else {
            query.append("DEFAULT, ");
        }
        query.append(SQL_QUERY_INSERT_SUFFIX);
        DAOUtil daoUtil = new DAOUtil(query.toString(), plugin);
        friendlyUrl.setId(this.newPrimaryKey(plugin));
        int argIdx = 1;
        daoUtil.setInt(argIdx++, friendlyUrl.getId());
        daoUtil.setString(argIdx++, friendlyUrl.getFriendlyUrl());
        daoUtil.setString(argIdx++, friendlyUrl.getTechnicalUrl());
        if (friendlyUrl.getDateCreation() != null) {
            daoUtil.setTimestamp(argIdx++, friendlyUrl.getDateCreation());
        }
        if (friendlyUrl.getDateModification() != null) {
            daoUtil.setTimestamp(argIdx++, friendlyUrl.getDateModification());
        }
        daoUtil.setBoolean(argIdx++, friendlyUrl.isCanonical());
        daoUtil.setBoolean(argIdx++, friendlyUrl.isSitemap());
        daoUtil.setString(argIdx++, friendlyUrl.getSitemapLastmod());
        daoUtil.setString(argIdx++, friendlyUrl.getSitemapChangeFreq());
        daoUtil.setString(argIdx++, friendlyUrl.getSitemapPriority());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public FriendlyUrl load(int nId, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT, plugin);
        daoUtil.setInt(1, nId);
        daoUtil.executeQuery();
        FriendlyUrl friendlyUrl = null;
        if (daoUtil.next()) {
            friendlyUrl = new FriendlyUrl();
            friendlyUrl.setId(daoUtil.getInt(1));
            friendlyUrl.setFriendlyUrl(daoUtil.getString(2));
            friendlyUrl.setTechnicalUrl(daoUtil.getString(3));
            friendlyUrl.setDateCreation(daoUtil.getTimestamp(4));
            friendlyUrl.setDateModification(daoUtil.getTimestamp(5));
            friendlyUrl.setCanonical(daoUtil.getBoolean(6));
            friendlyUrl.setSitemap(daoUtil.getBoolean(7));
            friendlyUrl.setSitemapLastmod(daoUtil.getString(8));
            friendlyUrl.setSitemapChangeFreq(daoUtil.getString(9));
            friendlyUrl.setSitemapPriority(daoUtil.getString(10));
        }
        daoUtil.free();
        return friendlyUrl;
    }

    @Override
    public void delete(int nFriendlyUrlId, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_DELETE, plugin);
        daoUtil.setInt(1, nFriendlyUrlId);
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public void store(FriendlyUrl friendlyUrl, Plugin plugin) {
        StringBuilder query = new StringBuilder(SQL_QUERY_UPDATE_PREFIX);
        query.append(SQL_QUERY_UPDATE_DATE_CREATION_FRAGMENT);
        if (friendlyUrl.getDateCreation() != null) {
            query.append("?, ");
        } else {
            query.append("DEFAULT, ");
        }
        query.append(SQL_QUERY_UPDATE_DATE_MODIFICATION_FRAGMENT);
        if (friendlyUrl.getDateModification() != null) {
            query.append("?, ");
        } else {
            query.append("DEFAULT, ");
        }
        query.append(SQL_QUERY_UPDATE_SUFFIX);
        DAOUtil daoUtil = new DAOUtil(query.toString(), plugin);
        int argIdx = 1;
        daoUtil.setInt(argIdx++, friendlyUrl.getId());
        daoUtil.setString(argIdx++, friendlyUrl.getFriendlyUrl());
        daoUtil.setString(argIdx++, friendlyUrl.getTechnicalUrl());
        if (friendlyUrl.getDateCreation() != null) {
            daoUtil.setTimestamp(argIdx++, friendlyUrl.getDateCreation());
        }
        if (friendlyUrl.getDateModification() != null) {
            daoUtil.setTimestamp(argIdx++, friendlyUrl.getDateModification());
        }
        daoUtil.setBoolean(argIdx++, friendlyUrl.isCanonical());
        daoUtil.setBoolean(argIdx++, friendlyUrl.isSitemap());
        daoUtil.setString(argIdx++, friendlyUrl.getSitemapLastmod());
        daoUtil.setString(argIdx++, friendlyUrl.getSitemapChangeFreq());
        daoUtil.setString(argIdx++, friendlyUrl.getSitemapPriority());
        daoUtil.setInt(argIdx++, friendlyUrl.getId());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public List<FriendlyUrl> selectFriendlyUrlsList(Plugin plugin) {
        ArrayList<FriendlyUrl> friendlyUrlList = new ArrayList<FriendlyUrl>();
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECTALL, plugin);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            FriendlyUrl friendlyUrl = new FriendlyUrl();
            friendlyUrl.setId(daoUtil.getInt(1));
            friendlyUrl.setFriendlyUrl(daoUtil.getString(2));
            friendlyUrl.setTechnicalUrl(daoUtil.getString(3));
            friendlyUrl.setDateCreation(daoUtil.getTimestamp(4));
            friendlyUrl.setDateModification(daoUtil.getTimestamp(5));
            friendlyUrl.setCanonical(daoUtil.getBoolean(6));
            friendlyUrl.setSitemap(daoUtil.getBoolean(7));
            friendlyUrl.setSitemapLastmod(daoUtil.getString(8));
            friendlyUrl.setSitemapChangeFreq(daoUtil.getString(9));
            friendlyUrl.setSitemapPriority(daoUtil.getString(10));
            friendlyUrlList.add(friendlyUrl);
        }
        daoUtil.free();
        return friendlyUrlList;
    }
}

