/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.business;

import fr.paris.lutece.plugins.seo.business.FriendlyUrl;
import fr.paris.lutece.plugins.seo.business.IFriendlyUrlDAO;
import fr.paris.lutece.plugins.seo.service.FriendlyUrlService;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.portal.service.plugin.PluginService;
import fr.paris.lutece.portal.service.spring.SpringContextService;
import java.util.List;

public final class FriendlyUrlHome {
    private static final String PLUGIN_NAME = "seo";
    private static Plugin _plugin = PluginService.getPlugin((String)"seo");
    private static IFriendlyUrlDAO _dao = (IFriendlyUrlDAO)SpringContextService.getBean((String)"seo.friendlyUrlDAO");

    private FriendlyUrlHome() {
    }

    public static FriendlyUrl create(FriendlyUrl friendlyUrl) {
        _dao.insert(friendlyUrl, _plugin);
        FriendlyUrlHome.notifyUpdate();
        return friendlyUrl;
    }

    public static FriendlyUrl update(FriendlyUrl friendlyUrl) {
        _dao.store(friendlyUrl, _plugin);
        FriendlyUrlHome.notifyUpdate();
        return friendlyUrl;
    }

    public static void remove(int nFriendlyUrlId) {
        _dao.delete(nFriendlyUrlId, _plugin);
        FriendlyUrlHome.notifyUpdate();
    }

    public static FriendlyUrl findByPrimaryKey(int nKey) {
        return _dao.load(nKey, _plugin);
    }

    public static List<FriendlyUrl> findAll() {
        return _dao.selectFriendlyUrlsList(_plugin);
    }

    private static void notifyUpdate() {
        FriendlyUrlService.instance().resetCache();
    }
}

