/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.business;

import fr.paris.lutece.plugins.seo.business.IUrlRewriterRuleDAO;
import fr.paris.lutece.plugins.seo.business.UrlRewriterRule;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.util.sql.DAOUtil;
import java.util.ArrayList;
import java.util.Collection;

public final class UrlRewriterRuleDAO
implements IUrlRewriterRuleDAO {
    private static final String SQL_QUERY_NEW_PK = "SELECT max( id_rule ) FROM seo_rule";
    private static final String SQL_QUERY_SELECT = "SELECT id_rule, rule_from, rule_to FROM seo_rule WHERE id_rule = ?";
    private static final String SQL_QUERY_INSERT = "INSERT INTO seo_rule ( id_rule, rule_from, rule_to ) VALUES ( ?, ?, ? ) ";
    private static final String SQL_QUERY_DELETE = "DELETE FROM seo_rule WHERE id_rule = ? ";
    private static final String SQL_QUERY_UPDATE = "UPDATE seo_rule SET id_rule = ?, rule_from = ?, rule_to = ? WHERE id_rule = ?";
    private static final String SQL_QUERY_SELECTALL = "SELECT id_rule, rule_from, rule_to FROM seo_rule";

    public int newPrimaryKey(Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_NEW_PK, plugin);
        daoUtil.executeQuery();
        if (!daoUtil.next()) {
            boolean bl = true;
        }
        int nKey = daoUtil.getInt(1) + 1;
        daoUtil.free();
        return nKey;
    }

    @Override
    public void insert(UrlRewriterRule urlRewriterRule, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_INSERT, plugin);
        urlRewriterRule.setIdRule(this.newPrimaryKey(plugin));
        daoUtil.setInt(1, urlRewriterRule.getIdRule());
        daoUtil.setString(2, urlRewriterRule.getRuleFrom());
        daoUtil.setString(3, urlRewriterRule.getRuleTo());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public UrlRewriterRule load(int nId, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECT, plugin);
        daoUtil.setInt(1, nId);
        daoUtil.executeQuery();
        UrlRewriterRule urlRewriterRule = null;
        if (daoUtil.next()) {
            urlRewriterRule = new UrlRewriterRule();
            urlRewriterRule.setIdRule(daoUtil.getInt(1));
            urlRewriterRule.setRuleFrom(daoUtil.getString(2));
            urlRewriterRule.setRuleTo(daoUtil.getString(3));
        }
        daoUtil.free();
        return urlRewriterRule;
    }

    @Override
    public void delete(int nUrlRewriterRuleId, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_DELETE, plugin);
        daoUtil.setInt(1, nUrlRewriterRuleId);
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public void store(UrlRewriterRule urlRewriterRule, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_UPDATE, plugin);
        daoUtil.setInt(1, urlRewriterRule.getIdRule());
        daoUtil.setString(2, urlRewriterRule.getRuleFrom());
        daoUtil.setString(3, urlRewriterRule.getRuleTo());
        daoUtil.setInt(4, urlRewriterRule.getIdRule());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public Collection<UrlRewriterRule> selectUrlRewriterRulesList(Plugin plugin) {
        ArrayList<UrlRewriterRule> urlRewriterRuleList = new ArrayList<UrlRewriterRule>();
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECTALL, plugin);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            UrlRewriterRule urlRewriterRule = new UrlRewriterRule();
            urlRewriterRule.setIdRule(daoUtil.getInt(1));
            urlRewriterRule.setRuleFrom(daoUtil.getString(2));
            urlRewriterRule.setRuleTo(daoUtil.getString(3));
            urlRewriterRuleList.add(urlRewriterRule);
        }
        daoUtil.free();
        return urlRewriterRuleList;
    }
}

