/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.service;

import fr.paris.lutece.portal.service.datastore.DatastoreService;
import fr.paris.lutece.portal.service.util.AppLogService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public final class CanonicalUrlService {
    private static final String HEAD = "<head>";
    private static final String COMMENT = "\n\t\t<!-- Canonical URL added by SEO plugin --> ";
    private static final String CANONICAL_TAG_BEGIN = "\n\t\t<link rel=\"canonical\" href=\"";
    private static final String CANONICAL_TAG_END = "\" />\n";
    private static CanonicalUrlService _singleton = new CanonicalUrlService();
    private static boolean _bCanonical;

    private CanonicalUrlService() {
        _bCanonical = DatastoreService.getDataValue((String)"seo.canonicalUrls.enabled", (String)"").equals("true");
    }

    public static synchronized CanonicalUrlService instance() {
        return _singleton;
    }

    public boolean isCanonicalUrlsEnabled() {
        return _bCanonical;
    }

    public void setCanonicalUrlsEnabled(boolean bEnabled) {
        _bCanonical = bEnabled;
    }

    public String addCanonicalUrl(String strContent, HttpServletRequest request, Map<String, String> mapFriendlyUrls, String strBaseUrl) {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(request.getRequestURI().substring(request.getContextPath().length() + 1));
        sbUrl.append("?").append(request.getQueryString());
        String strFriendlyUrl = mapFriendlyUrls.get(sbUrl.toString());
        if (strFriendlyUrl != null) {
            return this.insertCanonicalUrl(strContent, strBaseUrl + strFriendlyUrl);
        }
        return strContent;
    }

    private String insertCanonicalUrl(String strContent, String strUrl) {
        StringBuilder sb = new StringBuilder();
        int nPos = strContent.indexOf(HEAD);
        if (nPos < 0) {
            AppLogService.error((Object)("CanonicalUrl Service : no HEAD tag found in " + strUrl));
            return strContent;
        }
        sb.append(strContent.substring(0, nPos + HEAD.length()));
        sb.append(COMMENT);
        sb.append(CANONICAL_TAG_BEGIN);
        sb.append(strUrl);
        sb.append(CANONICAL_TAG_END);
        sb.append(strContent.substring(nPos + HEAD.length()));
        return sb.toString();
    }
}

