/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.service;

import fr.paris.lutece.plugins.seo.business.FriendlyUrl;
import fr.paris.lutece.plugins.seo.business.FriendlyUrlHome;
import fr.paris.lutece.plugins.seo.service.FriendlyUrlUtils;
import fr.paris.lutece.portal.service.cache.AbstractCacheableService;
import fr.paris.lutece.portal.service.datastore.DatastoreService;
import java.util.HashMap;
import java.util.Map;

public final class FriendlyUrlService
extends AbstractCacheableService {
    private static final String CACHE_KEY = "friendly_url_cache_key";
    private static final String CACHE_KEY_CANONICAL = "canonical_url_cache_key";
    private static final String NAME = "SEO Friendly Url Cache Service";
    private static FriendlyUrlService _singleton = new FriendlyUrlService();
    private static boolean _bReplaceUrl;

    private FriendlyUrlService() {
        this.initCache();
        _bReplaceUrl = DatastoreService.getDataValue((String)"seo.replaceUrl.enabled", (String)"").equals("true");
    }

    public String getName() {
        return NAME;
    }

    public static synchronized FriendlyUrlService instance() {
        return _singleton;
    }

    public Map<String, String> getFriendlyUrlMap() {
        HashMap<String, String> map = (HashMap<String, String>)this.getFromCache(CACHE_KEY);
        if (map == null) {
            map = new HashMap<String, String>();
            for (FriendlyUrl url : FriendlyUrlHome.findAll()) {
                map.put(FriendlyUrlUtils.cleanSlash(url.getTechnicalUrl()), FriendlyUrlUtils.cleanSlash(url.getFriendlyUrl()));
            }
            this.putInCache(CACHE_KEY, map);
        }
        return map;
    }

    Map<String, String> getCanonicalUrlMap() {
        HashMap<String, String> map = (HashMap<String, String>)this.getFromCache(CACHE_KEY_CANONICAL);
        if (map == null) {
            map = new HashMap<String, String>();
            for (FriendlyUrl url : FriendlyUrlHome.findAll()) {
                if (!url.isCanonical()) continue;
                map.put(FriendlyUrlUtils.cleanSlash(url.getTechnicalUrl()), FriendlyUrlUtils.cleanSlash(url.getFriendlyUrl()));
            }
            this.putInCache(CACHE_KEY_CANONICAL, map);
        }
        return map;
    }

    public boolean isUrlReplaceEnabled() {
        return _bReplaceUrl;
    }

    public void setUrlReplaceEnabled(boolean bEnabled) {
        _bReplaceUrl = bEnabled;
    }
}

