/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.service;

import fr.paris.lutece.portal.service.util.AppLogService;
import java.text.Normalizer;
import java.util.Map;

public final class FriendlyUrlUtils {
    private static final String ANCHOR = "<a ";
    private static final String HREF = "href=\"";
    private static final String END_URL = "\"";
    private static final String SLASH = "/";

    private FriendlyUrlUtils() {
    }

    public static String convertToFriendlyUrl(String strSource) {
        return Normalizer.normalize(strSource.toLowerCase(), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("[^\\p{Alnum}]+", "-");
    }

    public static String replaceByFriendlyUrl(String strSource, Map<String, String> map, String strBaseUrl) {
        StringBuilder sbOutput = new StringBuilder();
        String strCurrent = strSource;
        int nPos = strCurrent.indexOf(ANCHOR);
        while (nPos >= 0) {
            String strEnd = strCurrent.substring(nPos);
            int nPosBeginUrl = strEnd.indexOf(HREF) + HREF.length();
            sbOutput.append(strCurrent.substring(0, nPos + nPosBeginUrl));
            strCurrent = strEnd.substring(nPosBeginUrl);
            int nPosEndUrl = strCurrent.indexOf(END_URL);
            String strUrl = strCurrent.substring(0, nPosEndUrl);
            strUrl = FriendlyUrlUtils.removeBaseUrl(strUrl, strBaseUrl);
            String strFriendlyUrl = map.get(strUrl);
            sbOutput.append(strFriendlyUrl != null ? strFriendlyUrl : strUrl);
            if (strFriendlyUrl != null) {
                AppLogService.debug((Object)("Url : " + strUrl + " replaced by : " + strFriendlyUrl));
            }
            strCurrent = strCurrent.substring(nPosEndUrl);
            nPos = strCurrent.indexOf(ANCHOR);
        }
        sbOutput.append(strCurrent);
        return sbOutput.toString();
    }

    public static String cleanSlash(String strUrl) {
        return strUrl.startsWith(SLASH) ? strUrl.substring(1, strUrl.length()) : strUrl;
    }

    private static String removeBaseUrl(String strUrl, String strBaseUrl) {
        return strUrl.startsWith(strBaseUrl) ? strUrl.substring(strBaseUrl.length(), strUrl.length()) : strUrl;
    }
}

