/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.service;

import fr.paris.lutece.plugins.seo.web.SEOPanel;
import fr.paris.lutece.portal.service.spring.SpringContextService;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class PanelService {
    private static PanelService _singleton;
    private static List<SEOPanel> _listPanels;
    private static Comparator _comparator;

    private PanelService() {
    }

    public static synchronized PanelService instance() {
        if (_singleton == null) {
            _singleton = new PanelService();
            _listPanels = SpringContextService.getBeansOfType(SEOPanel.class);
            Collections.sort(_listPanels, _comparator);
        }
        return _singleton;
    }

    public List<SEOPanel> getPanels() {
        return _listPanels;
    }

    public int getIndex(String strPanelKey) {
        int nIndex = 1;
        for (SEOPanel panel : _listPanels) {
            if (panel.getPanelKey().equals(strPanelKey)) {
                return nIndex;
            }
            ++nIndex;
        }
        return -1;
    }

    static {
        _comparator = new PanelComparator();
    }

    private static class PanelComparator
    implements Comparator,
    Serializable {
        private PanelComparator() {
        }

        public int compare(Object o1, Object o2) {
            SEOPanel p1 = (SEOPanel)o1;
            SEOPanel p2 = (SEOPanel)o2;
            return p1.getPanelOrder() - p2.getPanelOrder();
        }
    }
}

