/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.service;

import fr.paris.lutece.plugins.seo.business.FriendlyUrl;
import fr.paris.lutece.plugins.seo.business.FriendlyUrlHome;
import fr.paris.lutece.plugins.seo.business.UrlRewriterRule;
import fr.paris.lutece.plugins.seo.business.UrlRewriterRuleHome;
import fr.paris.lutece.portal.service.datastore.DatastoreService;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.portal.service.template.AppTemplateService;
import fr.paris.lutece.portal.service.util.AppPathService;
import fr.paris.lutece.portal.service.util.AppPropertiesService;
import fr.paris.lutece.util.html.HtmlTemplate;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;

public final class RuleFileService {
    private static final String TEMPLATE_FILE = "/admin/plugins/seo/urlrewrite.xml";
    private static final String MARK_RULES_LIST = "rules_list";
    private static final String MARK_URL_LIST = "url_list";
    private static final String PROPERTY_FILE = "seo.configFilePath";
    private static final String PROPERTY_REWRITE_CONFIG_LOG = "seo.config.log";

    private RuleFileService() {
    }

    public static void generateFile() throws IOException {
        String strFilePath = AppPathService.getWebAppPath() + AppPropertiesService.getProperty((String)PROPERTY_FILE);
        File file = new File(strFilePath);
        FileUtils.writeStringToFile((File)file, (String)RuleFileService.generateFileContent());
    }

    private static String generateFileContent() {
        HashMap<String, Collection<Object>> model = new HashMap<String, Collection<Object>>();
        Collection<UrlRewriterRule> listRules = UrlRewriterRuleHome.findAll();
        List<FriendlyUrl> listUrl = FriendlyUrlHome.findAll();
        model.put(MARK_RULES_LIST, listRules);
        model.put(MARK_URL_LIST, listUrl);
        HtmlTemplate t = AppTemplateService.getTemplate((String)TEMPLATE_FILE, (Locale)Locale.getDefault(), model);
        String strResult = "OK";
        String strDate = DateFormat.getDateTimeInstance().format(new Date());
        Object[] args = new Object[]{strDate, listRules.size() + listUrl.size(), strResult};
        String strLogFormat = I18nService.getLocalizedString((String)PROPERTY_REWRITE_CONFIG_LOG, (Locale)Locale.getDefault());
        String strLog = MessageFormat.format(strLogFormat, args);
        DatastoreService.setDataValue((String)"seo.rewrite.config.lastUpdate", (String)strLog);
        DatastoreService.setDataValue((String)"seo.config.uptodate", (String)"true");
        return t.getHtml();
    }
}

