/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.service.generator;

import fr.paris.lutece.plugins.seo.business.FriendlyUrl;
import fr.paris.lutece.plugins.seo.business.FriendlyUrlHome;
import fr.paris.lutece.plugins.seo.service.generator.FriendlyUrlGenerator;
import fr.paris.lutece.plugins.seo.service.generator.GeneratorOptions;
import fr.paris.lutece.plugins.seo.service.generator.GeneratorSettings;
import fr.paris.lutece.portal.service.datastore.DatastoreService;
import fr.paris.lutece.portal.service.spring.SpringContextService;
import fr.paris.lutece.portal.service.util.AppLogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class FriendlyUrlGeneratorService {
    private static final String SUFFIX_HTML = ".html";
    private static final int NOT_FOUND = -1;
    private static List<FriendlyUrlGenerator> _listGenerators = new ArrayList<FriendlyUrlGenerator>();
    private static FriendlyUrlGeneratorService _singleton;

    private FriendlyUrlGeneratorService() {
    }

    public static synchronized FriendlyUrlGeneratorService instance() {
        if (_singleton == null) {
            _singleton = new FriendlyUrlGeneratorService();
            _listGenerators = SpringContextService.getBeansOfType(FriendlyUrlGenerator.class);
        }
        return _singleton;
    }

    public void generate(GeneratorOptions options) {
        List<FriendlyUrl> listExisting = FriendlyUrlHome.findAll();
        ArrayList<FriendlyUrl> listRules = new ArrayList<FriendlyUrl>();
        for (FriendlyUrlGenerator generator : _listGenerators) {
            generator.generate(listRules, options);
        }
        this.processRuleList(listRules, listExisting, options);
        DatastoreService.setDataValue((String)"seo.config.uptodate", (String)"false");
    }

    public List<GeneratorSettings> getGenerators() {
        ArrayList<GeneratorSettings> list = new ArrayList<GeneratorSettings>();
        for (FriendlyUrlGenerator generator : _listGenerators) {
            GeneratorSettings gs = new GeneratorSettings();
            String strKey = generator.getClass().getName();
            gs.setKey(strKey);
            gs.setName(generator.getName());
            String strPrefix = "seo.generator." + strKey;
            gs.setDefaultChangeFreq(DatastoreService.getDataValue((String)(strPrefix + ".changeFreq"), (String)""));
            gs.setDefaultPriority(DatastoreService.getDataValue((String)(strPrefix + ".priority"), (String)""));
            list.add(gs);
        }
        return list;
    }

    private void processRuleList(List<FriendlyUrl> listRules, Collection<FriendlyUrl> listExisting, GeneratorOptions options) {
        AppLogService.info((Object)"Processing Url rewriting Alias rules");
        AppLogService.info((Object)("* Option Force update existing rules : " + (options.isForceUpdate() ? "on" : "off")));
        AppLogService.info((Object)("* Option Add path : " + (options.isAddPath() ? "on" : "off")));
        AppLogService.info((Object)("* Option Html suffix : " + (options.isHtmlSuffix() ? "on" : "off")));
        for (FriendlyUrl url : listRules) {
            int nExistingRuleId;
            if (options.isHtmlSuffix()) {
                url.setFriendlyUrl(url.getFriendlyUrl() + SUFFIX_HTML);
            }
            if ((nExistingRuleId = this.getExistingRuleId(listExisting, url)) != -1) {
                if (options.isForceUpdate()) {
                    url.setId(nExistingRuleId);
                    FriendlyUrlHome.update(url);
                    AppLogService.info((Object)("Updated : " + url.getFriendlyUrl() + " -> " + url.getTechnicalUrl()));
                    continue;
                }
                AppLogService.info((Object)("Ignored : " + url.getFriendlyUrl() + " -> " + url.getTechnicalUrl()));
                continue;
            }
            FriendlyUrlHome.create(url);
            AppLogService.info((Object)("Created : " + url.getFriendlyUrl() + " -> " + url.getTechnicalUrl()));
        }
    }

    private int getExistingRuleId(Collection<FriendlyUrl> listExisting, FriendlyUrl url) {
        for (FriendlyUrl u : listExisting) {
            if (!u.getTechnicalUrl().equals(url.getTechnicalUrl())) continue;
            return u.getId();
        }
        return -1;
    }
}

