/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.service.generator;

import fr.paris.lutece.plugins.seo.business.FriendlyUrl;
import fr.paris.lutece.plugins.seo.service.FriendlyUrlUtils;
import fr.paris.lutece.plugins.seo.service.generator.FriendlyUrlGenerator;
import fr.paris.lutece.plugins.seo.service.generator.GeneratorOptions;
import fr.paris.lutece.plugins.seo.service.sitemap.SitemapUtils;
import fr.paris.lutece.portal.business.page.Page;
import fr.paris.lutece.portal.business.page.PageHome;
import fr.paris.lutece.portal.service.datastore.DatastoreService;
import fr.paris.lutece.portal.service.portal.PortalService;
import java.util.List;

public class PageFriendlyUrlGenerator
implements FriendlyUrlGenerator {
    private static final String GENERATOR_NAME = "Page Friendly URL Generator";
    private static final String TECHNICAL_URL = "/jsp/site/Portal.jsp?page_id=";
    private static final String SLASH = "/";
    private static final String EMPTY = "";
    private static final String DEFAULT_CHANGE_FREQ = SitemapUtils.CHANGE_FREQ_VALUES[3];
    private static final String DEFAULT_PRIORITY = SitemapUtils.PRIORITY_VALUES[3];
    private boolean _bCanonical;
    private boolean _bSitemap;
    private String _strChangeFreq;
    private String _strPriority;

    @Override
    public String getName() {
        return GENERATOR_NAME;
    }

    @Override
    public String generate(List<FriendlyUrl> list, GeneratorOptions options) {
        StringBuilder sbLog = new StringBuilder();
        String strKeyPrefix = "seo.generator." + this.getClass().getName();
        this._bCanonical = DatastoreService.getDataValue((String)(strKeyPrefix + ".canonical"), (String)"true").equals("true");
        this._bSitemap = DatastoreService.getDataValue((String)(strKeyPrefix + ".sitemap"), (String)"true").equals("true");
        this._strChangeFreq = DatastoreService.getDataValue((String)(strKeyPrefix + ".changeFreq"), (String)DEFAULT_CHANGE_FREQ);
        this._strPriority = DatastoreService.getDataValue((String)(strKeyPrefix + ".priority"), (String)DEFAULT_PRIORITY);
        String strPath = EMPTY;
        this.findPage(list, PortalService.getRootPageId(), strPath, sbLog, options);
        return sbLog.toString();
    }

    private void findPage(List<FriendlyUrl> list, int nPage, String strPath, StringBuilder sbLog, GeneratorOptions options) {
        Page page = PageHome.findByPrimaryKey((int)nPage);
        FriendlyUrl url = new FriendlyUrl();
        String strAlias = FriendlyUrlUtils.convertToFriendlyUrl(page.getName());
        String strChildPath = strPath.equals(EMPTY) ? SLASH : strPath + strAlias + SLASH;
        String strFriendlyUrl = options.isAddPath() ? strPath + strAlias : SLASH + strAlias;
        strFriendlyUrl = strPath.equals(EMPTY) ? SLASH + strAlias : strFriendlyUrl;
        url.setFriendlyUrl(strFriendlyUrl);
        url.setTechnicalUrl(TECHNICAL_URL + page.getId());
        url.setCanonical(this._bCanonical);
        url.setSitemap(this._bSitemap);
        url.setSitemapChangeFreq(this._strChangeFreq);
        url.setSitemapLastmod(SitemapUtils.formatDate(page.getDateUpdate()));
        url.setSitemapPriority(this._strPriority);
        list.add(url);
        for (Page childPage : PageHome.getChildPages((int)nPage)) {
            this.findPage(list, childPage.getId(), strChildPath, sbLog, options);
        }
    }
}

