/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.service.sitemap;

import fr.paris.lutece.plugins.seo.business.FriendlyUrl;
import fr.paris.lutece.plugins.seo.business.FriendlyUrlHome;
import fr.paris.lutece.plugins.seo.service.FriendlyUrlUtils;
import fr.paris.lutece.portal.service.datastore.DatastoreService;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.portal.service.template.AppTemplateService;
import fr.paris.lutece.portal.service.util.AppLogService;
import fr.paris.lutece.portal.service.util.AppPathService;
import fr.paris.lutece.util.html.HtmlTemplate;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;

public final class SitemapService {
    private static final String TEMPLATE_SITEMAP_XML = "/admin/plugins/seo/sitemap.xml";
    private static final String MARK_URLS_LIST = "urls_list";
    private static final String FILE_SITEMAP = "/sitemap.xml";
    private static final String PROPERTY_SITEMAP_LOG = "seo.sitemap.log";

    private SitemapService() {
    }

    public static String generateSitemap() {
        List<FriendlyUrl> list = SitemapService.getSitemapUrls();
        HashMap<String, List<FriendlyUrl>> model = new HashMap<String, List<FriendlyUrl>>();
        model.put(MARK_URLS_LIST, list);
        HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_SITEMAP_XML, (Locale)Locale.getDefault(), model);
        String strXmlSitemap = templateList.getHtml();
        String strSiteMapFilePath = AppPathService.getWebAppPath() + FILE_SITEMAP;
        File fileSiteMap = new File(strSiteMapFilePath);
        String strResult = "OK";
        try {
            FileUtils.writeStringToFile((File)fileSiteMap, (String)strXmlSitemap);
        }
        catch (IOException e) {
            AppLogService.error((Object)("Error writing Sitemap file : " + e.getMessage()), (Throwable)e.getCause());
            strResult = "Error : " + e.getMessage();
        }
        String strDate = DateFormat.getDateTimeInstance().format(new Date());
        Object[] args = new Object[]{strDate, list.size(), strResult};
        String strLogFormat = I18nService.getLocalizedString((String)PROPERTY_SITEMAP_LOG, (Locale)Locale.getDefault());
        String strLog = MessageFormat.format(strLogFormat, args);
        DatastoreService.setDataValue((String)"seo.sitemap.update.log", (String)strLog);
        return strLog;
    }

    private static List<FriendlyUrl> getSitemapUrls() {
        ArrayList<FriendlyUrl> list = new ArrayList<FriendlyUrl>();
        for (FriendlyUrl url : FriendlyUrlHome.findAll()) {
            if (!url.isSitemap()) continue;
            url.setFriendlyUrl(FriendlyUrlUtils.cleanSlash(url.getFriendlyUrl()));
            list.add(url);
        }
        return list;
    }
}

