/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.web;

import fr.paris.lutece.plugins.seo.business.FriendlyUrl;
import fr.paris.lutece.plugins.seo.business.FriendlyUrlHome;
import fr.paris.lutece.plugins.seo.service.CanonicalUrlService;
import fr.paris.lutece.plugins.seo.service.FriendlyUrlService;
import fr.paris.lutece.plugins.seo.service.RuleFileService;
import fr.paris.lutece.plugins.seo.service.generator.FriendlyUrlGeneratorService;
import fr.paris.lutece.plugins.seo.service.generator.GeneratorOptions;
import fr.paris.lutece.plugins.seo.service.sitemap.SitemapUtils;
import fr.paris.lutece.plugins.seo.web.SEOPanelJspBean;
import fr.paris.lutece.portal.service.datastore.DatastoreService;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.portal.service.message.AdminMessageService;
import fr.paris.lutece.portal.service.template.AppTemplateService;
import fr.paris.lutece.portal.service.util.AppLogService;
import fr.paris.lutece.portal.service.util.AppPropertiesService;
import fr.paris.lutece.portal.web.util.LocalizedPaginator;
import fr.paris.lutece.util.html.HtmlTemplate;
import fr.paris.lutece.util.html.Paginator;
import fr.paris.lutece.util.url.UrlItem;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class FriendlyUrlJspBean
extends SEOPanelJspBean {
    public static final String RIGHT_MANAGE_SEO = "SEO_MANAGEMENT";
    private static final String PARAMETER_URL_ID = "id_url";
    private static final String PARAMETER_FROM = "rule_from";
    private static final String PARAMETER_TO = "rule_to";
    private static final String PARAMETER_CANONICAL = "canonical";
    private static final String PARAMETER_SITEMAP = "sitemap";
    private static final String PARAMETER_CHANGE_FREQ = "change_freq";
    private static final String PARAMETER_PRIORITY = "priority";
    private static final String PARAMETER_GENERATOR_KEY = "generator_key";
    private static final String PARAMETER_URLREWRITERRULE_PAGE_INDEX = "friendly_url_page_index";
    private static final String PARAMETER_OPTION_FORCE_UPDATE = "option_force_update";
    private static final String PARAMETER_OPTION_ADD_PATH = "option_add_path";
    private static final String PARAMETER_OPTION_HTML_SUFFIX = "option_html_suffix";
    private static final String PARAMETER_TOGGLE = "toggle";
    private static final String TOGGLE_CANONICAL_URLS = "add_canonical_url";
    private static final String TOGGLE_REPLACE_URL = "replace_url_in_content";
    private static final String TOGGLE_FRIENDLY_URL_DAEMON = "friendly_url_daemon_enabled";
    private static final String VALUE_ON = "on";
    private static final String CHECKED = "checked";
    private static final String UNCHECKED = "";
    private static final String TEMPLATE_MANAGE_FRIENDLY_URL = "/admin/plugins/seo/manage_friendly_urls.html";
    private static final String TEMPLATE_CREATE_RULE = "/admin/plugins/seo/create_friendly_url.html";
    private static final String TEMPLATE_MODIFY_RULE = "/admin/plugins/seo/modify_friendly_url.html";
    private static final String TEMPLATE_GENERATE_ALIAS = "/admin/plugins/seo/generate_friendly_urls.html";
    private static final String TEMPLATE_CONTENT = "/admin/plugins/seo/panel/friendly_urls_panel.html";
    private static final String MARK_REWRITE_CONFIG_UPDATE = "rewrite_config_last_update";
    private static final String MARK_CONFIG_UPTODATE = "config_uptodate";
    private static final String MARK_URL_REPLACE = "url_replace";
    private static final String MARK_CANONICAL_URLS = "canonical_urls";
    private static final String MARK_FRIENDLY_URL_DAEMON = "friendly_url_daemon";
    private static final String PROPERTY_TITlE = "seo.panel.friendly_urls.title";
    private static final int PANEL_ORDER = 1;
    private static final String PANEL_KEY = "FRIENDLY_URL";
    private static final String PROPERTY_PAGE_TITLE_MANAGE_FRIENDLY_URLS = "seo.manage_friendly_urls.pageTitle";
    private static final String MARK_RULE = "url";
    private static final String MARK_FRIENDLY_URLS_LIST = "friendly_url_list";
    private static final String MARK_PAGINATOR = "paginator";
    private static final String MARK_NB_ITEMS_PER_PAGE = "nb_items_per_page";
    private static final String MARK_GENERATORS_LIST = "generators_list";
    private static final String MARK_ID_URL = "id_url";
    private static final String MARK_FRIENDLY_URL = "friendly_url";
    private static final String MARK_TECHNICAL_URL = "technical_url";
    private static final String MARK_CHECKED_CANONICAL = "checked_canonical";
    private static final String MARK_CHECKED_SITEMAP = "checked_sitemap";
    private static final String MARK_CHANGE_FREQ_LIST = "change_freq_list";
    private static final String MARK_SELECTED_CHANGE_FREQ = "selected_change_freq";
    private static final String MARK_PRIORITY_LIST = "priority_list";
    private static final String MARK_SELECTED_PRIORITY = "selected_priority";
    private static final String JSP_DO_DELETE_URL = "jsp/admin/plugins/seo/DoRemoveFriendlyUrl.jsp";
    private static final String JSP_URL_MANAGE_FRIENDLY_URLS = "jsp/admin/plugins/seo/ManageFriendlyUrls.jsp";
    private static final String JSP_MANAGE_FRIENDLY_URLS = "ManageFriendlyUrls.jsp";
    private static final String JSP_GENERATE_FRIENDLY_URLS = "GenerateAliasRules.jsp";
    private static final String PROPERTY_DEFAULT_LIST_URLREWRITERRULE_PER_PAGE = "seo.listFriendlyUrls.itemsPerPage";
    private static final String MESSAGE_CONFIRM_REMOVE_URL = "seo.message.confirmRemoveUrl";
    private static final String MESSAGE_GENERATION_FAILED = "seo.message.generationSuccessful";
    private int _nDefaultItemsPerPage;
    private String _strCurrentPageIndex;
    private int _nItemsPerPage;

    public String getManageFriendlyUrls(HttpServletRequest request) {
        this.setPageTitleProperty(PROPERTY_PAGE_TITLE_MANAGE_FRIENDLY_URLS);
        this._strCurrentPageIndex = Paginator.getPageIndex((HttpServletRequest)request, (String)"page_index", (String)this._strCurrentPageIndex);
        this._nDefaultItemsPerPage = AppPropertiesService.getPropertyInt((String)PROPERTY_DEFAULT_LIST_URLREWRITERRULE_PER_PAGE, (int)50);
        this._nItemsPerPage = Paginator.getItemsPerPage((HttpServletRequest)request, (String)"items_per_page", (int)this._nItemsPerPage, (int)this._nDefaultItemsPerPage);
        UrlItem url = new UrlItem(JSP_URL_MANAGE_FRIENDLY_URLS);
        String strUrl = url.getUrl();
        List<FriendlyUrl> listFrinedlyUrls = FriendlyUrlHome.findAll();
        LocalizedPaginator paginator = new LocalizedPaginator(listFrinedlyUrls, this._nItemsPerPage, strUrl, PARAMETER_URLREWRITERRULE_PAGE_INDEX, this._strCurrentPageIndex, this.getLocale());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MARK_NB_ITEMS_PER_PAGE, UNCHECKED + this._nItemsPerPage);
        model.put(MARK_PAGINATOR, paginator);
        model.put(MARK_FRIENDLY_URLS_LIST, paginator.getPageItems());
        HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_MANAGE_FRIENDLY_URL, (Locale)this.getLocale(), model);
        return this.getAdminPage(templateList.getHtml());
    }

    public String getCreateUrl(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MARK_CHANGE_FREQ_LIST, SitemapUtils.getChangeFrequencyValues());
        model.put(MARK_SELECTED_CHANGE_FREQ, SitemapUtils.CHANGE_FREQ_VALUES[3]);
        model.put(MARK_PRIORITY_LIST, SitemapUtils.getPriorityValues());
        model.put(MARK_SELECTED_PRIORITY, SitemapUtils.PRIORITY_VALUES[0]);
        HtmlTemplate template = AppTemplateService.getTemplate((String)TEMPLATE_CREATE_RULE, (Locale)this.getLocale(), model);
        return this.getAdminPage(template.getHtml());
    }

    public String doCreateUrl(HttpServletRequest request) {
        FriendlyUrl url = new FriendlyUrl();
        String strErrorUrl = this.getData(request, url);
        if (strErrorUrl != null) {
            return strErrorUrl;
        }
        FriendlyUrlHome.create(url);
        return JSP_MANAGE_FRIENDLY_URLS;
    }

    public String getModifyUrl(HttpServletRequest request) {
        String strRuleId = request.getParameter("id_url");
        int nRuleId = Integer.parseInt(strRuleId);
        FriendlyUrl url = FriendlyUrlHome.findByPrimaryKey(nRuleId);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id_url", url.getId());
        model.put(MARK_FRIENDLY_URL, url.getFriendlyUrl());
        model.put(MARK_TECHNICAL_URL, url.getTechnicalUrl());
        model.put(MARK_CHECKED_CANONICAL, url.isCanonical() ? CHECKED : UNCHECKED);
        model.put(MARK_CHECKED_SITEMAP, url.isSitemap() ? CHECKED : UNCHECKED);
        model.put(MARK_CHANGE_FREQ_LIST, SitemapUtils.getChangeFrequencyValues());
        model.put(MARK_SELECTED_CHANGE_FREQ, url.getSitemapChangeFreq());
        model.put(MARK_PRIORITY_LIST, SitemapUtils.getPriorityValues());
        model.put(MARK_SELECTED_PRIORITY, url.getSitemapPriority());
        model.put(MARK_RULE, url);
        HtmlTemplate template = AppTemplateService.getTemplate((String)TEMPLATE_MODIFY_RULE, (Locale)this.getLocale(), model);
        return this.getAdminPage(template.getHtml());
    }

    public String doModifyUrl(HttpServletRequest request) {
        String strRuleId = request.getParameter("id_url");
        int nRuleId = Integer.parseInt(strRuleId);
        FriendlyUrl url = FriendlyUrlHome.findByPrimaryKey(nRuleId);
        String strErrorUrl = this.getData(request, url);
        if (strErrorUrl != null) {
            return strErrorUrl;
        }
        FriendlyUrlHome.update(url);
        return JSP_MANAGE_FRIENDLY_URLS;
    }

    private String getData(HttpServletRequest request, FriendlyUrl url) {
        String strFrom = request.getParameter(PARAMETER_FROM);
        String strTo = request.getParameter(PARAMETER_TO);
        String strCanonical = request.getParameter(PARAMETER_CANONICAL);
        String strSitemap = request.getParameter(PARAMETER_SITEMAP);
        String strChangeFreq = request.getParameter(PARAMETER_CHANGE_FREQ);
        String strPriority = request.getParameter(PARAMETER_PRIORITY);
        if (strFrom == null || strFrom.equals(UNCHECKED) || strTo == null || strTo.equals(UNCHECKED)) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)"portal.util.message.mandatoryFields", (int)5);
        }
        url.setFriendlyUrl(strFrom);
        url.setTechnicalUrl(strTo.replaceAll("&", "&amp;"));
        url.setCanonical(strCanonical != null);
        url.setSitemap(strSitemap != null);
        url.setSitemapChangeFreq(strChangeFreq);
        url.setSitemapPriority(strPriority);
        return null;
    }

    public String deleteUrl(HttpServletRequest request) {
        String strUrlId = request.getParameter("id_url");
        UrlItem url = new UrlItem(JSP_DO_DELETE_URL);
        url.addParameter("id_url", strUrlId);
        return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_CONFIRM_REMOVE_URL, (String)url.getUrl(), (int)4);
    }

    public String doDeleteUrl(HttpServletRequest request) {
        String strUrlId = request.getParameter("id_url");
        int nUrlId = Integer.parseInt(strUrlId);
        FriendlyUrlHome.remove(nUrlId);
        return JSP_MANAGE_FRIENDLY_URLS;
    }

    public String doGenerate(HttpServletRequest request) {
        try {
            RuleFileService.generateFile();
        }
        catch (IOException e) {
            AppLogService.error((Object)("Error generating url file : " + e.getMessage()), (Throwable)e);
            String strMessage = MESSAGE_GENERATION_FAILED;
            int nMessageType = 5;
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)strMessage, (String)this.getHomeUrl(request), (int)nMessageType);
        }
        return this.getHomeUrl(request);
    }

    public String getGenerateAliasRules(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MARK_CHANGE_FREQ_LIST, SitemapUtils.getChangeFrequencyValues());
        model.put(MARK_PRIORITY_LIST, SitemapUtils.getPriorityValues());
        model.put(MARK_GENERATORS_LIST, FriendlyUrlGeneratorService.instance().getGenerators());
        HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_GENERATE_ALIAS, (Locale)this.getLocale(), model);
        return this.getAdminPage(templateList.getHtml());
    }

    public String doGenerateAliasRules(HttpServletRequest request) {
        GeneratorOptions options = new GeneratorOptions();
        options.setForceUpdate(this.getOption(request, PARAMETER_OPTION_FORCE_UPDATE));
        options.setAddPath(this.getOption(request, PARAMETER_OPTION_ADD_PATH));
        options.setHtmlSuffix(this.getOption(request, PARAMETER_OPTION_HTML_SUFFIX));
        DatastoreService.setDataValue((String)"seo.generator.option.addPath", (String)(options.isAddPath() ? "true" : "false"));
        DatastoreService.setDataValue((String)"seo.generator.option.addHtmlSuffix", (String)(options.isHtmlSuffix() ? "true" : "false"));
        FriendlyUrlGeneratorService.instance().generate(options);
        return JSP_MANAGE_FRIENDLY_URLS;
    }

    private boolean getOption(HttpServletRequest request, String strParameter) {
        String strValue = request.getParameter(strParameter);
        return strValue != null && strValue.equals(VALUE_ON);
    }

    public String doToggle(HttpServletRequest request) {
        String strToggle = request.getParameter(PARAMETER_TOGGLE);
        if (strToggle.equals(TOGGLE_REPLACE_URL)) {
            this.toggleReplaceUrl();
        } else if (strToggle.equals(TOGGLE_CANONICAL_URLS)) {
            this.toggleCanonicalUrls();
        } else if (strToggle.equals(TOGGLE_FRIENDLY_URL_DAEMON)) {
            this.toggleFriendlyUrlDaemon();
        }
        return this.getHomeUrl(request);
    }

    private void toggleReplaceUrl() {
        String strStatus = DatastoreService.getDataValue((String)"seo.replaceUrl.enabled", (String)"false");
        if (strStatus.equals("true")) {
            DatastoreService.setDataValue((String)"seo.replaceUrl.enabled", (String)"false");
            FriendlyUrlService.instance().setUrlReplaceEnabled(false);
            AppLogService.info((Object)"SEO : URL replace service disabled");
        } else {
            DatastoreService.setDataValue((String)"seo.replaceUrl.enabled", (String)"true");
            FriendlyUrlService.instance().setUrlReplaceEnabled(true);
            AppLogService.info((Object)"SEO : URL replace service enabled");
        }
    }

    private void toggleCanonicalUrls() {
        String strStatus = DatastoreService.getDataValue((String)"seo.canonicalUrls.enabled", (String)"false");
        if (strStatus.equals("true")) {
            DatastoreService.setDataValue((String)"seo.canonicalUrls.enabled", (String)"false");
            CanonicalUrlService.instance().setCanonicalUrlsEnabled(false);
            AppLogService.info((Object)"SEO : Canonical URLs disabled");
        } else {
            DatastoreService.setDataValue((String)"seo.canonicalUrls.enabled", (String)"true");
            CanonicalUrlService.instance().setCanonicalUrlsEnabled(true);
            AppLogService.info((Object)"SEO : Canonical URLs enabled");
        }
    }

    private void toggleFriendlyUrlDaemon() {
        String strStatus = DatastoreService.getDataValue((String)"seo.generator.daemon.enabled", (String)"false");
        if (strStatus.equals("true")) {
            DatastoreService.setDataValue((String)"seo.generator.daemon.enabled", (String)"false");
            AppLogService.info((Object)"SEO : Friendly URL Daemon disabled");
        } else {
            DatastoreService.setDataValue((String)"seo.generator.daemon.enabled", (String)"true");
            AppLogService.info((Object)"SEO : Friendly URL Daemon enabled");
        }
    }

    public String doUpdateGeneratorSettings(HttpServletRequest request) {
        String strKey = request.getParameter(PARAMETER_GENERATOR_KEY);
        String strChangeFreq = request.getParameter(PARAMETER_CHANGE_FREQ);
        String strPriority = request.getParameter(PARAMETER_PRIORITY);
        String strPrefix = "seo.generator." + strKey;
        DatastoreService.setDataValue((String)(strPrefix + ".changeFreq"), (String)strChangeFreq);
        DatastoreService.setDataValue((String)(strPrefix + ".priority"), (String)strPriority);
        return JSP_GENERATE_FRIENDLY_URLS;
    }

    @Override
    public String getPanelTitle() {
        return I18nService.getLocalizedString((String)PROPERTY_TITlE, (Locale)this.getPanelLocale());
    }

    @Override
    public String getPanelContent() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MARK_REWRITE_CONFIG_UPDATE, DatastoreService.getDataValue((String)"seo.rewrite.config.lastUpdate", (String)UNCHECKED));
        model.put(MARK_CONFIG_UPTODATE, DatastoreService.getDataValue((String)"seo.config.uptodate", (String)UNCHECKED).equals("true"));
        model.put(MARK_URL_REPLACE, DatastoreService.getDataValue((String)"seo.replaceUrl.enabled", (String)UNCHECKED).equals("true"));
        model.put(MARK_CANONICAL_URLS, DatastoreService.getDataValue((String)"seo.canonicalUrls.enabled", (String)UNCHECKED).equals("true"));
        model.put(MARK_FRIENDLY_URL_DAEMON, DatastoreService.getDataValue((String)"seo.generator.daemon.enabled", (String)UNCHECKED).equals("true"));
        HtmlTemplate template = AppTemplateService.getTemplate((String)TEMPLATE_CONTENT, (Locale)this.getPanelLocale(), model);
        return template.getHtml();
    }

    @Override
    public int getPanelOrder() {
        return 1;
    }

    @Override
    public String getPanelKey() {
        return PANEL_KEY;
    }
}

