/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.web;

import fr.paris.lutece.plugins.seo.service.sitemap.SitemapService;
import fr.paris.lutece.plugins.seo.web.SEOPanel;
import fr.paris.lutece.plugins.seo.web.SEOPanelJspBean;
import fr.paris.lutece.portal.service.datastore.DatastoreService;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.portal.service.template.AppTemplateService;
import fr.paris.lutece.util.html.HtmlTemplate;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class SitemapJspBean
extends SEOPanelJspBean
implements SEOPanel {
    public static final String RIGHT_MANAGE_SEO = "SEO_MANAGEMENT";
    private static final String TEMPLATE_CONTENT = "/admin/plugins/seo/panel/sitemap_panel.html";
    private static final String PROPERTY_TITlE = "seo.panel.sitemap.title";
    private static final String MARK_LAST_GENERATION = "sitemapLastGeneration";
    private static final String MARK_DAEMON_ENABLED = "daemon_enabled";
    private static final int PANEL_ORDER = 2;
    private static final String PANEL_KEY = "SITE_MAP";

    public String doGenerateSitemap(HttpServletRequest request) {
        SitemapService.generateSitemap();
        return this.getHomeUrl(request);
    }

    public String doSitemapDaemonToggle(HttpServletRequest request) {
        String strDeamon = DatastoreService.getDataValue((String)"seo.sitmap.daemon.enabled", (String)"false");
        if (strDeamon.equals("true")) {
            DatastoreService.setDataValue((String)"seo.sitmap.daemon.enabled", (String)"false");
        } else {
            DatastoreService.setDataValue((String)"seo.sitmap.daemon.enabled", (String)"true");
        }
        return this.getHomeUrl(request);
    }

    @Override
    public String getPanelTitle() {
        return I18nService.getLocalizedString((String)PROPERTY_TITlE, (Locale)this.getPanelLocale());
    }

    @Override
    public String getPanelContent() {
        String strDeamon = DatastoreService.getDataValue((String)"seo.sitmap.daemon.enabled", (String)"false");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MARK_LAST_GENERATION, DatastoreService.getDataValue((String)"seo.sitemap.update.log", (String)""));
        model.put(MARK_DAEMON_ENABLED, strDeamon.equals("true"));
        HtmlTemplate template = AppTemplateService.getTemplate((String)TEMPLATE_CONTENT, (Locale)this.getPanelLocale(), model);
        return template.getHtml();
    }

    @Override
    public int getPanelOrder() {
        return 2;
    }

    @Override
    public String getPanelKey() {
        return PANEL_KEY;
    }
}

