/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.seo.web;

import fr.paris.lutece.plugins.seo.business.UrlRewriterRule;
import fr.paris.lutece.plugins.seo.business.UrlRewriterRuleHome;
import fr.paris.lutece.plugins.seo.service.RuleFileService;
import fr.paris.lutece.plugins.seo.web.SEOPanel;
import fr.paris.lutece.plugins.seo.web.SEOPanelJspBean;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.portal.service.message.AdminMessageService;
import fr.paris.lutece.portal.service.template.AppTemplateService;
import fr.paris.lutece.portal.service.util.AppLogService;
import fr.paris.lutece.portal.service.util.AppPropertiesService;
import fr.paris.lutece.portal.web.util.LocalizedPaginator;
import fr.paris.lutece.util.html.HtmlTemplate;
import fr.paris.lutece.util.html.Paginator;
import fr.paris.lutece.util.url.UrlItem;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class UrlRewriterAdminJspBean
extends SEOPanelJspBean
implements SEOPanel {
    public static final String RIGHT_MANAGE_URLREWRITERADMIN = "SEO_MANAGEMENT";
    private static final String PARAMETER_RULE_ID = "id_rule";
    private static final String PARAMETER_FROM = "rule_from";
    private static final String PARAMETER_TO = "rule_to";
    private static final String PARAMETER_URLREWRITERRULE_PAGE_INDEX = "urlrewriterrule_page_index";
    private static final String TEMPLATE_MANAGE_URLREWRITERRULES = "/admin/plugins/seo/manage_urlrewriterrules.html";
    private static final String TEMPLATE_CREATE_RULE = "/admin/plugins/seo/create_urlrewriterrule.html";
    private static final String TEMPLATE_MODIFY_RULE = "/admin/plugins/seo/modify_urlrewriterrule.html";
    private static final String TEMPLATE_CONTENT = "/admin/plugins/seo/panel/url_rewriter_rules_panel.html";
    private static final String PROPERTY_TITlE = "seo.panel.url_rewriter_rules.title";
    private static final int PANEL_ORDER = 3;
    private static final String PANEL_KEY = "URL_REWRITER";
    private static final String PROPERTY_PAGE_TITLE_MANAGE_URLREWRITERRULES = "seo.manage_urlrewriterrules.pageTitle";
    private static final String MARK_RULE = "rule";
    private static final String MARK_URLREWRITERRULE_LIST = "urlrewriterrule_list";
    private static final String MARK_PAGINATOR = "paginator";
    private static final String MARK_NB_ITEMS_PER_PAGE = "nb_items_per_page";
    private static final String JSP_DO_DELETE_RULE = "jsp/admin/plugins/seo/DoRemoveUrlRewriterRule.jsp";
    private static final String JSP_MANAGE_URLREWRITERRULES = "jsp/admin/plugins/seo/ManageUrlRewriterRules.jsp";
    private static final String JSP_MANAGE_URL_REWRITER_RULES = "ManageUrlRewriterRules.jsp";
    private static final String PROPERTY_DEFAULT_LIST_URLREWRITERRULE_PER_PAGE = "seo.listUrlRewriterRules.itemsPerPage";
    private static final String MESSAGE_CONFIRM_REMOVE_RULE = "seo.message.confirmRemoveRule";
    private static final String MESSAGE_GENERATION_SUCCESSFUL = "seo.message.generationSuccessful";
    private static final String MESSAGE_GENERATION_FAILED = "seo.message.generationSuccessful";
    private int _nDefaultItemsPerPage;
    private String _strCurrentPageIndex;
    private int _nItemsPerPage;

    public String getManageUrlRewriterRules(HttpServletRequest request) {
        this.setPageTitleProperty(PROPERTY_PAGE_TITLE_MANAGE_URLREWRITERRULES);
        this._strCurrentPageIndex = Paginator.getPageIndex((HttpServletRequest)request, (String)"page_index", (String)this._strCurrentPageIndex);
        this._nDefaultItemsPerPage = AppPropertiesService.getPropertyInt((String)PROPERTY_DEFAULT_LIST_URLREWRITERRULE_PER_PAGE, (int)50);
        this._nItemsPerPage = Paginator.getItemsPerPage((HttpServletRequest)request, (String)"items_per_page", (int)this._nItemsPerPage, (int)this._nDefaultItemsPerPage);
        UrlItem url = new UrlItem(JSP_MANAGE_URLREWRITERRULES);
        String strUrl = url.getUrl();
        Collection<UrlRewriterRule> listRules = UrlRewriterRuleHome.findAll();
        LocalizedPaginator paginator = new LocalizedPaginator((List)listRules, this._nItemsPerPage, strUrl, PARAMETER_URLREWRITERRULE_PAGE_INDEX, this._strCurrentPageIndex, this.getLocale());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MARK_NB_ITEMS_PER_PAGE, "" + this._nItemsPerPage);
        model.put(MARK_PAGINATOR, paginator);
        model.put(MARK_URLREWRITERRULE_LIST, paginator.getPageItems());
        HtmlTemplate templateList = AppTemplateService.getTemplate((String)TEMPLATE_MANAGE_URLREWRITERRULES, (Locale)this.getLocale(), model);
        return this.getAdminPage(templateList.getHtml());
    }

    public String getCreateRule(HttpServletRequest request) {
        HashMap model = new HashMap();
        HtmlTemplate template = AppTemplateService.getTemplate((String)TEMPLATE_CREATE_RULE, (Locale)this.getLocale(), model);
        return this.getAdminPage(template.getHtml());
    }

    public String doCreateRule(HttpServletRequest request) {
        UrlRewriterRule rule = new UrlRewriterRule();
        String strErrorUrl = this.getData(request, rule);
        if (strErrorUrl != null) {
            return strErrorUrl;
        }
        UrlRewriterRuleHome.create(rule);
        return JSP_MANAGE_URL_REWRITER_RULES;
    }

    public String getModifyRule(HttpServletRequest request) {
        String strRuleId = request.getParameter(PARAMETER_RULE_ID);
        int nRuleId = Integer.parseInt(strRuleId);
        UrlRewriterRule rule = UrlRewriterRuleHome.findByPrimaryKey(nRuleId);
        HashMap<String, UrlRewriterRule> model = new HashMap<String, UrlRewriterRule>();
        model.put(MARK_RULE, rule);
        HtmlTemplate template = AppTemplateService.getTemplate((String)TEMPLATE_MODIFY_RULE, (Locale)this.getLocale(), model);
        return this.getAdminPage(template.getHtml());
    }

    public String doModifyRule(HttpServletRequest request) {
        String strRuleId = request.getParameter(PARAMETER_RULE_ID);
        int nRuleId = Integer.parseInt(strRuleId);
        UrlRewriterRule rule = UrlRewriterRuleHome.findByPrimaryKey(nRuleId);
        String strErrorUrl = this.getData(request, rule);
        if (strErrorUrl != null) {
            return strErrorUrl;
        }
        UrlRewriterRuleHome.update(rule);
        return JSP_MANAGE_URL_REWRITER_RULES;
    }

    private String getData(HttpServletRequest request, UrlRewriterRule rule) {
        String strFrom = request.getParameter(PARAMETER_FROM);
        String strTo = request.getParameter(PARAMETER_TO);
        if (strFrom == null || strFrom.equals("") || strTo == null || strTo.equals("")) {
            return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)"portal.util.message.mandatoryFields", (int)5);
        }
        rule.setRuleFrom(strFrom);
        rule.setRuleTo(strTo.replaceAll("&", "&amp;"));
        return null;
    }

    public String deleteRule(HttpServletRequest request) {
        String strRuleId = request.getParameter(PARAMETER_RULE_ID);
        UrlItem url = new UrlItem(JSP_DO_DELETE_RULE);
        url.addParameter(PARAMETER_RULE_ID, strRuleId);
        return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_CONFIRM_REMOVE_RULE, (String)url.getUrl(), (int)4);
    }

    public String doDeleteRule(HttpServletRequest request) {
        String strRuleId = request.getParameter(PARAMETER_RULE_ID);
        int nRuleId = Integer.parseInt(strRuleId);
        UrlRewriterRuleHome.remove(nRuleId);
        return JSP_MANAGE_URL_REWRITER_RULES;
    }

    public String doGenerate(HttpServletRequest request) {
        String strMessage = "seo.message.generationSuccessful";
        int nMessageType = 4;
        try {
            RuleFileService.generateFile();
        }
        catch (IOException e) {
            AppLogService.error((Object)("Error generating rule file : " + e.getMessage()), (Throwable)e);
            strMessage = "seo.message.generationSuccessful";
            nMessageType = 5;
        }
        return AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)strMessage, (String)this.getHomeUrl(request), (int)nMessageType);
    }

    @Override
    public String getPanelTitle() {
        return I18nService.getLocalizedString((String)PROPERTY_TITlE, (Locale)this.getPanelLocale());
    }

    @Override
    public String getPanelContent() {
        HtmlTemplate template = AppTemplateService.getTemplate((String)TEMPLATE_CONTENT, (Locale)this.getPanelLocale());
        return template.getHtml();
    }

    @Override
    public int getPanelOrder() {
        return 3;
    }

    @Override
    public String getPanelKey() {
        return PANEL_KEY;
    }
}

