/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.business;

import fr.paris.lutece.plugins.transparency.business.Appointment;
import fr.paris.lutece.plugins.transparency.business.AppointmentFilter;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficialHome;
import fr.paris.lutece.plugins.transparency.business.IAppointmentDAO;
import fr.paris.lutece.plugins.transparency.business.LobbyHome;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.portal.service.plugin.PluginService;
import fr.paris.lutece.portal.service.spring.SpringContextService;
import fr.paris.lutece.util.ReferenceList;
import java.util.List;

public final class AppointmentHome {
    private static IAppointmentDAO _dao = (IAppointmentDAO)SpringContextService.getBean((String)"transparency.appointmentDAO");
    private static Plugin _plugin = PluginService.getPlugin((String)"transparency");

    private AppointmentHome() {
    }

    public static Appointment create(Appointment appointment) {
        _dao.insert(appointment, _plugin);
        return appointment;
    }

    public static Appointment update(Appointment appointment) {
        _dao.store(appointment, _plugin);
        return appointment;
    }

    public static void remove(int nKey) {
        _dao.delete(nKey, _plugin);
    }

    public static Appointment findByPrimaryKey(int nKey) {
        return _dao.load(nKey, _plugin);
    }

    public static Appointment getFullAppointmentById(int nId) {
        Appointment appointment = _dao.load(nId, _plugin);
        if (appointment != null) {
            appointment.setLobbyList(LobbyHome.getLobbiesListByAppointment(appointment.getId()));
            appointment.setElectedOfficialList(ElectedOfficialHome.getElectedOfficialsListByAppointment(appointment.getId()));
        }
        return appointment;
    }

    public static List<Appointment> getAppointmentsList() {
        return _dao.selectAppointmentsList(_plugin);
    }

    public static List<Appointment> getFullAppointmentsList() {
        return AppointmentHome.getFullAppointmentsList(null);
    }

    public static List<Appointment> getFullAppointmentsList(AppointmentFilter filter) {
        List<Appointment> list = _dao.selectAppointmentsList(filter, _plugin);
        for (Appointment appointment : list) {
            appointment.setElectedOfficialList(ElectedOfficialHome.getElectedOfficialsListByAppointment(appointment.getId()));
            appointment.setLobbyList(LobbyHome.getLobbiesListByAppointment(appointment.getId()));
        }
        return list;
    }

    public static List<Integer> getIdAppointmentsList() {
        return _dao.selectIdAppointmentsList(_plugin);
    }

    public static ReferenceList getAppointmentsReferenceList() {
        return _dao.selectAppointmentsReferenceList(_plugin);
    }
}

