/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.business;

import fr.paris.lutece.plugins.transparency.business.ElectedOfficial;
import fr.paris.lutece.plugins.transparency.business.IElectedOfficialDAO;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.util.ReferenceList;
import fr.paris.lutece.util.sql.DAOUtil;
import java.util.ArrayList;
import java.util.List;

public final class ElectedOfficialDAO
implements IElectedOfficialDAO {
    private static final String SQL_QUERY_SELECT = "SELECT core_role.role, role_description FROM core_role ";
    private static final String SQL_QUERY_SELECTALL_ID = "SELECT core_role.role FROM core_role";
    private static final String SQL_WHERECLAUSE_BY_APPOINTMENT = " LEFT JOIN transparency_elected_official_appointment ON transparency_elected_official_appointment.role_key = core_role.role WHERE transparency_elected_official_appointment.id_appointment  = ? ";
    private static final String SQL_WHERECLAUSE_BY_DELEGATION = " LEFT JOIN mylutece_database_user_role ON mylutece_database_user_role.role_key = core_role.role LEFT JOIN mylutece_database_user ON mylutece_database_user_role.mylutece_database_user_id = mylutece_database_user.mylutece_database_user_id WHERE login = ? ";
    private static final String SQL_WHERECLAUSE_BY_ID = " WHERE role = ? ";
    private static final String SQL_ORDER_BY = " ORDER BY role_description ";

    @Override
    public ElectedOfficial load(String strKey, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil("SELECT core_role.role, role_description FROM core_role  WHERE role = ? ", plugin);
        daoUtil.setString(1, strKey);
        daoUtil.executeQuery();
        ElectedOfficial electedOfficial = null;
        if (daoUtil.next()) {
            electedOfficial = new ElectedOfficial();
            int nIndex = 1;
            electedOfficial.setId(daoUtil.getString(nIndex++));
            electedOfficial.setLastName(daoUtil.getString(nIndex++));
        }
        daoUtil.free();
        return electedOfficial;
    }

    @Override
    public List<ElectedOfficial> selectElectedOfficialsList(Plugin plugin) {
        ArrayList<ElectedOfficial> electedOfficialList = new ArrayList<ElectedOfficial>();
        DAOUtil daoUtil = new DAOUtil("SELECT core_role.role, role_description FROM core_role  ORDER BY role_description ", plugin);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            ElectedOfficial electedOfficial = new ElectedOfficial();
            int nIndex = 1;
            electedOfficial.setId(daoUtil.getString(nIndex++));
            electedOfficial.setLastName(daoUtil.getString(nIndex++));
            electedOfficialList.add(electedOfficial);
        }
        daoUtil.free();
        return electedOfficialList;
    }

    @Override
    public List<ElectedOfficial> selectElectedOfficialsListByAppointment(int idAppointment, Plugin plugin) {
        ArrayList<ElectedOfficial> electedOfficialList = new ArrayList<ElectedOfficial>();
        DAOUtil daoUtil = new DAOUtil("SELECT core_role.role, role_description FROM core_role  LEFT JOIN transparency_elected_official_appointment ON transparency_elected_official_appointment.role_key = core_role.role WHERE transparency_elected_official_appointment.id_appointment  = ?  ORDER BY role_description ", plugin);
        daoUtil.setInt(1, idAppointment);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            ElectedOfficial electedOfficial = new ElectedOfficial();
            int nIndex = 1;
            electedOfficial.setId(daoUtil.getString(nIndex++));
            electedOfficial.setLastName(daoUtil.getString(nIndex++));
            electedOfficialList.add(electedOfficial);
        }
        daoUtil.free();
        return electedOfficialList;
    }

    @Override
    public List<ElectedOfficial> selectElectedOfficialsListByDelegation(int idAdminUser, Plugin plugin) {
        ArrayList<ElectedOfficial> electedOfficialList = new ArrayList<ElectedOfficial>();
        DAOUtil daoUtil = new DAOUtil("SELECT core_role.role, role_description FROM core_role  LEFT JOIN mylutece_database_user_role ON mylutece_database_user_role.role_key = core_role.role LEFT JOIN mylutece_database_user ON mylutece_database_user_role.mylutece_database_user_id = mylutece_database_user.mylutece_database_user_id WHERE login = ?  ORDER BY role_description ", plugin);
        daoUtil.setInt(1, idAdminUser);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            ElectedOfficial electedOfficial = new ElectedOfficial();
            int nIndex = 1;
            electedOfficial.setId(daoUtil.getString(nIndex++));
            electedOfficial.setLastName(daoUtil.getString(nIndex++));
            electedOfficialList.add(electedOfficial);
        }
        daoUtil.free();
        return electedOfficialList;
    }

    @Override
    public List<String> selectIdElectedOfficialsList(Plugin plugin) {
        ArrayList<String> electedOfficialList = new ArrayList<String>();
        DAOUtil daoUtil = new DAOUtil("SELECT core_role.role FROM core_role ORDER BY role_description ", plugin);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            electedOfficialList.add(daoUtil.getString(1));
        }
        daoUtil.free();
        return electedOfficialList;
    }

    @Override
    public ReferenceList selectElectedOfficialsReferenceList(Plugin plugin) {
        ReferenceList electedOfficialList = new ReferenceList();
        DAOUtil daoUtil = new DAOUtil("SELECT core_role.role, role_description FROM core_role  ORDER BY role_description ", plugin);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            electedOfficialList.addItem(daoUtil.getString(1), daoUtil.getString(2));
        }
        daoUtil.free();
        return electedOfficialList;
    }

    @Override
    public ReferenceList selectElectedOfficialsReferenceListByDelegation(String idUser, Plugin plugin) {
        ReferenceList electedOfficialList = new ReferenceList();
        DAOUtil daoUtil = new DAOUtil("SELECT core_role.role, role_description FROM core_role  LEFT JOIN mylutece_database_user_role ON mylutece_database_user_role.role_key = core_role.role LEFT JOIN mylutece_database_user ON mylutece_database_user_role.mylutece_database_user_id = mylutece_database_user.mylutece_database_user_id WHERE login = ?  ORDER BY role_description ", plugin);
        daoUtil.setString(1, idUser);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            electedOfficialList.addItem(daoUtil.getString(1), daoUtil.getString(2));
        }
        daoUtil.free();
        return electedOfficialList;
    }
}

