/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.business;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.util.Iterator;
import javax.validation.constraints.Size;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.URL;

public class Lobby
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int _nId;
    @NotEmpty(message="#i18n{transparency.validation.lobby.Name.notEmpty}")
    @Size(max=255, message="#i18n{transparency.validation.lobby.Name.size}")
    private String _strName;
    private String _strNationalId;
    @Size(max=50, message="#i18n{transparency.validation.lobby.NationalIdType.size}")
    private String _strNationalIdType;
    @URL(message="#i18n{portal.validation.message.url}")
    @Size(max=255, message="#i18n{transparency.validation.lobby.Url.size}")
    private String _strUrl;
    private String _strJsonData;
    private Date _dateVersionDate;

    public int getId() {
        return this._nId;
    }

    public void setId(int nId) {
        this._nId = nId;
    }

    public String getName() {
        return this._strName;
    }

    public void setName(String strName) {
        this._strName = strName;
    }

    public String getNationalId() {
        return this._strNationalId;
    }

    public void setNationalId(String strNationalId) {
        this._strNationalId = strNationalId;
    }

    public String getNationalIdType() {
        return this._strNationalIdType;
    }

    public void setNationalIdType(String strNationalIdType) {
        this._strNationalIdType = strNationalIdType;
    }

    @JsonIgnore
    public String getUrl() {
        return this._strUrl;
    }

    public void setUrl(String strUrl) {
        this._strUrl = strUrl;
    }

    @JsonIgnore
    public String getJsonData() {
        return this._strJsonData;
    }

    public void setJsonData(String strJsonData) {
        this._strJsonData = strJsonData;
    }

    @JsonIgnore
    public Date getVersionDate() {
        return this._dateVersionDate;
    }

    public void setVersionDate(Date dateVersionDate) {
        this._dateVersionDate = dateVersionDate;
    }

    @JsonIgnore
    public String getHtmlData() {
        if (!StringUtils.isBlank((String)this._strJsonData)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.getFactory().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
            JsonNode jsonNode = null;
            try {
                jsonNode = mapper.readTree(this._strJsonData);
            }
            catch (IOException e) {
                return e.getLocalizedMessage();
            }
            return this.jsonToHtml(jsonNode);
        }
        return "";
    }

    private String jsonToHtml(JsonNode jsonNode) {
        StringBuilder html = new StringBuilder();
        if (jsonNode.isValueNode()) {
            html.append(jsonNode.toString());
        } else if (jsonNode.isArray()) {
            Iterator nodeList = jsonNode.elements();
            while (nodeList.hasNext()) {
                html.append(this.jsonToHtml((JsonNode)nodeList.next()));
            }
        } else {
            Iterator fields = jsonNode.fieldNames();
            html.append("<div class=\"json_object\">");
            while (fields.hasNext()) {
                String field = (String)fields.next();
                html.append("<div><span class=\"json_title\">").append(field).append("</span> : ");
                JsonNode childNode = jsonNode.get(field);
                html.append(this.jsonToHtml(childNode));
                html.append("</div>");
            }
            html.append("</div>");
        }
        return html.toString();
    }
}

