/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.business;

import fr.paris.lutece.plugins.transparency.business.ILobbyDAO;
import fr.paris.lutece.plugins.transparency.business.Lobby;
import fr.paris.lutece.portal.service.plugin.Plugin;
import fr.paris.lutece.util.ReferenceList;
import fr.paris.lutece.util.sql.DAOUtil;
import java.util.ArrayList;
import java.util.List;

public final class LobbyDAO
implements ILobbyDAO {
    private static final String SQL_QUERY_SELECT = "SELECT transparency_lobby.id_lobby, name, national_id, national_id_type, url, json_data, version_date FROM transparency_lobby ";
    private static final String SQL_QUERY_INSERT = "INSERT INTO transparency_lobby ( name, national_id, national_id_type, url, json_data, version_date ) VALUES ( ?, ?, ?, ?, ?, ? ) ";
    private static final String SQL_QUERY_DELETE = "DELETE FROM transparency_lobby WHERE id_lobby = ? ";
    private static final String SQL_QUERY_UPDATE = "UPDATE transparency_lobby SET id_lobby = ?, name = ?, national_id = ?, national_id_type = ?, url = ?, json_data = ?, version_date = ? WHERE id_lobby = ?";
    private static final String SQL_QUERY_SELECTALL_ID = "SELECT id_lobby FROM transparency_lobby";
    private static final String SQL_WHERE_NAME_LIKE = " WHERE name like ? ";
    private static final String SQL_WHERECLAUSE_BY_APPOINTMENT = " LEFT JOIN transparency_lobby_appointment on transparency_lobby_appointment.id_lobby = transparency_lobby.id_lobby WHERE id_appointment = ? ";
    private static final String SQL_WHERECLAUSE_BY_ID = " WHERE id_lobby = ? ";
    private static final String SQL_WHERECLAUSE_BY_NATIONAL_ID = " WHERE national_id = ? ";
    private static final String SQL_ORDER_BY = " ORDER BY name ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Lobby lobby, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_INSERT, Integer.valueOf(1), plugin);
        try {
            int nIndex = 1;
            daoUtil.setString(nIndex++, lobby.getName());
            daoUtil.setString(nIndex++, lobby.getNationalId());
            daoUtil.setString(nIndex++, lobby.getNationalIdType());
            daoUtil.setString(nIndex++, lobby.getUrl());
            daoUtil.setString(nIndex++, lobby.getJsonData());
            daoUtil.setDate(nIndex++, lobby.getVersionDate());
            daoUtil.executeUpdate();
            if (daoUtil.nextGeneratedKey()) {
                lobby.setId(daoUtil.getGeneratedKeyInt(1));
            }
        }
        finally {
            daoUtil.free();
        }
    }

    @Override
    public Lobby load(int nKey, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil("SELECT transparency_lobby.id_lobby, name, national_id, national_id_type, url, json_data, version_date FROM transparency_lobby  WHERE id_lobby = ? ", plugin);
        daoUtil.setInt(1, nKey);
        daoUtil.executeQuery();
        Lobby lobby = null;
        if (daoUtil.next()) {
            lobby = new Lobby();
            int nIndex = 1;
            lobby.setId(daoUtil.getInt(nIndex++));
            lobby.setName(daoUtil.getString(nIndex++));
            lobby.setNationalId(daoUtil.getString(nIndex++));
            lobby.setNationalIdType(daoUtil.getString(nIndex++));
            lobby.setUrl(daoUtil.getString(nIndex++));
            lobby.setJsonData(daoUtil.getString(nIndex++));
            lobby.setVersionDate(daoUtil.getDate(nIndex++));
        }
        daoUtil.free();
        return lobby;
    }

    @Override
    public Lobby loadByNationalId(String strNationalId, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil("SELECT transparency_lobby.id_lobby, name, national_id, national_id_type, url, json_data, version_date FROM transparency_lobby  WHERE national_id = ? ", plugin);
        daoUtil.setString(1, strNationalId);
        daoUtil.executeQuery();
        Lobby lobby = null;
        if (daoUtil.next()) {
            lobby = new Lobby();
            int nIndex = 1;
            lobby.setId(daoUtil.getInt(nIndex++));
            lobby.setName(daoUtil.getString(nIndex++));
            lobby.setNationalId(daoUtil.getString(nIndex++));
            lobby.setNationalIdType(daoUtil.getString(nIndex++));
            lobby.setUrl(daoUtil.getString(nIndex++));
            lobby.setJsonData(daoUtil.getString(nIndex++));
            lobby.setVersionDate(daoUtil.getDate(nIndex++));
        }
        daoUtil.free();
        return lobby;
    }

    @Override
    public void delete(int nKey, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_DELETE, plugin);
        daoUtil.setInt(1, nKey);
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public void store(Lobby lobby, Plugin plugin) {
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_UPDATE, plugin);
        int nIndex = 1;
        daoUtil.setInt(nIndex++, lobby.getId());
        daoUtil.setString(nIndex++, lobby.getName());
        daoUtil.setString(nIndex++, lobby.getNationalId());
        daoUtil.setString(nIndex++, lobby.getNationalIdType());
        daoUtil.setString(nIndex++, lobby.getUrl());
        daoUtil.setString(nIndex++, lobby.getJsonData());
        daoUtil.setDate(nIndex++, lobby.getVersionDate());
        daoUtil.setInt(nIndex, lobby.getId());
        daoUtil.executeUpdate();
        daoUtil.free();
    }

    @Override
    public List<Lobby> selectLobbiesList(String strLikeText, Plugin plugin) {
        ArrayList<Lobby> lobbyList = new ArrayList<Lobby>();
        String strSQL = SQL_QUERY_SELECT;
        if (strLikeText != null) {
            strSQL = strSQL + SQL_WHERE_NAME_LIKE;
        }
        strSQL = strSQL + SQL_ORDER_BY;
        DAOUtil daoUtil = new DAOUtil(strSQL, plugin);
        if (strLikeText != null) {
            daoUtil.setString(1, strLikeText);
        }
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            Lobby lobby = new Lobby();
            int nIndex = 1;
            lobby.setId(daoUtil.getInt(nIndex++));
            lobby.setName(daoUtil.getString(nIndex++));
            lobby.setNationalId(daoUtil.getString(nIndex++));
            lobby.setNationalIdType(daoUtil.getString(nIndex++));
            lobby.setUrl(daoUtil.getString(nIndex++));
            lobby.setJsonData(daoUtil.getString(nIndex++));
            lobby.setVersionDate(daoUtil.getDate(nIndex++));
            lobbyList.add(lobby);
        }
        daoUtil.free();
        return lobbyList;
    }

    @Override
    public List<Lobby> selectLobbiesListByAppointment(int idAppointment, Plugin plugin) {
        ArrayList<Lobby> lobbyList = new ArrayList<Lobby>();
        DAOUtil daoUtil = new DAOUtil("SELECT transparency_lobby.id_lobby, name, national_id, national_id_type, url, json_data, version_date FROM transparency_lobby  LEFT JOIN transparency_lobby_appointment on transparency_lobby_appointment.id_lobby = transparency_lobby.id_lobby WHERE id_appointment = ?  ORDER BY name ", plugin);
        daoUtil.setInt(1, idAppointment);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            Lobby lobby = new Lobby();
            int nIndex = 1;
            lobby.setId(daoUtil.getInt(nIndex++));
            lobby.setName(daoUtil.getString(nIndex++));
            lobby.setNationalId(daoUtil.getString(nIndex++));
            lobby.setNationalIdType(daoUtil.getString(nIndex++));
            lobby.setUrl(daoUtil.getString(nIndex++));
            lobby.setJsonData(daoUtil.getString(nIndex++));
            lobby.setVersionDate(daoUtil.getDate(nIndex++));
            lobbyList.add(lobby);
        }
        daoUtil.free();
        return lobbyList;
    }

    @Override
    public List<Integer> selectIdLobbiesList(Plugin plugin) {
        ArrayList<Integer> lobbyList = new ArrayList<Integer>();
        DAOUtil daoUtil = new DAOUtil(SQL_QUERY_SELECTALL_ID, plugin);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            lobbyList.add(daoUtil.getInt(1));
        }
        daoUtil.free();
        return lobbyList;
    }

    @Override
    public ReferenceList selectLobbiesReferenceList(Plugin plugin) {
        ReferenceList lobbyList = new ReferenceList();
        DAOUtil daoUtil = new DAOUtil("SELECT transparency_lobby.id_lobby, name, national_id, national_id_type, url, json_data, version_date FROM transparency_lobby  ORDER BY name ", plugin);
        daoUtil.executeQuery();
        while (daoUtil.next()) {
            lobbyList.addItem(daoUtil.getInt(1), daoUtil.getString(2));
        }
        daoUtil.free();
        return lobbyList;
    }
}

