/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.rs;

import fr.paris.lutece.plugins.transparency.business.Lobby;
import fr.paris.lutece.plugins.transparency.business.LobbyHome;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.util.json.AbstractJsonResponse;
import fr.paris.lutece.util.json.ErrorJsonResponse;
import fr.paris.lutece.util.json.JsonResponse;
import fr.paris.lutece.util.json.JsonUtil;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/rest/transparency/api/v{version}/lobbies")
public class LobbyRest {
    private static final int VERSION_1 = 1;
    private final Logger _logger = Logger.getLogger((String)"lutece.rest");

    @GET
    @Path(value="/search={text}")
    @Produces(value={"application/json"})
    public Response getLobbyListLike(@PathParam(value="version") Integer nVersion, @PathParam(value="text") String strLikeText) {
        switch (nVersion) {
            case 1: {
                return this.getLobbyListV1(strLikeText);
            }
        }
        this._logger.error((Object)"Version not found");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)JsonUtil.buildJsonResponse((AbstractJsonResponse)new ErrorJsonResponse(Response.Status.NOT_FOUND.name(), "Version not found"))).build();
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public Response getLobbyList(@PathParam(value="version") Integer nVersion) {
        switch (nVersion) {
            case 1: {
                return this.getLobbyListV1("");
            }
        }
        this._logger.error((Object)"Version not found");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)JsonUtil.buildJsonResponse((AbstractJsonResponse)new ErrorJsonResponse(Response.Status.NOT_FOUND.name(), "Version not found"))).build();
    }

    private Response getLobbyListV1(String strLikeText) {
        List<Lobby> _listLobbies = LobbyHome.getLobbiesListNamedLike("%" + strLikeText + "%");
        if (_listLobbies.isEmpty()) {
            JSONObject jsonNoProposal = new JSONObject();
            jsonNoProposal.put("id", -1);
            jsonNoProposal.put("value", (Object)I18nService.getLocalizedString((String)"transparency.msg.no_proposal", (Locale)I18nService.getDefaultLocale()));
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)jsonNoProposal.toString()).build();
        }
        JSONArray listJsonLobbies = new JSONArray();
        for (Lobby lobby : _listLobbies) {
            JSONObject jsonLobby = new JSONObject();
            jsonLobby.put("id", lobby.getId());
            jsonLobby.put("value", (Object)lobby.getName());
            jsonLobby.put("label", (Object)lobby.getName());
            listJsonLobbies.put((Object)jsonLobby);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)listJsonLobbies.toString()).build();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getLobby(@PathParam(value="version") Integer nVersion, @PathParam(value="id") Integer id) {
        switch (nVersion) {
            case 1: {
                return this.getLobbyV1(id);
            }
        }
        this._logger.error((Object)"Version not found");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)JsonUtil.buildJsonResponse((AbstractJsonResponse)new ErrorJsonResponse(Response.Status.NOT_FOUND.name(), "Version not found"))).build();
    }

    private Response getLobbyV1(Integer id) {
        Lobby _lobby = LobbyHome.findByPrimaryKey(id);
        if (_lobby == null) {
            this._logger.error((Object)"Resource not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)JsonUtil.buildJsonResponse((AbstractJsonResponse)new ErrorJsonResponse(Response.Status.NOT_FOUND.name(), "Resource not found"))).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonUtil.buildJsonResponse((AbstractJsonResponse)new JsonResponse((Object)_lobby))).build();
    }
}

