/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.rs;

import fr.paris.lutece.portal.service.util.AppPathService;
import fr.paris.lutece.util.json.AbstractJsonResponse;
import fr.paris.lutece.util.json.ErrorJsonResponse;
import fr.paris.lutece.util.json.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

@Path(value="/rest/transparency/api/v{version}")
public class SwaggerRest {
    private final Logger _logger = Logger.getLogger((String)"lutece.rest");
    private static final String BASE_INFOS_SCHEMES = "schemes";
    private static final String BASE_INFOS_HOST = "host";
    private static final String BASE_INFOS_BASE_PATH = "basePath";

    @GET
    @Path(value="/swagger")
    @Produces(value={"application/json"})
    public Response getSwagger(@Context HttpServletRequest request, @PathParam(value="version") String strVersion) throws MalformedURLException, IOException {
        File fileJson = new File(this.getJsonFilePath(strVersion));
        if (fileJson.exists()) {
            Map<String, String> mapBaseInfos = this.getBaseInfos(AppPathService.getBaseUrl((HttpServletRequest)request), strVersion);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode objectNode = (ObjectNode)mapper.readValue(fileJson, ObjectNode.class);
            if (objectNode.path(BASE_INFOS_HOST).isMissingNode()) {
                objectNode.put(BASE_INFOS_HOST, mapBaseInfos.get(BASE_INFOS_HOST));
            }
            if (objectNode.path(BASE_INFOS_SCHEMES).isMissingNode()) {
                objectNode.putArray(BASE_INFOS_SCHEMES).add(mapBaseInfos.get(BASE_INFOS_SCHEMES));
            }
            if (objectNode.path(BASE_INFOS_BASE_PATH).isMissingNode()) {
                objectNode.put(BASE_INFOS_BASE_PATH, mapBaseInfos.get(BASE_INFOS_BASE_PATH));
            }
            String strSwaggerJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)objectNode);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)strSwaggerJson).build();
        }
        this._logger.error((Object)"Resource not found");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)JsonUtil.buildJsonResponse((AbstractJsonResponse)new ErrorJsonResponse(Response.Status.NOT_FOUND.name(), "Resource not found"))).build();
    }

    private String getJsonFilePath(String strVersion) {
        return AppPathService.getWebAppPath() + "/plugins/" + "transparency/api" + "/swagger" + "/v" + strVersion + "/swagger.json";
    }

    private Map<String, String> getBaseInfos(String strBaseUrl, String strVersion) throws MalformedURLException {
        HashMap<String, String> map = new HashMap<String, String>();
        URL url = new URL(strBaseUrl);
        String strScheme = url.getProtocol();
        String strHost = url.getHost();
        String strBasePath = url.getPath();
        int nPort = url.getPort();
        if (nPort != -1) {
            strHost = strHost + ":" + nPort;
        }
        strBasePath = strBasePath + "rest/" + "transparency/api" + "/v" + strVersion;
        map.put(BASE_INFOS_SCHEMES, strScheme);
        map.put(BASE_INFOS_HOST, strHost);
        map.put(BASE_INFOS_BASE_PATH, strBasePath);
        return map;
    }
}

