/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.service;

import fr.paris.lutece.plugins.transparency.business.Appointment;
import fr.paris.lutece.portal.business.xsl.XslExport;
import fr.paris.lutece.portal.business.xsl.XslExportHome;
import fr.paris.lutece.portal.service.xsl.XslExportService;
import fr.paris.lutece.util.string.StringUtil;
import fr.paris.lutece.util.xml.XmlUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportAppointmentService {
    private static final int PROPERTY_XSL_EXPORT_ID = 129;
    private static final String PROPERTY_DEFAULT_OUTPUT_FILE_NAME = "export-rdv";
    private static final String CONSTANT_XML_APPOINTMENTS = "appointments";
    private static final String CONSTANT_XML_APPOINTMENT = "appointment";
    private static final String CONSTANT_XML_ID = "id";
    private static final String CONSTANT_XML_TITLE = "title";
    private static final String CONSTANT_XML_DESCRIPTION = "description";
    private static final String CONSTANT_XML_ELECTEDOFFICIALS = "electedofficials";
    private static final String CONSTANT_XML_LOBBIES = "lobbies";
    private static final String CONSTANT_XML_CONTACTS = "contacts";
    private static final String CONSTANT_XML_STARTDATE = "startdate";
    private static final String CONSTANT_MIME_TYPE_CSV = "application/csv";
    private static final String CONSTANT_MIME_TYPE_XML = "application/xml";
    private static final String CONSTANT_MIME_TYPE_TEXT_CSV = "text/csv";
    private static final String CONSTANT_MIME_TYPE_OCTETSTREAM = "application/octet-stream";
    private static final String CONSTANT_EXTENSION_CSV_FILE = ".csv";
    private static final String CONSTANT_EXTENSION_XML_FILE = ".xml";
    private static final String CONSTANT_QUOTE = "\"";
    private static final String CONSTANT_ATTACHEMENT_FILE_NAME = "attachement; filename=\"";
    private static final String CONSTANT_ATTACHEMENT_DISPOSITION = "Content-Disposition";

    public static void exportAppointmentToCSV(HttpServletRequest request, HttpServletResponse response, List<Appointment> list) throws IOException {
        int nIdXslExport = 129;
        XslExport xslExport = XslExportHome.findByPrimaryKey((int)nIdXslExport);
        StringBuffer sbXml = new StringBuffer(XmlUtil.getXmlHeader());
        XmlUtil.beginElement((StringBuffer)sbXml, (String)CONSTANT_XML_APPOINTMENTS);
        for (Appointment appointment : list) {
            sbXml.append(ExportAppointmentService.getXmlFromAppointment(appointment));
        }
        XmlUtil.endElement((StringBuffer)sbXml, (String)CONSTANT_XML_APPOINTMENTS);
        String strXml = StringUtil.replaceAccent((String)sbXml.toString());
        String strExportedAppointments = XslExportService.exportXMLWithXSL((int)nIdXslExport, (String)strXml);
        if (response != null) {
            if (CONSTANT_MIME_TYPE_CSV.contains(xslExport.getExtension())) {
                response.setContentType(CONSTANT_MIME_TYPE_CSV);
            } else if (CONSTANT_EXTENSION_XML_FILE.contains(xslExport.getExtension())) {
                response.setContentType(CONSTANT_MIME_TYPE_XML);
            } else {
                response.setContentType(CONSTANT_MIME_TYPE_OCTETSTREAM);
            }
            String strFileName = "export-rdv." + xslExport.getExtension();
            response.setHeader(CONSTANT_ATTACHEMENT_DISPOSITION, CONSTANT_ATTACHEMENT_FILE_NAME + strFileName + CONSTANT_QUOTE);
            PrintWriter out = response.getWriter();
            out.write(strExportedAppointments);
            out.flush();
            out.close();
        }
    }

    public static String getXmlFromAppointment(Appointment appointment) {
        StringBuffer sbXml = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        XmlUtil.beginElement((StringBuffer)sbXml, (String)CONSTANT_XML_APPOINTMENT);
        XmlUtil.addElement((StringBuffer)sbXml, (String)CONSTANT_XML_ID, (int)appointment.getId());
        XmlUtil.addElement((StringBuffer)sbXml, (String)CONSTANT_XML_TITLE, (String)appointment.getTitle());
        XmlUtil.addElement((StringBuffer)sbXml, (String)CONSTANT_XML_DESCRIPTION, (String)appointment.getDescription());
        XmlUtil.addElement((StringBuffer)sbXml, (String)CONSTANT_XML_STARTDATE, (String)dateFormat.format(appointment.getStartDate()));
        List electedOfficialsList = appointment.getElectedOfficialList().stream().map(e -> e.getLastName()).collect(Collectors.toList());
        XmlUtil.addElement((StringBuffer)sbXml, (String)CONSTANT_XML_ELECTEDOFFICIALS, (String)(!electedOfficialsList.isEmpty() ? (String)electedOfficialsList.get(0) : ""));
        List lobbyList = appointment.getLobbyList().stream().map(e -> e.getName()).collect(Collectors.toList());
        XmlUtil.addElement((StringBuffer)sbXml, (String)CONSTANT_XML_LOBBIES, (String)(!lobbyList.isEmpty() ? (String)lobbyList.get(0) : ""));
        XmlUtil.addElement((StringBuffer)sbXml, (String)CONSTANT_XML_CONTACTS, (String)appointment.getContacts());
        XmlUtil.endElement((StringBuffer)sbXml, (String)CONSTANT_XML_APPOINTMENT);
        return sbXml.toString();
    }
}

