/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.paris.lutece.plugins.transparency.business.Lobby;
import fr.paris.lutece.plugins.transparency.business.LobbyHome;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.portal.service.util.AppLogService;
import fr.paris.lutece.portal.service.util.AppPropertiesService;
import fr.paris.lutece.util.httpaccess.HttpAccess;
import fr.paris.lutece.util.httpaccess.HttpAccessException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public final class LobbyService {
    private static final String PROPERTY_URL_LOBBY_LIST_REFERENCE = "lobby.json.list.url";
    private static final String MSG_SYNCHRO_KEY = "transparency.message.synchro";
    private static final String MSG_ERROR_GET_JSON = "transparency.message.synchro.error";
    private static final String CONSTANT_KEY_PUBLICATIONS = "publications";
    private static final String CONSTANT_KEY_DENOMINATION = "denomination";
    private static final String CONSTANT_KEY_IDENTIFIANTNATIONAL = "identifiantNational";
    private static final String CONSTANT_KEY_TYPEIDENTIFIANTNATIONAL = "typeIdentifiantNational";
    private static final String CONSTANT_KEY_LIENSITEWEB = "lienSiteWeb";

    public static String synchronizeLobbies(Locale locale) {
        int nbLobby = 0;
        int nbLobbyCreated = 0;
        try {
            String strUri = AppPropertiesService.getProperty((String)PROPERTY_URL_LOBBY_LIST_REFERENCE);
            HttpAccess ha = new HttpAccess();
            HashMap headersRequest = new HashMap();
            HashMap headersResponse = new HashMap();
            String strJson = ha.doGet(strUri, null, null, headersRequest, headersResponse);
            if (strJson == null) {
                String msg = I18nService.getLocalizedString((String)MSG_ERROR_GET_JSON, (Locale)locale);
                msg = MessageFormat.format(msg, strUri);
                return msg;
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = null;
            try {
                jsonNode = mapper.readTree(strJson);
            }
            catch (IOException e) {
                String msg = I18nService.getLocalizedString((String)MSG_ERROR_GET_JSON, (Locale)locale);
                msg = MessageFormat.format(msg, strUri);
                AppLogService.error((Object)e);
                return msg;
            }
            Iterator lobbyList = jsonNode.path(CONSTANT_KEY_PUBLICATIONS).elements();
            while (lobbyList.hasNext()) {
                ++nbLobby;
                Lobby lobby = LobbyService.jsonToLobby((JsonNode)lobbyList.next());
                Lobby existingLobby = LobbyHome.getByNationalId(lobby.getNationalId());
                if (existingLobby != null) {
                    lobby.setId(existingLobby.getId());
                    LobbyHome.update(lobby);
                    continue;
                }
                LobbyHome.create(lobby);
                ++nbLobbyCreated;
            }
            String msg = I18nService.getLocalizedString((String)MSG_SYNCHRO_KEY, (Locale)locale);
            msg = MessageFormat.format(msg, nbLobby, nbLobbyCreated, nbLobby - nbLobbyCreated);
            return msg;
        }
        catch (HttpAccessException e) {
            AppLogService.error((Object)((Object)e));
            return e.getLocalizedMessage();
        }
    }

    private static Lobby jsonToLobby(JsonNode jsonLobby) {
        Lobby lobby = new Lobby();
        lobby.setName(jsonLobby.get(CONSTANT_KEY_DENOMINATION).asText());
        lobby.setNationalId(jsonLobby.get(CONSTANT_KEY_IDENTIFIANTNATIONAL).asText());
        if (jsonLobby.has(CONSTANT_KEY_TYPEIDENTIFIANTNATIONAL)) {
            lobby.setNationalIdType(jsonLobby.get(CONSTANT_KEY_TYPEIDENTIFIANTNATIONAL).asText());
        }
        if (jsonLobby.has(CONSTANT_KEY_LIENSITEWEB)) {
            lobby.setUrl(jsonLobby.get(CONSTANT_KEY_LIENSITEWEB).asText());
        }
        lobby.setVersionDate(new java.sql.Date(new Date().getTime()));
        lobby.setJsonData(jsonLobby.toString());
        return lobby;
    }
}

