/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.web;

import fr.paris.lutece.plugins.transparency.business.Appointment;
import fr.paris.lutece.plugins.transparency.business.AppointmentHome;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficial;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficialAppointment;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficialAppointmentHome;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficialHome;
import fr.paris.lutece.plugins.transparency.business.Lobby;
import fr.paris.lutece.plugins.transparency.business.LobbyAppointment;
import fr.paris.lutece.plugins.transparency.business.LobbyAppointmentHome;
import fr.paris.lutece.plugins.transparency.business.LobbyHome;
import fr.paris.lutece.plugins.transparency.service.ExportAppointmentService;
import fr.paris.lutece.plugins.transparency.web.AbstractManageAppointementsJspBean;
import fr.paris.lutece.portal.business.user.AdminUser;
import fr.paris.lutece.portal.service.message.AdminMessageService;
import fr.paris.lutece.portal.service.util.AppPathService;
import fr.paris.lutece.portal.util.mvc.admin.annotations.Controller;
import fr.paris.lutece.portal.util.mvc.commons.annotations.Action;
import fr.paris.lutece.portal.util.mvc.commons.annotations.View;
import fr.paris.lutece.util.ReferenceList;
import fr.paris.lutece.util.string.StringUtil;
import fr.paris.lutece.util.url.UrlItem;
import java.io.IOException;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.util.StringUtils;

@Controller(controllerJsp="ManageAppointments.jsp", controllerPath="jsp/admin/plugins/transparency/", right="TRANSPARENCY_APPOINTMENTS_MANAGEMENT")
public class AppointmentJspBean
extends AbstractManageAppointementsJspBean {
    private static final String TEMPLATE_MANAGE_APPOINTMENTS = "/admin/plugins/transparency/manage_appointments.html";
    private static final String TEMPLATE_CREATE_APPOINTMENT = "/admin/plugins/transparency/create_appointment.html";
    private static final String TEMPLATE_MODIFY_APPOINTMENT = "/admin/plugins/transparency/modify_appointment.html";
    private static final String PARAMETER_ID_APPOINTMENT = "id";
    private static final String PARAMETER_ID_ELECTED_OFFICIAL = "id_elected_official";
    private static final String PARAMETER_ID_LOBBY = "lobby_id";
    private static final String PARAMETER_SELECT_LOBBY = "lobby_select";
    private static final String PROPERTY_PAGE_TITLE_MANAGE_APPOINTMENTS = "transparency.manage_appointments.pageTitle";
    private static final String PROPERTY_PAGE_TITLE_MODIFY_APPOINTMENT = "transparency.modify_appointment.pageTitle";
    private static final String PROPERTY_PAGE_TITLE_CREATE_APPOINTMENT = "transparency.create_appointment.pageTitle";
    private static final String MARK_APPOINTMENT_LIST = "appointment_list";
    private static final String MARK_APPOINTMENT = "appointment";
    private static final String MARK_ELECTEDOFFICIALS_LIST = "electedofficials_list";
    private static final String MARK_BASE_URL = "base_url";
    private static final String JSP_MANAGE_APPOINTMENTS = "jsp/admin/plugins/transparency/ManageAppointments.jsp";
    private static final String MESSAGE_CONFIRM_REMOVE_APPOINTMENT = "transparency.message.confirmRemoveAppointment";
    private static final String VALIDATION_ATTRIBUTES_PREFIX = "transparency.model.entity.appointment.attribute.";
    private static final String VIEW_MANAGE_APPOINTMENTS = "manageAppointments";
    private static final String VIEW_CREATE_APPOINTMENT = "createAppointment";
    private static final String VIEW_MODIFY_APPOINTMENT = "modifyAppointment";
    private static final String ACTION_CREATE_APPOINTMENT = "createAppointment";
    private static final String ACTION_MODIFY_APPOINTMENT = "modifyAppointment";
    private static final String ACTION_REMOVE_APPOINTMENT = "removeAppointment";
    private static final String ACTION_EXPORT_APPOINTMENT = "exportAppointment";
    private static final String ACTION_CONFIRM_REMOVE_APPOINTMENT = "confirmRemoveAppointment";
    private static final String INFO_APPOINTMENT_CREATED = "transparency.info.appointment.created";
    private static final String INFO_APPOINTMENT_UPDATED = "transparency.info.appointment.updated";
    private static final String INFO_APPOINTMENT_REMOVED = "transparency.info.appointment.removed";
    private static final String INFO_APPOINTMENT_EXPORTED = "transparency.info.appointment.exported";
    private Appointment _appointment;

    @View(value="manageAppointments", defaultView=true)
    public String getManageAppointments(HttpServletRequest request) {
        this._appointment = null;
        AdminUser user = this.getUser();
        List<Appointment> listAppointments = AppointmentHome.getFullAppointmentsList();
        Map<String, Object> model = this.getPaginatedListModel(request, MARK_APPOINTMENT_LIST, listAppointments, JSP_MANAGE_APPOINTMENTS);
        return this.getPage(PROPERTY_PAGE_TITLE_MANAGE_APPOINTMENTS, TEMPLATE_MANAGE_APPOINTMENTS, model);
    }

    @View(value="createAppointment")
    public String getCreateAppointment(HttpServletRequest request) {
        this._appointment = this._appointment != null ? this._appointment : new Appointment();
        ReferenceList electedOfficialsList = ElectedOfficialHome.getElectedOfficialsReferenceList();
        Map model = this.getModel();
        model.put(MARK_APPOINTMENT, this._appointment);
        model.put(MARK_ELECTEDOFFICIALS_LIST, electedOfficialsList);
        model.put(MARK_BASE_URL, AppPathService.getBaseUrl((HttpServletRequest)request));
        return this.getPage(PROPERTY_PAGE_TITLE_CREATE_APPOINTMENT, TEMPLATE_CREATE_APPOINTMENT, model);
    }

    @Action(value="createAppointment")
    public String doCreateAppointment(HttpServletRequest request) {
        this.populate(this._appointment, request, request.getLocale());
        if (!this.validateBean(this._appointment, VALIDATION_ATTRIBUTES_PREFIX)) {
            return this.redirectView(request, "createAppointment");
        }
        AppointmentHome.create(this._appointment);
        String strIdElectedOfficial = request.getParameter(PARAMETER_ID_ELECTED_OFFICIAL);
        ElectedOfficial electedOfficial = ElectedOfficialHome.findByPrimaryKey(strIdElectedOfficial);
        if (electedOfficial != null) {
            ElectedOfficialAppointmentHome.create(new ElectedOfficialAppointment(strIdElectedOfficial, this._appointment.getId()));
            this._appointment.getElectedOfficialList().add(electedOfficial);
        }
        String strIdLobby = request.getParameter(PARAMETER_ID_LOBBY);
        String strSelectLobby = request.getParameter(PARAMETER_SELECT_LOBBY);
        int idLobby = StringUtil.getIntValue((String)strIdLobby, (int)-1);
        Lobby lobby = LobbyHome.findByPrimaryKey(idLobby);
        if (idLobby > 0 && lobby != null) {
            LobbyAppointmentHome.create(new LobbyAppointment(lobby.getId(), this._appointment.getId()));
            this._appointment.getLobbyList().add(lobby);
        } else if (!StringUtils.isBlank((String)strSelectLobby)) {
            Lobby newLobby = new Lobby();
            newLobby.setName(strSelectLobby);
            newLobby.setVersionDate(new Date(new java.util.Date().getTime()));
            newLobby = LobbyHome.create(newLobby);
            LobbyAppointmentHome.create(new LobbyAppointment(newLobby.getId(), this._appointment.getId()));
            this._appointment.getLobbyList().add(newLobby);
        }
        this.addInfo(INFO_APPOINTMENT_CREATED, this.getLocale());
        return this.redirectView(request, VIEW_MANAGE_APPOINTMENTS);
    }

    @Action(value="confirmRemoveAppointment")
    public String getConfirmRemoveAppointment(HttpServletRequest request) {
        int nId = Integer.parseInt(request.getParameter(PARAMETER_ID_APPOINTMENT));
        UrlItem url = new UrlItem(this.getActionUrl(ACTION_REMOVE_APPOINTMENT));
        url.addParameter(PARAMETER_ID_APPOINTMENT, nId);
        String strMessageUrl = AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_CONFIRM_REMOVE_APPOINTMENT, (String)url.getUrl(), (int)4);
        return this.redirect(request, strMessageUrl);
    }

    @Action(value="removeAppointment")
    public String doRemoveAppointment(HttpServletRequest request) {
        int nId = Integer.parseInt(request.getParameter(PARAMETER_ID_APPOINTMENT));
        AppointmentHome.remove(nId);
        this.addInfo(INFO_APPOINTMENT_REMOVED, this.getLocale());
        return this.redirectView(request, VIEW_MANAGE_APPOINTMENTS);
    }

    @View(value="modifyAppointment")
    public String getModifyAppointment(HttpServletRequest request) {
        int nId = Integer.parseInt(request.getParameter(PARAMETER_ID_APPOINTMENT));
        if (this._appointment == null || this._appointment.getId() != nId) {
            this._appointment = AppointmentHome.getFullAppointmentById(nId);
        }
        ReferenceList electedOfficialsList = ElectedOfficialHome.getElectedOfficialsReferenceList();
        Map model = this.getModel();
        model.put(MARK_APPOINTMENT, this._appointment);
        model.put(MARK_ELECTEDOFFICIALS_LIST, electedOfficialsList);
        model.put(MARK_BASE_URL, AppPathService.getBaseUrl((HttpServletRequest)request));
        return this.getPage(PROPERTY_PAGE_TITLE_MODIFY_APPOINTMENT, TEMPLATE_MODIFY_APPOINTMENT, model);
    }

    @Action(value="modifyAppointment")
    public String doModifyAppointment(HttpServletRequest request) {
        this.populate(this._appointment, request, request.getLocale());
        if (!this.validateBean(this._appointment, VALIDATION_ATTRIBUTES_PREFIX)) {
            return this.redirect(request, "modifyAppointment", PARAMETER_ID_APPOINTMENT, this._appointment.getId());
        }
        AppointmentHome.update(this._appointment);
        String strIdLobby = request.getParameter(PARAMETER_ID_LOBBY);
        String strSelectLobby = request.getParameter(PARAMETER_SELECT_LOBBY);
        int idLobby = StringUtil.getIntValue((String)strIdLobby, (int)-1);
        Lobby lobby = LobbyHome.findByPrimaryKey(idLobby);
        if (idLobby > 0 && lobby != null && lobby.getName().equals(strSelectLobby)) {
            LobbyAppointmentHome.removeByAppointmentId(this._appointment.getId());
            LobbyAppointmentHome.create(new LobbyAppointment(lobby.getId(), this._appointment.getId()));
            this._appointment.getLobbyList().add(lobby);
        } else if (!StringUtils.isBlank((String)strSelectLobby)) {
            Lobby newLobby = new Lobby();
            newLobby.setName(strSelectLobby);
            newLobby.setVersionDate(new Date(new java.util.Date().getTime()));
            newLobby = LobbyHome.create(newLobby);
            LobbyAppointmentHome.removeByAppointmentId(this._appointment.getId());
            LobbyAppointmentHome.create(new LobbyAppointment(newLobby.getId(), this._appointment.getId()));
            this._appointment.getLobbyList().add(newLobby);
        }
        this.addInfo(INFO_APPOINTMENT_UPDATED, this.getLocale());
        return this.redirectView(request, VIEW_MANAGE_APPOINTMENTS);
    }

    @Action(value="exportAppointment")
    public void doExportAppointment(HttpServletRequest request, HttpServletResponse response) {
        List<Appointment> listAppointments = AppointmentHome.getFullAppointmentsList();
        try {
            ExportAppointmentService.exportAppointmentToCSV(request, response, listAppointments);
        }
        catch (IOException ex) {
            this.addInfo(ex.getLocalizedMessage(), this.getLocale());
        }
    }
}

