/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.web;

import fr.paris.lutece.plugins.transparency.business.Appointment;
import fr.paris.lutece.plugins.transparency.business.AppointmentFilter;
import fr.paris.lutece.plugins.transparency.business.AppointmentHome;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficialHome;
import fr.paris.lutece.plugins.transparency.business.LobbyHome;
import fr.paris.lutece.portal.service.util.AppPathService;
import fr.paris.lutece.portal.service.util.AppPropertiesService;
import fr.paris.lutece.portal.util.mvc.commons.annotations.View;
import fr.paris.lutece.portal.util.mvc.xpage.MVCApplication;
import fr.paris.lutece.portal.util.mvc.xpage.annotations.Controller;
import fr.paris.lutece.portal.web.xpages.XPage;
import fr.paris.lutece.util.string.StringUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@Controller(xpageName="publicmeeting", pageTitleI18nKey="transparency.xpage.appointment.pageTitle", pagePathI18nKey="transparency.xpage.appointment.pagePathLabel")
public class AppointmentPublicXPage
extends MVCApplication {
    private static final String TEMPLATE_MANAGE_APPOINTMENTS = "/skin/plugins/transparency/manage_public_appointments.html";
    private static final String TEMPLATE_DETAIL_APPOINTMENT = "/skin/plugins/transparency/detail_public_appointment.html";
    private static final String PARAMETER_ID_APPOINTMENT = "id";
    private static final String PARAMETER_SEARCH_PERIOD = "search_period";
    private static final String PARAMETER_SEARCH_ELECTED_OFFICIAL = "search_elected_official";
    private static final String PARAMETER_SEARCH_LOBBY = "search_lobby";
    private static final String PARAMETER_SEARCH_TITLE = "search_title";
    private static final String PARAMETER_SORTED_ATTRIBUTE_NAME = "sorted_attribute_name";
    private static final String PARAMETER_START_DATE = "start_date";
    private static final String PARAMETER_ASC = "asc_sort";
    private static final String MARK_APPOINTMENT_LIST = "appointment_list";
    private static final String MARK_APPOINTMENT = "appointment";
    private static final String MARK_BASE_URL = "base_url";
    private static final String MARK_LOBBY_REFERENCE_START_URL = "lobbyReferenceStartUrl";
    private static final String PROPERTY_LOBBY_REFERENCE_START_URL_KEY = "lobby.json.detail.startUrl";
    private static final String VIEW_MANAGE_APPOINTMENTS = "manageAppointments";
    private static final String VIEW_DETAIL_APPOINTMENT = "detailAppointment";
    private Appointment _appointment;
    private List<Appointment> _appointmentList;
    private AppointmentFilter _filter = new AppointmentFilter();

    @View(value="manageAppointments", defaultView=true)
    public XPage getManageAppointments(HttpServletRequest request) {
        this._appointment = null;
        Map model = this.getModel();
        if (request.getParameter(PARAMETER_SORTED_ATTRIBUTE_NAME) != null && this._appointmentList != null) {
            if (request.getParameter(PARAMETER_SORTED_ATTRIBUTE_NAME).equals(PARAMETER_START_DATE)) {
                if (request.getParameter(PARAMETER_ASC) != null && request.getParameter(PARAMETER_ASC).equals("true")) {
                    this._appointmentList.sort((a1, a2) -> a1.getStartDate().compareTo(a2.getStartDate()));
                } else {
                    this._appointmentList.sort((a1, a2) -> a2.getStartDate().compareTo(a1.getStartDate()));
                }
            }
        } else {
            String strSearchPeriod = request.getParameter(PARAMETER_SEARCH_PERIOD);
            String strSearchElectedOfficial = request.getParameter(PARAMETER_SEARCH_ELECTED_OFFICIAL);
            String strSearchLobby = request.getParameter(PARAMETER_SEARCH_LOBBY);
            String strSearchTitle = request.getParameter(PARAMETER_SEARCH_TITLE);
            this._filter.setNumberOfDays(StringUtil.getIntValue((String)strSearchPeriod, (int)-1));
            this._filter.setLobbyName(strSearchLobby);
            this._filter.setElectedOfficialName(strSearchElectedOfficial);
            this._filter.setTitle(strSearchTitle);
            this._appointmentList = AppointmentHome.getFullAppointmentsList(this._filter);
        }
        model.put(MARK_APPOINTMENT_LIST, this._appointmentList);
        model.put(MARK_BASE_URL, AppPathService.getBaseUrl((HttpServletRequest)request));
        model.put(MARK_LOBBY_REFERENCE_START_URL, AppPropertiesService.getProperty((String)PROPERTY_LOBBY_REFERENCE_START_URL_KEY));
        return this.getXPage(TEMPLATE_MANAGE_APPOINTMENTS, request.getLocale(), model);
    }

    @View(value="detailAppointment")
    public XPage getDetailAppointment(HttpServletRequest request) {
        int nId = Integer.parseInt(request.getParameter(PARAMETER_ID_APPOINTMENT));
        if (this._appointment == null || this._appointment.getId() != nId) {
            this._appointment = AppointmentHome.findByPrimaryKey(nId);
        }
        this._appointment.setElectedOfficialList(ElectedOfficialHome.getElectedOfficialsListByAppointment(this._appointment.getId()));
        this._appointment.setLobbyList(LobbyHome.getLobbiesListByAppointment(this._appointment.getId()));
        Map model = this.getModel();
        model.put(MARK_APPOINTMENT, this._appointment);
        model.put(MARK_LOBBY_REFERENCE_START_URL, AppPropertiesService.getProperty((String)PROPERTY_LOBBY_REFERENCE_START_URL_KEY));
        return this.getXPage(TEMPLATE_DETAIL_APPOINTMENT, request.getLocale(), model);
    }
}

