/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.web;

import fr.paris.lutece.plugins.transparency.business.Appointment;
import fr.paris.lutece.plugins.transparency.business.AppointmentFilter;
import fr.paris.lutece.plugins.transparency.business.AppointmentHome;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficial;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficialAppointment;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficialAppointmentHome;
import fr.paris.lutece.plugins.transparency.business.ElectedOfficialHome;
import fr.paris.lutece.plugins.transparency.business.Lobby;
import fr.paris.lutece.plugins.transparency.business.LobbyAppointment;
import fr.paris.lutece.plugins.transparency.business.LobbyAppointmentHome;
import fr.paris.lutece.plugins.transparency.business.LobbyHome;
import fr.paris.lutece.portal.service.message.SiteMessageException;
import fr.paris.lutece.portal.service.message.SiteMessageService;
import fr.paris.lutece.portal.service.security.LuteceUser;
import fr.paris.lutece.portal.service.security.SecurityService;
import fr.paris.lutece.portal.service.security.UserNotSignedException;
import fr.paris.lutece.portal.service.util.AppPathService;
import fr.paris.lutece.portal.util.mvc.commons.annotations.Action;
import fr.paris.lutece.portal.util.mvc.commons.annotations.View;
import fr.paris.lutece.portal.util.mvc.xpage.MVCApplication;
import fr.paris.lutece.portal.util.mvc.xpage.annotations.Controller;
import fr.paris.lutece.portal.web.xpages.XPage;
import fr.paris.lutece.util.ReferenceList;
import fr.paris.lutece.util.string.StringUtil;
import fr.paris.lutece.util.url.UrlItem;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.plexus.util.StringUtils;

@Controller(xpageName="meeting", pageTitleI18nKey="transparency.xpage.appointment.pageTitle", pagePathI18nKey="transparency.xpage.appointment.pagePathLabel")
public class AppointmentXPage
extends MVCApplication {
    private static final String TEMPLATE_MANAGE_APPOINTMENTS = "/skin/plugins/transparency/manage_appointments.html";
    private static final String TEMPLATE_DETAIL_APPOINTMENT = "/skin/plugins/transparency/detail_appointment.html";
    private static final String TEMPLATE_CREATE_APPOINTMENT = "/skin/plugins/transparency/create_appointment.html";
    private static final String TEMPLATE_MODIFY_APPOINTMENT = "/skin/plugins/transparency/modify_appointment.html";
    private static final String PARAMETER_ID_APPOINTMENT = "id";
    private static final String PARAMETER_SEARCH_PERIOD = "search_period";
    private static final String PARAMETER_SEARCH_ELECTED_OFFICIAL = "search_elected_official";
    private static final String PARAMETER_SEARCH_LOBBY = "search_lobby";
    private static final String PARAMETER_SEARCH_TITLE = "search_title";
    private static final String PARAMETER_ID_ELECTED_OFFICIAL = "id_elected_official";
    private static final String PARAMETER_ID_LOBBY = "lobby_id";
    private static final String PARAMETER_SELECT_LOBBY = "lobby_select";
    private static final String PARAMETER_SORTED_ATTRIBUTE_NAME = "sorted_attribute_name";
    private static final String PARAMETER_START_DATE = "start_date";
    private static final String PARAMETER_ASC = "asc_sort";
    private static final String MARK_APPOINTMENT_LIST = "appointment_list";
    private static final String MARK_APPOINTMENT = "appointment";
    private static final String MARK_BASE_URL = "base_url";
    private static final String MARK_IS_AUTHENTICATED = "is_authenticated";
    private static final String MARK_ELECTEDOFFICIALS_LIST = "electedofficials_list";
    private static final String VIEW_MANAGE_APPOINTMENTS = "manageAppointments";
    private static final String VIEW_DETAIL_APPOINTMENT = "detailAppointment";
    private static final String VIEW_CREATE_APPOINTMENT = "createAppointment";
    private static final String VIEW_MODIFY_APPOINTMENT = "modifyAppointment";
    private static final String ACTION_CREATE_APPOINTMENT = "createAppointment";
    private static final String ACTION_MODIFY_APPOINTMENT = "modifyAppointment";
    private static final String ACTION_REMOVE_APPOINTMENT = "removeAppointment";
    private static final String ACTION_CONFIRM_REMOVE_APPOINTMENT = "confirmRemoveAppointment";
    private static final String INFO_APPOINTMENT_CREATED = "transparency.info.appointment.created";
    private static final String INFO_APPOINTMENT_UPDATED = "transparency.info.appointment.updated";
    private static final String INFO_APPOINTMENT_REMOVED = "transparency.info.appointment.removed";
    private static final String INFO_ACCESS_DENIED = "transparency.info.appointment.accessdenied";
    private static final String MESSAGE_CONFIRM_REMOVE_APPOINTMENT = "transparency.message.confirmRemoveAppointment";
    private Appointment _appointment;
    private List<Appointment> _appointmentList;
    private AppointmentFilter _filter = new AppointmentFilter();

    @View(value="manageAppointments", defaultView=true)
    public XPage getManageAppointments(HttpServletRequest request) {
        this._appointment = null;
        boolean isAuthenticated = false;
        if (request.getParameter(PARAMETER_SORTED_ATTRIBUTE_NAME) != null && this._appointmentList != null) {
            if (request.getParameter(PARAMETER_SORTED_ATTRIBUTE_NAME).equals(PARAMETER_START_DATE)) {
                if (request.getParameter(PARAMETER_ASC) != null && request.getParameter(PARAMETER_ASC).equals("true")) {
                    this._appointmentList.sort((a1, a2) -> a1.getStartDate().compareTo(a2.getStartDate()));
                } else {
                    this._appointmentList.sort((a1, a2) -> a2.getStartDate().compareTo(a1.getStartDate()));
                }
            }
        } else {
            String strSearchPeriod = request.getParameter(PARAMETER_SEARCH_PERIOD);
            String strSearchElectedOfficial = request.getParameter(PARAMETER_SEARCH_ELECTED_OFFICIAL);
            String strSearchLobby = request.getParameter(PARAMETER_SEARCH_LOBBY);
            String strSearchTitle = request.getParameter(PARAMETER_SEARCH_TITLE);
            String idUser = null;
            try {
                idUser = this.checkMyLuteceAuthentication(request);
                if (idUser != null) {
                    isAuthenticated = true;
                }
            }
            catch (UserNotSignedException e) {
                isAuthenticated = false;
            }
            this._filter.setNumberOfDays(StringUtil.getIntValue((String)strSearchPeriod, (int)-1));
            this._filter.setLobbyName(strSearchLobby);
            this._filter.setElectedOfficialName(strSearchElectedOfficial);
            this._filter.setUserId(idUser);
            this._filter.setTitle(strSearchTitle);
            this._appointmentList = AppointmentHome.getFullAppointmentsList(this._filter);
        }
        Map model = this.getModel();
        model.put(MARK_APPOINTMENT_LIST, this._appointmentList);
        model.put(MARK_BASE_URL, AppPathService.getBaseUrl((HttpServletRequest)request));
        model.put(MARK_IS_AUTHENTICATED, isAuthenticated);
        return this.getXPage(TEMPLATE_MANAGE_APPOINTMENTS, request.getLocale(), model);
    }

    @View(value="detailAppointment")
    public XPage getDetailAppointment(HttpServletRequest request) {
        int nId = Integer.parseInt(request.getParameter(PARAMETER_ID_APPOINTMENT));
        if (this._appointment == null || this._appointment.getId() != nId) {
            this._appointment = AppointmentHome.findByPrimaryKey(nId);
        }
        this._appointment.setElectedOfficialList(ElectedOfficialHome.getElectedOfficialsListByAppointment(this._appointment.getId()));
        this._appointment.setLobbyList(LobbyHome.getLobbiesListByAppointment(this._appointment.getId()));
        Map model = this.getModel();
        model.put(MARK_APPOINTMENT, this._appointment);
        return this.getXPage(TEMPLATE_DETAIL_APPOINTMENT, request.getLocale(), model);
    }

    @View(value="createAppointment")
    public XPage getCreateAppointment(HttpServletRequest request) throws UserNotSignedException {
        this._appointment = this._appointment != null ? this._appointment : new Appointment();
        String idUser = this.checkMyLuteceAuthentication(request);
        ReferenceList electedOfficialsList = ElectedOfficialHome.getElectedOfficialsReferenceListByDelegation(idUser);
        Map model = this.getModel();
        model.put(MARK_APPOINTMENT, this._appointment);
        model.put(MARK_ELECTEDOFFICIALS_LIST, electedOfficialsList);
        model.put(MARK_BASE_URL, AppPathService.getBaseUrl((HttpServletRequest)request));
        return this.getXPage(TEMPLATE_CREATE_APPOINTMENT, request.getLocale(), model);
    }

    @Action(value="createAppointment")
    public XPage doCreateAppointment(HttpServletRequest request) throws UserNotSignedException {
        String idUser = this.checkMyLuteceAuthentication(request);
        this.populate(this._appointment, request, request.getLocale());
        if (!this.validateBean(this._appointment)) {
            return this.redirectView(request, "createAppointment");
        }
        AppointmentHome.create(this._appointment);
        String strIdElectedOfficial = request.getParameter(PARAMETER_ID_ELECTED_OFFICIAL);
        ElectedOfficial electedOfficial = ElectedOfficialHome.findByPrimaryKey(strIdElectedOfficial);
        if (electedOfficial != null) {
            ElectedOfficialAppointmentHome.create(new ElectedOfficialAppointment(strIdElectedOfficial, this._appointment.getId()));
            this._appointment.getElectedOfficialList().add(electedOfficial);
        }
        String strIdLobby = request.getParameter(PARAMETER_ID_LOBBY);
        String strSelectLobby = request.getParameter(PARAMETER_SELECT_LOBBY);
        int idLobby = StringUtil.getIntValue((String)strIdLobby, (int)-1);
        Lobby lobby = LobbyHome.findByPrimaryKey(idLobby);
        if (idLobby > 0 && lobby != null) {
            LobbyAppointmentHome.create(new LobbyAppointment(lobby.getId(), this._appointment.getId()));
            this._appointment.getLobbyList().add(lobby);
        } else if (!StringUtils.isBlank((String)strSelectLobby)) {
            Lobby newLobby = new Lobby();
            newLobby.setName(strSelectLobby);
            newLobby.setVersionDate(new Date(new java.util.Date().getTime()));
            newLobby = LobbyHome.create(newLobby);
            LobbyAppointmentHome.create(new LobbyAppointment(newLobby.getId(), this._appointment.getId()));
            this._appointment.getLobbyList().add(newLobby);
        }
        this.addInfo(INFO_APPOINTMENT_CREATED, this.getLocale(request));
        return this.redirectView(request, VIEW_MANAGE_APPOINTMENTS);
    }

    @Action(value="confirmRemoveAppointment")
    public XPage getConfirmRemoveAppointment(HttpServletRequest request) throws SiteMessageException {
        int nId = Integer.parseInt(request.getParameter(PARAMETER_ID_APPOINTMENT));
        UrlItem url = new UrlItem(this.getActionFullUrl(ACTION_REMOVE_APPOINTMENT));
        url.addParameter(PARAMETER_ID_APPOINTMENT, nId);
        SiteMessageService.setMessage((HttpServletRequest)request, (String)MESSAGE_CONFIRM_REMOVE_APPOINTMENT, (int)4, (String)url.getUrl());
        return null;
    }

    @Action(value="removeAppointment")
    public XPage doRemoveAppointment(HttpServletRequest request) throws UserNotSignedException {
        String idUser = this.checkMyLuteceAuthentication(request);
        int nIdAppointment = Integer.parseInt(request.getParameter(PARAMETER_ID_APPOINTMENT));
        AppointmentFilter filter = new AppointmentFilter();
        filter.setIdAppointment(nIdAppointment);
        filter.setUserId(idUser);
        List<Appointment> listAppointment = AppointmentHome.getFullAppointmentsList(filter);
        if (listAppointment == null || listAppointment.isEmpty()) {
            this.addInfo(INFO_ACCESS_DENIED, this.getLocale(request));
            return this.redirectView(request, VIEW_MANAGE_APPOINTMENTS);
        }
        AppointmentHome.remove(nIdAppointment);
        this.addInfo(INFO_APPOINTMENT_REMOVED, this.getLocale(request));
        return this.redirectView(request, VIEW_MANAGE_APPOINTMENTS);
    }

    @View(value="modifyAppointment")
    public XPage getModifyAppointment(HttpServletRequest request) throws UserNotSignedException {
        int nIdAppointment = Integer.parseInt(request.getParameter(PARAMETER_ID_APPOINTMENT));
        String idUser = this.checkMyLuteceAuthentication(request);
        AppointmentFilter filter = new AppointmentFilter();
        filter.setIdAppointment(nIdAppointment);
        filter.setUserId(idUser);
        List<Appointment> listAppointment = AppointmentHome.getFullAppointmentsList(filter);
        if (listAppointment == null || listAppointment.isEmpty()) {
            this.addInfo(INFO_ACCESS_DENIED, this.getLocale(request));
            return this.redirectView(request, VIEW_MANAGE_APPOINTMENTS);
        }
        this._appointment = listAppointment.get(0);
        ReferenceList electedOfficialsList = ElectedOfficialHome.getElectedOfficialsReferenceListByDelegation(idUser);
        Map model = this.getModel();
        model.put(MARK_APPOINTMENT, this._appointment);
        model.put(MARK_ELECTEDOFFICIALS_LIST, electedOfficialsList);
        model.put(MARK_BASE_URL, AppPathService.getBaseUrl((HttpServletRequest)request));
        return this.getXPage(TEMPLATE_MODIFY_APPOINTMENT, request.getLocale(), model);
    }

    @Action(value="modifyAppointment")
    public XPage doModifyAppointment(HttpServletRequest request) throws UserNotSignedException {
        String idUser = this.checkMyLuteceAuthentication(request);
        this.populate(this._appointment, request, request.getLocale());
        if (!this.validateBean(this._appointment)) {
            return this.redirect(request, "modifyAppointment", PARAMETER_ID_APPOINTMENT, this._appointment.getId());
        }
        AppointmentHome.update(this._appointment);
        String strIdLobby = request.getParameter(PARAMETER_ID_LOBBY);
        String strSelectLobby = request.getParameter(PARAMETER_SELECT_LOBBY);
        int idLobby = StringUtil.getIntValue((String)strIdLobby, (int)-1);
        Lobby lobby = LobbyHome.findByPrimaryKey(idLobby);
        if (idLobby > 0 && lobby != null && lobby.getName().equals(strSelectLobby)) {
            LobbyAppointmentHome.removeByAppointmentId(this._appointment.getId());
            LobbyAppointmentHome.create(new LobbyAppointment(lobby.getId(), this._appointment.getId()));
            this._appointment.getLobbyList().add(lobby);
        } else if (!StringUtils.isBlank((String)strSelectLobby)) {
            Lobby newLobby = new Lobby();
            newLobby.setName(strSelectLobby);
            newLobby.setVersionDate(new Date(new java.util.Date().getTime()));
            newLobby = LobbyHome.create(newLobby);
            LobbyAppointmentHome.removeByAppointmentId(this._appointment.getId());
            LobbyAppointmentHome.create(new LobbyAppointment(newLobby.getId(), this._appointment.getId()));
            this._appointment.getLobbyList().add(newLobby);
        }
        this.addInfo(INFO_APPOINTMENT_UPDATED, this.getLocale(request));
        return this.redirectView(request, VIEW_MANAGE_APPOINTMENTS);
    }

    private String checkMyLuteceAuthentication(HttpServletRequest request) throws UserNotSignedException {
        if (!SecurityService.isAuthenticationEnable()) {
            return null;
        }
        LuteceUser luteceUser = SecurityService.getInstance().getRegisteredUser(request);
        if (luteceUser == null) {
            throw new UserNotSignedException();
        }
        return luteceUser.getName();
    }
}

