/*
 * Decompiled with CFR 0.152.
 */
package fr.paris.lutece.plugins.transparency.web;

import fr.paris.lutece.plugins.transparency.business.Lobby;
import fr.paris.lutece.plugins.transparency.business.LobbyHome;
import fr.paris.lutece.plugins.transparency.service.LobbyService;
import fr.paris.lutece.plugins.transparency.web.AbstractManageLobbiesJspBean;
import fr.paris.lutece.portal.service.i18n.I18nService;
import fr.paris.lutece.portal.service.message.AdminMessageService;
import fr.paris.lutece.portal.util.mvc.admin.annotations.Controller;
import fr.paris.lutece.portal.util.mvc.commons.annotations.Action;
import fr.paris.lutece.portal.util.mvc.commons.annotations.View;
import fr.paris.lutece.util.url.UrlItem;
import java.sql.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;

@Controller(controllerJsp="ManageLobbies.jsp", controllerPath="jsp/admin/plugins/transparency/", right="TRANSPARENCY_LOBBIES_MANAGEMENT")
public class LobbyJspBean
extends AbstractManageLobbiesJspBean {
    private static final String TEMPLATE_MANAGE_LOBBIES = "/admin/plugins/transparency/manage_lobbies.html";
    private static final String TEMPLATE_CREATE_LOBBY = "/admin/plugins/transparency/create_lobby.html";
    private static final String TEMPLATE_MODIFY_LOBBY = "/admin/plugins/transparency/modify_lobby.html";
    private static final String PARAMETER_ID_LOBBY = "id";
    private static final String PROPERTY_PAGE_TITLE_MANAGE_LOBBIES = "transparency.manage_lobbies.pageTitle";
    private static final String PROPERTY_PAGE_TITLE_MODIFY_LOBBY = "transparency.modify_lobby.pageTitle";
    private static final String PROPERTY_PAGE_TITLE_CREATE_LOBBY = "transparency.create_lobby.pageTitle";
    private static final String MARK_LOBBY_LIST = "lobby_list";
    private static final String MARK_LOBBY = "lobby";
    private static final String JSP_MANAGE_LOBBIES = "jsp/admin/plugins/transparency/ManageLobbies.jsp";
    private static final String MESSAGE_CONFIRM_REMOVE_LOBBY = "transparency.message.confirmRemoveLobby";
    private static final String MSG_SYNCHRO_KEY = "transparency.message.synchro";
    private static final String VALIDATION_ATTRIBUTES_PREFIX = "transparency.model.entity.lobby.attribute.";
    private static final String VIEW_MANAGE_LOBBIES = "manageLobbies";
    private static final String VIEW_CREATE_LOBBY = "createLobby";
    private static final String VIEW_MODIFY_LOBBY = "modifyLobby";
    private static final String ACTION_CREATE_LOBBY = "createLobby";
    private static final String ACTION_MODIFY_LOBBY = "modifyLobby";
    private static final String ACTION_REMOVE_LOBBY = "removeLobby";
    private static final String ACTION_CONFIRM_REMOVE_LOBBY = "confirmRemoveLobby";
    private static final String ACTION_SYNCHRONIZE_LOBBIES = "synchronizeLobbies";
    private static final String INFO_LOBBY_CREATED = "transparency.info.lobby.created";
    private static final String INFO_LOBBY_UPDATED = "transparency.info.lobby.updated";
    private static final String INFO_LOBBY_REMOVED = "transparency.info.lobby.removed";
    private Lobby _lobby;

    @View(value="manageLobbies", defaultView=true)
    public String getManageLobbies(HttpServletRequest request) {
        this._lobby = null;
        List<Lobby> listLobbies = LobbyHome.getLobbiesList();
        Map<String, Object> model = this.getPaginatedListModel(request, MARK_LOBBY_LIST, listLobbies, JSP_MANAGE_LOBBIES);
        return this.getPage(PROPERTY_PAGE_TITLE_MANAGE_LOBBIES, TEMPLATE_MANAGE_LOBBIES, model);
    }

    @View(value="createLobby")
    public String getCreateLobby(HttpServletRequest request) {
        this._lobby = this._lobby != null ? this._lobby : new Lobby();
        Map model = this.getModel();
        model.put(MARK_LOBBY, this._lobby);
        return this.getPage(PROPERTY_PAGE_TITLE_CREATE_LOBBY, TEMPLATE_CREATE_LOBBY, model);
    }

    @Action(value="createLobby")
    public String doCreateLobby(HttpServletRequest request) {
        DateConverter converter = new DateConverter(null);
        converter.setPattern(I18nService.getDateFormatShortPattern((Locale)I18nService.getDefaultLocale()));
        ConvertUtils.register((Converter)converter, Date.class);
        this.populate(this._lobby, request);
        if (!this.validateBean(this._lobby, VALIDATION_ATTRIBUTES_PREFIX)) {
            return this.redirectView(request, "createLobby");
        }
        LobbyHome.create(this._lobby);
        this.addInfo(INFO_LOBBY_CREATED, this.getLocale());
        return this.redirectView(request, VIEW_MANAGE_LOBBIES);
    }

    @Action(value="confirmRemoveLobby")
    public String getConfirmRemoveLobby(HttpServletRequest request) {
        int nId = Integer.parseInt(request.getParameter(PARAMETER_ID_LOBBY));
        UrlItem url = new UrlItem(this.getActionUrl(ACTION_REMOVE_LOBBY));
        url.addParameter(PARAMETER_ID_LOBBY, nId);
        String strMessageUrl = AdminMessageService.getMessageUrl((HttpServletRequest)request, (String)MESSAGE_CONFIRM_REMOVE_LOBBY, (String)url.getUrl(), (int)4);
        return this.redirect(request, strMessageUrl);
    }

    @Action(value="removeLobby")
    public String doRemoveLobby(HttpServletRequest request) {
        int nId = Integer.parseInt(request.getParameter(PARAMETER_ID_LOBBY));
        LobbyHome.remove(nId);
        this.addInfo(INFO_LOBBY_REMOVED, this.getLocale());
        return this.redirectView(request, VIEW_MANAGE_LOBBIES);
    }

    @View(value="modifyLobby")
    public String getModifyLobby(HttpServletRequest request) {
        int nId = Integer.parseInt(request.getParameter(PARAMETER_ID_LOBBY));
        if (this._lobby == null || this._lobby.getId() != nId) {
            this._lobby = LobbyHome.findByPrimaryKey(nId);
        }
        Map model = this.getModel();
        model.put(MARK_LOBBY, this._lobby);
        return this.getPage(PROPERTY_PAGE_TITLE_MODIFY_LOBBY, TEMPLATE_MODIFY_LOBBY, model);
    }

    @Action(value="modifyLobby")
    public String doModifyLobby(HttpServletRequest request) {
        DateConverter converter = new DateConverter(null);
        converter.setPattern(I18nService.getDateFormatShortPattern((Locale)I18nService.getDefaultLocale()));
        ConvertUtils.register((Converter)converter, Date.class);
        this.populate(this._lobby, request);
        if (!this.validateBean(this._lobby, VALIDATION_ATTRIBUTES_PREFIX)) {
            return this.redirect(request, "modifyLobby", PARAMETER_ID_LOBBY, this._lobby.getId());
        }
        LobbyHome.update(this._lobby);
        this.addInfo(INFO_LOBBY_UPDATED, this.getLocale());
        return this.redirectView(request, VIEW_MANAGE_LOBBIES);
    }

    @Action(value="synchronizeLobbies")
    public String synchronizeLobbies(HttpServletRequest request) {
        String msg = LobbyService.synchronizeLobbies(this.getLocale());
        this.addInfo(msg);
        return this.redirectView(request, VIEW_MANAGE_LOBBIES);
    }
}

